/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import to.etc.dbpool.ConnectionPool;
import to.etc.dbpool.PoolConfigSource;
import to.etc.dbpool.PoolManager;

public class PoolResourceFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object arg0, Name arg1, Context arg2, Hashtable<?, ?> arg3) throws Exception {
        ConnectionPool p;
        System.out.println("Called getObjectFactory.");
        final HashMap<String, String> map = new HashMap<String, String>();
        Reference ref = (Reference)arg0;
        Enumeration<RefAddr> e = ref.getAll();
        while (e.hasMoreElements()) {
            RefAddr ra = e.nextElement();
            String name = ra.getType();
            String val = (String)ra.getContent();
            if (name.equals("factory")) continue;
            map.put(name, val);
        }
        String id = (String)map.get("poolid");
        if (id == null) {
            throw new IllegalArgumentException("Missing 'poolid' parameter for database pool");
        }
        String pfname = (String)map.get("poolfile");
        if (pfname != null) {
            File f = new File(pfname);
            if (!f.exists()) {
                throw new IllegalArgumentException("The poolfile " + f + " does not exist");
            }
            p = PoolManager.getInstance().initializePool(f, id);
        } else {
            PoolConfigSource cs = new PoolConfigSource(){

                @Override
                public String getProperty(String section, String name) throws Exception {
                    return (String)map.get(name);
                }
            };
            p = PoolManager.getInstance().initializePool(cs, id);
        }
        return p.getPooledDataSource();
    }
}

