/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import to.etc.dbpool.BetterSQLException;
import to.etc.dbpool.ConnectionProxy;
import to.etc.dbpool.ResultSetProxy;
import to.etc.dbpool.StatementProxy;

public class PreparedStatementProxy
extends StatementProxy
implements PreparedStatement {
    private Object[] m_par = new Object[30];
    private int m_maxpar;

    PreparedStatementProxy(ConnectionProxy c, String sql) {
        super(c, sql);
    }

    @Override
    protected void appendQuery(StringBuilder sb) {
        if (this.getSQL() != null) {
            sb.append("Query: ").append(this.getSQL()).append("\n");
            if (this.m_par != null && this.m_maxpar > 0) {
                sb.append(BetterSQLException.format(this.m_par, this.m_maxpar)).append("\n");
            }
        }
    }

    public PreparedStatement getRealPreparedStatement() {
        return (PreparedStatement)this.getRealStatement();
    }

    private void _set(int ix, Object v) {
        if (ix < 1) {
            return;
        }
        if (--ix >= this.m_maxpar) {
            this.m_maxpar = ix + 1;
        }
        if (ix >= this.m_par.length) {
            Object[] nar = new Object[ix + 30];
            System.arraycopy(this.m_par, 0, nar, 0, this.m_par.length);
            this.m_par = nar;
        }
        this.m_par[ix] = v;
    }

    public Object[] internalGetParameters() {
        Object[] res = new Object[this.m_maxpar];
        System.arraycopy(this.m_par, 0, res, 0, this.m_maxpar);
        return res;
    }

    @Override
    protected SQLException wrap(SQLException x) {
        if (this.pool().c().isPrintExceptions()) {
            System.out.println("----- db: exception in statement -----");
            System.out.println("SQL: " + this.getSQL());
            System.out.println(BetterSQLException.format(this.m_par, this.m_maxpar));
            x.printStackTrace();
        }
        return new BetterSQLException(this.getSQL(), this.m_par, this.m_maxpar, x);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.pool().logExecution(this, (byte)1);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("executeQuery(): " + this.getSQL());
            LOG.fine("parameters:" + BetterSQLException.format(this.m_par, this.m_maxpar));
        }
        ResultSetProxy rpx = new ResultSetProxy(this);
        SQLException wx = null;
        try {
            this._conn().statsHandler().executePreparedQueryStart(this, rpx);
            rpx.associate(this.getRealPreparedStatement().executeQuery());
            this.pool().incOpenRS();
            this._conn().addResource(rpx);
            ResultSetProxy resultSetProxy = rpx;
            return resultSetProxy;
        }
        catch (SQLException x) {
            wx = this.wrap(x);
            throw wx;
        }
        finally {
            this._conn().statsHandler().executePreparedQueryEnd(this, wx, rpx);
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.pool().logExecution(this, (byte)2);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("executeUpdate(): " + this.getSQL());
            LOG.fine("parameters:" + BetterSQLException.format(this.m_par, this.m_maxpar));
        }
        int rc = -1;
        SQLException wx = null;
        try {
            this._conn().statsHandler().executePreparedUpdateStart(this);
            int n = rc = this.getRealPreparedStatement().executeUpdate();
            return n;
        }
        catch (SQLException x) {
            wx = this.wrap(x);
            throw wx;
        }
        finally {
            this._conn().statsHandler().executePreparedUpdateEnd(this, wx, rc);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.pool().logExecution(this, (byte)3);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("execute called");
        }
        SQLException wx = null;
        boolean res = false;
        try {
            this._conn().statsHandler().executeStart(this);
            boolean bl = res = this.getRealPreparedStatement().execute();
            return bl;
        }
        catch (SQLException x) {
            wx = this.wrap(x);
            throw wx;
        }
        finally {
            this._conn().statsHandler().executeEnd(this, wx, res);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            this._set(parameterIndex, null);
            this.getRealPreparedStatement().setNull(parameterIndex, sqlType);
        }
        catch (SQLException x) {
            throw this.wrap(x);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            this._set(parameterIndex, x);
            this.getRealPreparedStatement().setBoolean(parameterIndex, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            this._set(parameterIndex, new Byte(x));
            this.getRealPreparedStatement().setByte(parameterIndex, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            this._set(parameterIndex, new Short(x));
            this.getRealPreparedStatement().setShort(parameterIndex, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            this._set(parameterIndex, new Integer(x));
            this.getRealPreparedStatement().setInt(parameterIndex, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            this._set(parameterIndex, new Long(x));
            this.getRealPreparedStatement().setLong(parameterIndex, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            this._set(parameterIndex, new Float(x));
            this.getRealPreparedStatement().setFloat(parameterIndex, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            this._set(parameterIndex, new Double(x));
            this.getRealPreparedStatement().setDouble(parameterIndex, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            this._set(parameterIndex, x);
            this.getRealPreparedStatement().setBigDecimal(parameterIndex, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            this._set(parameterIndex, x);
            this.getRealPreparedStatement().setString(parameterIndex, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            this._set(parameterIndex, "[bytes]");
            this.getRealPreparedStatement().setBytes(parameterIndex, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            this._set(parameterIndex, x);
            this.getRealPreparedStatement().setDate(parameterIndex, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            this._set(parameterIndex, x);
            this.getRealPreparedStatement().setTime(parameterIndex, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            this._set(parameterIndex, x);
            this.getRealPreparedStatement().setTimestamp(parameterIndex, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this._set(parameterIndex, "[ascii inputstream]");
            this.getRealPreparedStatement().setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this.getRealPreparedStatement().setUnicodeStream(parameterIndex, x, length);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        try {
            this._set(parameterIndex, "[binary stream]");
            this.getRealPreparedStatement().setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            int i = this.m_par.length;
            while (--i >= 0) {
                this.m_par[i] = null;
            }
            this.getRealPreparedStatement().clearParameters();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            this._set(parameterIndex, x);
            this.getRealPreparedStatement().setObject(parameterIndex, x, targetSqlType, scale);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        try {
            this._set(parameterIndex, x);
            this.getRealPreparedStatement().setObject(parameterIndex, x, targetSqlType);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        try {
            this._set(parameterIndex, x);
            this.getRealPreparedStatement().setObject(parameterIndex, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.pool().logExecution(this, true, (byte)7);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("addBatch(prepared): " + this.getSQL());
            LOG.fine("parameters:" + BetterSQLException.format(this.m_par, this.m_maxpar));
        }
        try {
            this._conn().statsHandler().addBatch(this, this.getSQL());
            this.getRealPreparedStatement().addBatch();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            this.getRealPreparedStatement().setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        try {
            this.getRealPreparedStatement().setRef(i, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        try {
            this.getRealPreparedStatement().setBlob(i, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        try {
            this.getRealPreparedStatement().setClob(i, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        try {
            this.getRealPreparedStatement().setArray(i, x);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.getRealPreparedStatement().getMetaData();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        try {
            this._set(parameterIndex, x);
            this.getRealPreparedStatement().setDate(parameterIndex, x, cal);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        try {
            this._set(parameterIndex, x);
            this.getRealPreparedStatement().setTime(parameterIndex, x, cal);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        try {
            this._set(parameterIndex, x);
            this.getRealPreparedStatement().setTimestamp(parameterIndex, x, cal);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        try {
            this._set(paramIndex, "[dbnull]");
            this.getRealPreparedStatement().setNull(paramIndex, sqlType, typeName);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this.getRealPreparedStatement().getParameterMetaData();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setURL(int id, URL u) throws SQLException {
        try {
            this._set(id, u);
            this.getRealPreparedStatement().setURL(id, u);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        try {
            this.getRealPreparedStatement().setAsciiStream(arg0, arg1, arg2);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1) throws SQLException {
        try {
            this.getRealPreparedStatement().setAsciiStream(arg0, arg1);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        try {
            this.getRealPreparedStatement().setBinaryStream(arg0, arg1, arg2);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
        try {
            this.getRealPreparedStatement().setBinaryStream(arg0, arg1);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
        try {
            this.getRealPreparedStatement().setBlob(arg0, arg1, arg2);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setBlob(int arg0, InputStream arg1) throws SQLException {
        try {
            this.getRealPreparedStatement().setBlob(arg0, arg1);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        try {
            this.getRealPreparedStatement().setCharacterStream(arg0, arg1, arg2);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1) throws SQLException {
        try {
            this.getRealPreparedStatement().setCharacterStream(arg0, arg1);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setClob(int arg0, Reader arg1, long arg2) throws SQLException {
        try {
            this.getRealPreparedStatement().setClob(arg0, arg1, arg2);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setClob(int arg0, Reader arg1) throws SQLException {
        try {
            this.getRealPreparedStatement().setClob(arg0, arg1);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        try {
            this.getRealPreparedStatement().setNCharacterStream(arg0, arg1, arg2);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1) throws SQLException {
        try {
            this.getRealPreparedStatement().setNCharacterStream(arg0, arg1);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setNClob(int arg0, NClob arg1) throws SQLException {
        try {
            this.getRealPreparedStatement().setNClob(arg0, arg1);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setNClob(int arg0, Reader arg1, long arg2) throws SQLException {
        try {
            this.getRealPreparedStatement().setNClob(arg0, arg1, arg2);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setNClob(int arg0, Reader arg1) throws SQLException {
        try {
            this.getRealPreparedStatement().setNClob(arg0, arg1);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setNString(int arg0, String arg1) throws SQLException {
        try {
            this._set(arg0, arg1);
            this.getRealPreparedStatement().setNString(arg0, arg1);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setRowId(int arg0, RowId arg1) throws SQLException {
        try {
            this._set(arg0, arg1);
            this.getRealPreparedStatement().setRowId(arg0, arg1);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setSQLXML(int arg0, SQLXML arg1) throws SQLException {
        try {
            this._set(arg0, arg1);
            this.getRealPreparedStatement().setSQLXML(arg0, arg1);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }
}

