/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import to.etc.dbpool.PoolConfigSource;

public class PropertiesSource
extends PoolConfigSource {
    private Properties m_prop;
    private Properties m_backup;

    public PropertiesSource(File src, File back) {
        super(src, back);
    }

    private synchronized void init() throws Exception {
        if (this.m_prop != null) {
            return;
        }
        if (!this.getSrc().exists()) {
            throw new IllegalArgumentException("The pool manager config file " + this.getSrc() + " does not exist.");
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.getSrc());
            this.m_prop = new Properties();
            this.m_prop.load(is);
            ((InputStream)is).close();
            is = null;
            if (this.getBackupSrc() != null && this.getBackupSrc().exists()) {
                is = new FileInputStream(this.getBackupSrc());
                this.m_backup = new Properties();
                this.m_backup.load(is);
            }
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public String getProperty(String section, String name) throws Exception {
        String res;
        this.init();
        String key = section + "." + name;
        if (this.m_backup != null && (res = this.m_backup.getProperty(key)) != null) {
            return res;
        }
        return this.m_prop.getProperty(key);
    }
}

