/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import to.etc.dbpool.BetterSQLException;
import to.etc.dbpool.ConnectionProxy;
import to.etc.dbpool.DbPoolUtil;
import to.etc.dbpool.IConnectionEventListener;
import to.etc.dbpool.PreparedStatementProxy;
import to.etc.dbpool.StatementProxy;
import to.etc.dbpool.Tracepoint;

public class ResultSetProxy
implements ResultSet {
    private StatementProxy m_statement;
    private ResultSet m_rs;
    private final IConnectionEventListener m_statsHandler;
    private final ConnectionProxy m_pc;
    private String m_close_rsn;
    private String m_sql;
    private Object[] m_par;
    private Tracepoint m_allocationLocation;
    long m_ts_allocated;
    int m_rowCount;
    long m_ts_released;
    long m_ts_executeEnd;
    boolean m_prepared;

    ResultSetProxy(StatementProxy sp) {
        this.m_statement = sp;
        this.m_statsHandler = sp._conn().statsHandler();
        this.m_pc = sp._conn();
        this.m_sql = sp.getSQL();
        if (sp instanceof PreparedStatementProxy) {
            this.m_par = ((PreparedStatementProxy)sp).internalGetParameters();
        }
        if (sp.pool().c().isLogResultSetLocations()) {
            this.m_allocationLocation = Tracepoint.create(sp.getSQL());
        }
    }

    void associate(ResultSet rs) {
        this.m_rs = rs;
    }

    public String internalGetCloseReason() {
        return this.m_close_rsn;
    }

    public String getSQL() {
        return this.m_sql;
    }

    public int internalGetRowCount() {
        return this.m_rowCount;
    }

    public long internalGetFetchDuration() {
        return this.m_ts_released - this.m_ts_allocated;
    }

    protected void internalDumpInfo() {
        StringBuilder sb = new StringBuilder(512);
        if (this.m_sql != null) {
            sb.append("ResultSet Query: ").append(this.m_sql).append("\n");
            if (this.m_par != null && this.m_par.length > 0) {
                sb.append(BetterSQLException.format(this.m_par, this.m_par.length)).append("\n");
            }
        }
        if (this.m_allocationLocation != null) {
            sb.append("ResultSet was allocated at:\n");
            DbPoolUtil.strStacktraceFiltered(sb, this.m_allocationLocation.getElements());
        }
        if (sb.length() > 0) {
            System.out.println(sb);
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this.m_rs.absolute(row);
    }

    @Override
    public void afterLast() throws SQLException {
        this.m_rs.afterLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.m_rs.beforeFirst();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.m_rs.cancelRowUpdates();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.m_rs.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        if (this.m_rs == null) {
            return;
        }
        try {
            this.m_pc.removeResource(this);
            this.m_rs.close();
        }
        finally {
            this.m_rs = null;
        }
        this.m_statsHandler.resultSetClosed(this.m_statement, this);
    }

    public void closedByConnection() throws SQLException {
        if (this.m_rs != null) {
            this.m_close_rsn = "Closed because connection was closed";
            System.out.println("---- ResultSet forced CLOSED because connection is closed ----");
            this.internalDumpInfo();
            DbPoolUtil.dumpLocation("Location of close");
            try {
                this.m_rs.close();
            }
            finally {
                this.m_rs = null;
            }
            this.m_statsHandler.resultSetClosed(this.m_statement, this);
        }
    }

    @Override
    public boolean next() throws SQLException {
        boolean r = this.m_rs.next();
        if (r) {
            ++this.m_rowCount;
        }
        return r;
    }

    @Override
    public void deleteRow() throws SQLException {
        this.m_rs.deleteRow();
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.m_rs.findColumn(columnName);
    }

    @Override
    public boolean first() throws SQLException {
        return this.m_rs.first();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        return this.m_rs.getArray(i);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.m_rs.getArray(colName);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.m_rs.getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.m_rs.getAsciiStream(columnName);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.m_rs.getBigDecimal(columnIndex, scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.m_rs.getBigDecimal(columnIndex);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.m_rs.getBigDecimal(columnName, scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.m_rs.getBigDecimal(columnName);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.m_rs.getBinaryStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.m_rs.getBinaryStream(columnName);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        return this.m_rs.getBlob(i);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.m_rs.getBlob(colName);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.m_rs.getBoolean(columnIndex);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.m_rs.getBoolean(columnName);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.m_rs.getByte(columnIndex);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.m_rs.getByte(columnName);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.m_rs.getBytes(columnIndex);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.m_rs.getBytes(columnName);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.m_rs.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.m_rs.getCharacterStream(columnName);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        return this.m_rs.getClob(i);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.m_rs.getClob(colName);
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.m_rs.getConcurrency();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.m_rs.getCursorName();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.m_rs.getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.m_rs.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.m_rs.getDate(columnName, cal);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.m_rs.getDate(columnName);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.m_rs.getDouble(columnIndex);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.m_rs.getDouble(columnName);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.m_rs.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.m_rs.getFetchSize();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.m_rs.getFloat(columnIndex);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.m_rs.getFloat(columnName);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.m_rs.getInt(columnIndex);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.m_rs.getInt(columnName);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.m_rs.getLong(columnIndex);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.m_rs.getLong(columnName);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.m_rs.getMetaData();
    }

    public Object getObject(int arg0, Map arg1) throws SQLException {
        return this.m_rs.getObject(arg0, arg1);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.m_rs.getObject(columnIndex);
    }

    public Object getObject(String arg0, Map arg1) throws SQLException {
        return this.m_rs.getObject(arg0, arg1);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.m_rs.getObject(columnName);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        return this.m_rs.getRef(i);
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.m_rs.getRef(colName);
    }

    @Override
    public int getRow() throws SQLException {
        return this.m_rs.getRow();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.m_rs.getShort(columnIndex);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.m_rs.getShort(columnName);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.m_rs.getStatement();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.m_rs.getString(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.m_rs.getString(columnName);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.m_rs.getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.m_rs.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.m_rs.getTime(columnName, cal);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.m_rs.getTime(columnName);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.m_rs.getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.m_rs.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.m_rs.getTimestamp(columnName, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.m_rs.getTimestamp(columnName);
    }

    @Override
    public int getType() throws SQLException {
        return this.m_rs.getType();
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.m_rs.getUnicodeStream(columnIndex);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.m_rs.getUnicodeStream(columnName);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.m_rs.getURL(columnIndex);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.m_rs.getURL(columnName);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.m_rs.getWarnings();
    }

    @Override
    public void insertRow() throws SQLException {
        this.m_rs.insertRow();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.m_rs.isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.m_rs.isBeforeFirst();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.m_rs.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.m_rs.isLast();
    }

    @Override
    public boolean last() throws SQLException {
        return this.m_rs.last();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.m_rs.moveToCurrentRow();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.m_rs.moveToInsertRow();
    }

    @Override
    public boolean previous() throws SQLException {
        return this.m_rs.previous();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.m_rs.refreshRow();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.m_rs.relative(rows);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.m_rs.rowDeleted();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.m_rs.rowInserted();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.m_rs.rowUpdated();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.m_rs.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.m_rs.setFetchSize(rows);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.m_rs.updateArray(columnIndex, x);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.m_rs.updateArray(columnName, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.m_rs.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.m_rs.updateAsciiStream(columnName, x, length);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.m_rs.updateBigDecimal(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.m_rs.updateBigDecimal(columnName, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.m_rs.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.m_rs.updateBinaryStream(columnName, x, length);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.m_rs.updateBlob(columnIndex, x);
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.m_rs.updateBlob(columnName, x);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.m_rs.updateBoolean(columnIndex, x);
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.m_rs.updateBoolean(columnName, x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.m_rs.updateByte(columnIndex, x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.m_rs.updateByte(columnName, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.m_rs.updateBytes(columnIndex, x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.m_rs.updateBytes(columnName, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.m_rs.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.m_rs.updateCharacterStream(columnName, reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.m_rs.updateClob(columnIndex, x);
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.m_rs.updateClob(columnName, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.m_rs.updateDate(columnIndex, x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.m_rs.updateDate(columnName, x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.m_rs.updateDouble(columnIndex, x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.m_rs.updateDouble(columnName, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.m_rs.updateFloat(columnIndex, x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.m_rs.updateFloat(columnName, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.m_rs.updateInt(columnIndex, x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.m_rs.updateInt(columnName, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.m_rs.updateLong(columnIndex, x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.m_rs.updateLong(columnName, x);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.m_rs.updateNull(columnIndex);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.m_rs.updateNull(columnName);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.m_rs.updateObject(columnIndex, x, scale);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.m_rs.updateObject(columnIndex, x);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.m_rs.updateObject(columnName, x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.m_rs.updateObject(columnName, x);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.m_rs.updateRef(columnIndex, x);
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        this.m_rs.updateRef(columnName, x);
    }

    @Override
    public void updateRow() throws SQLException {
        this.m_rs.updateRow();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.m_rs.updateShort(columnIndex, x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.m_rs.updateShort(columnName, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.m_rs.updateString(columnIndex, x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.m_rs.updateString(columnName, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.m_rs.updateTime(columnIndex, x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.m_rs.updateTime(columnName, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.m_rs.updateTimestamp(columnIndex, x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.m_rs.updateTimestamp(columnName, x);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.m_rs.wasNull();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.m_rs.getHoldability();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.m_rs.getNCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.m_rs.getNCharacterStream(columnLabel);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return this.m_rs.getNClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.m_rs.getNClob(columnLabel);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.m_rs.getNString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.m_rs.getNString(columnLabel);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this.m_rs.getRowId(columnIndex);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.m_rs.getRowId(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.m_rs.getSQLXML(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.m_rs.getSQLXML(columnLabel);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_rs.isClosed();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.m_rs.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.m_rs.unwrap(iface);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.m_rs.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.m_rs.updateAsciiStream(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.m_rs.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.m_rs.updateAsciiStream(columnLabel, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.m_rs.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.m_rs.updateBinaryStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.m_rs.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.m_rs.updateBinaryStream(columnLabel, x);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.m_rs.updateBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.m_rs.updateBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.m_rs.updateBlob(columnLabel, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.m_rs.updateBlob(columnLabel, inputStream);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.m_rs.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.m_rs.updateCharacterStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_rs.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.m_rs.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.m_rs.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.m_rs.updateClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_rs.updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.m_rs.updateClob(columnLabel, reader);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.m_rs.updateNCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.m_rs.updateNCharacterStream(columnIndex, x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_rs.updateNCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.m_rs.updateNCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.m_rs.updateNClob(columnIndex, nClob);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.m_rs.updateNClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.m_rs.updateNClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.m_rs.updateNClob(columnLabel, nClob);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_rs.updateNClob(columnLabel, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.m_rs.updateNClob(columnLabel, reader);
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.m_rs.updateNString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.m_rs.updateNString(columnLabel, nString);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.m_rs.updateRowId(columnIndex, x);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.m_rs.updateRowId(columnLabel, x);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.m_rs.updateSQLXML(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.m_rs.updateSQLXML(columnLabel, xmlObject);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return this.m_rs.getObject(columnIndex, type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.m_rs.getObject(columnLabel, type);
    }
}

