/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import to.etc.dbpool.BetterSQLException;
import to.etc.dbpool.ConnectionPool;
import to.etc.dbpool.ConnectionProxy;
import to.etc.dbpool.DbPoolUtil;
import to.etc.dbpool.ResultSetProxy;
import to.etc.dbpool.Tracepoint;

public class StatementProxy
implements Statement {
    protected static Logger LOG = Logger.getLogger(StatementProxy.class.getName());
    private Statement m_st;
    private final ConnectionProxy m_c;
    private String m_sql_str;
    private String m_closeReason;
    @Nullable
    private Tracepoint m_closeLocation;
    private Tracepoint m_allocationLocation;
    private int m_timeout;
    long m_tsStart;
    public static final byte ST_QUERY = 1;
    public static final byte ST_UPDATE = 2;
    public static final byte ST_EXECUTE = 3;
    public static final byte ST_COMMIT = 4;
    public static final byte ST_ROLLBACK = 5;
    public static final byte ST_CLOSE = 6;
    public static final byte ST_BATCH = 7;

    StatementProxy(ConnectionProxy c, String sql) {
        this.m_sql_str = sql;
        this.m_c = c;
        if (c.getPool().c().isLogResultSetLocations()) {
            this.m_allocationLocation = Tracepoint.create(null);
        }
        this.m_timeout = c.getPool().getForceTimeout();
    }

    void associate(Statement st) throws SQLException {
        this.m_st = st;
        this.handleTimeout(st);
    }

    private void handleTimeout(Statement ps) throws SQLException {
        if (this.m_timeout <= 0) {
            return;
        }
        ps.setQueryTimeout(this.m_timeout);
    }

    @Override
    public void close() throws SQLException {
        if (this.m_st == null) {
            return;
        }
        this.m_closeReason = "Normal close call";
        try {
            this.m_st.close();
        }
        finally {
            this.m_st = null;
            try {
                this.m_c.removeResource(this);
            }
            catch (Exception x) {
                System.out.println("Failed to remove resource from connection: " + x + ", at:\n" + DbPoolUtil.getLocation());
            }
        }
    }

    public Connection getRealConnection() {
        this.getRealStatement();
        return this.m_c.getRealConnection();
    }

    protected ConnectionProxy _conn() {
        return this.m_c;
    }

    protected ConnectionPool pool() {
        return this._conn().getPool();
    }

    public void closedByConnection() throws SQLException {
        if (this.m_st != null) {
            this.m_closeReason = "Closed because connection was closed";
            this.m_closeLocation = this.m_c.getCloseLocation();
            StringBuilder sb = new StringBuilder(512);
            sb.append("---- Statement forced CLOSED because connection is closed ----\n");
            this.appendQuery(sb);
            if (this.m_allocationLocation != null) {
                sb.append("StatementProxy was allocated at:\n");
                DbPoolUtil.strStacktraceFiltered(sb, this.m_allocationLocation.getElements());
            }
            if (sb.length() > 0) {
                System.out.println(sb);
            }
            DbPoolUtil.dumpLocation("Location of close");
            try {
                this.m_st.close();
            }
            finally {
                this.m_st = null;
            }
        }
    }

    protected void appendQuery(StringBuilder sb) {
        if (this.getSQL() != null) {
            sb.append("Query: ").append(this.getSQL()).append("\n");
        }
    }

    protected void internalDumpInfo() {
    }

    public String getSQL() {
        return this.m_sql_str;
    }

    protected SQLException wrap(SQLException x) {
        if (this._conn().getPool().c().isPrintExceptions()) {
            System.out.println("----- db: exception in statement -----");
            System.out.println("SQL: " + this.getSQL());
            x.printStackTrace();
        }
        return new BetterSQLException(this.getSQL(), null, 0, x);
    }

    public Statement getRealStatement() {
        if (this.m_st == null) {
            Tracepoint closeLocation = this.m_closeLocation;
            throw new IllegalStateException("This statement has been CLOSED: " + this.m_closeReason, closeLocation == null ? null : closeLocation.getException());
        }
        return this.m_st;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.m_sql_str = sql;
        this.pool().logExecution(this, (byte)1);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("executeQuery: " + sql);
        }
        ResultSetProxy rpx = new ResultSetProxy(this);
        SQLException wx = null;
        try {
            this.m_c.statsHandler().executeQueryStart(this, rpx);
            rpx.associate(this.m_st.executeQuery(sql));
            this._conn().getPool().incOpenRS();
            this._conn().addResource(rpx);
            ResultSetProxy resultSetProxy = rpx;
            return resultSetProxy;
        }
        catch (SQLException x) {
            wx = this.wrap(x);
            throw wx;
        }
        finally {
            this.m_c.statsHandler().executeQueryEnd(this, wx, rpx);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.m_sql_str = sql;
        this.pool().logExecution(this, (byte)2);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("executeUpdate: " + sql);
        }
        int rc = -1;
        SQLException wx = null;
        try {
            this.m_c.statsHandler().executeUpdateStart(this);
            int n = rc = this.getRealStatement().executeUpdate(sql);
            return n;
        }
        catch (SQLException x) {
            wx = this.wrap(x);
            throw wx;
        }
        finally {
            this.m_c.statsHandler().executeUpdateEnd(this, wx, rc);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.m_sql_str = sql;
        this.pool().logExecution(this, (byte)3);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("execute: " + sql);
        }
        Boolean res = null;
        SQLException wx = null;
        try {
            this.m_c.statsHandler().executeStart(this);
            boolean b = this.getRealStatement().execute(sql);
            res = b;
            boolean bl = b;
            this.m_c.statsHandler().executeEnd(this, wx, res);
            return bl;
        }
        catch (SQLException x) {
            try {
                wx = this.wrap(x);
                throw wx;
            }
            catch (Throwable throwable) {
                this.m_c.statsHandler().executeEnd(this, wx, res);
                throw throwable;
            }
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.m_sql_str = sql;
        this.pool().logExecution(this, (byte)7);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("addBatch: " + sql);
        }
        try {
            this.m_c.statsHandler().addBatch(this, sql);
            this.getRealStatement().addBatch(sql);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] res = null;
        this.pool().logBatch();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("executeBatch called");
        }
        SQLException wx = null;
        try {
            this.m_c.statsHandler().executeBatchStart(this);
            int[] nArray = res = this.getRealStatement().executeBatch();
            return nArray;
        }
        catch (SQLException xx) {
            wx = this.wrap(xx);
            throw wx;
        }
        finally {
            this.m_c.statsHandler().executeBatchEnd(this, wx, res);
        }
    }

    @Override
    public boolean execute(String sql, String[] ar) throws SQLException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("execute: " + sql);
        }
        this.m_sql_str = sql;
        this.pool().logExecution(this, (byte)3);
        SQLException wx = null;
        Boolean res = null;
        try {
            this.m_c.statsHandler().executeStart(this);
            boolean b = this.getRealStatement().execute(sql, ar);
            res = b;
            boolean bl = b;
            this.m_c.statsHandler().executeEnd(this, wx, res);
            return bl;
        }
        catch (SQLException x) {
            try {
                wx = this.wrap(x);
                throw wx;
            }
            catch (Throwable throwable) {
                this.m_c.statsHandler().executeEnd(this, wx, res);
                throw throwable;
            }
        }
    }

    @Override
    public boolean execute(String sql, int[] p2) throws SQLException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("execute: " + sql);
        }
        this.m_sql_str = sql;
        this.pool().logExecution(this, (byte)3);
        Boolean res = null;
        SQLException wx = null;
        try {
            this.m_c.statsHandler().executeStart(this);
            boolean b = this.getRealStatement().execute(sql, p2);
            res = b;
            boolean bl = b;
            this.m_c.statsHandler().executeEnd(this, wx, res);
            return bl;
        }
        catch (SQLException x) {
            try {
                wx = this.wrap(x);
                throw wx;
            }
            catch (Throwable throwable) {
                this.m_c.statsHandler().executeEnd(this, wx, res);
                throw throwable;
            }
        }
    }

    @Override
    public boolean execute(String sql, int p2) throws SQLException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("execute: " + sql);
        }
        this.m_sql_str = sql;
        this.pool().logExecution(this, (byte)3);
        SQLException wx = null;
        Boolean res = null;
        try {
            this.m_c.statsHandler().executeStart(this);
            boolean b = this.getRealStatement().execute(sql, p2);
            res = b;
            boolean bl = b;
            this.m_c.statsHandler().executeEnd(this, wx, res);
            return bl;
        }
        catch (SQLException x) {
            try {
                wx = this.wrap(x);
                throw wx;
            }
            catch (Throwable throwable) {
                this.m_c.statsHandler().executeEnd(this, wx, res);
                throw throwable;
            }
        }
    }

    @Override
    public int executeUpdate(String sql, String[] ar) throws SQLException {
        this.m_sql_str = sql;
        this.pool().logExecution(this, (byte)2);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("executeUpdate: " + sql);
        }
        int res = -1;
        SQLException wx = null;
        try {
            this.m_c.statsHandler().executeUpdateStart(this);
            int n = res = this.getRealStatement().executeUpdate(sql, ar);
            return n;
        }
        catch (SQLException x) {
            wx = this.wrap(x);
            throw wx;
        }
        finally {
            this.m_c.statsHandler().executeUpdateEnd(this, wx, res);
        }
    }

    @Override
    public int executeUpdate(String sql, int[] ar) throws SQLException {
        this.m_sql_str = sql;
        this.pool().logExecution(this, (byte)2);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("executeUpdate: " + sql);
        }
        int res = -1;
        SQLException wx = null;
        try {
            this.m_c.statsHandler().executeUpdateStart(this);
            int n = res = this.getRealStatement().executeUpdate(sql, ar);
            return n;
        }
        catch (SQLException x) {
            wx = this.wrap(x);
            throw wx;
        }
        finally {
            this.m_c.statsHandler().executeUpdateEnd(this, wx, res);
        }
    }

    @Override
    public int executeUpdate(String sql, int p2) throws SQLException {
        this.m_sql_str = sql;
        this.pool().logExecution(this, (byte)2);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("executeUpdate: " + sql);
        }
        int res = -1;
        SQLException wx = null;
        try {
            this.m_c.statsHandler().executeUpdateStart(this);
            int n = res = this.getRealStatement().executeUpdate(sql, p2);
            return n;
        }
        catch (SQLException x) {
            wx = this.wrap(x);
            throw wx;
        }
        finally {
            this.m_c.statsHandler().executeUpdateEnd(this, wx, res);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this.getRealStatement().getMaxFieldSize();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            this.getRealStatement().setMaxFieldSize(max);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this.getRealStatement().getMaxRows();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        try {
            this.getRealStatement().setMaxRows(max);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this.getRealStatement().setEscapeProcessing(enable);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this.getRealStatement().getQueryTimeout();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.getRealStatement().setQueryTimeout(seconds);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.getRealStatement().cancel();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.getRealStatement().getWarnings();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.getRealStatement().clearWarnings();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            this.getRealStatement().setCursorName(name);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this.getRealStatement().getResultSet();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            int rc = this.getRealStatement().getUpdateCount();
            return rc;
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return this.getRealStatement().getMoreResults();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.getRealStatement().setFetchDirection(direction);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this.getRealStatement().getFetchDirection();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            this.getRealStatement().setFetchSize(rows);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this.getRealStatement().getFetchSize();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.getRealStatement().getResultSetConcurrency();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this.getRealStatement().getResultSetType();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.getRealStatement().clearBatch();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.getRealStatement();
        return this.m_c;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.getRealStatement().getResultSetHoldability();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.getRealStatement().getGeneratedKeys();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public boolean getMoreResults(int m) throws SQLException {
        try {
            return this.getRealStatement().getMoreResults(m);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.getRealStatement().isClosed();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            return this.getRealStatement().isPoolable();
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this.getRealStatement().isWrapperFor(iface);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        try {
            this.getRealStatement().setPoolable(arg0);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this.getRealStatement().unwrap(iface);
        }
        catch (SQLException xx) {
            throw this.wrap(xx);
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.getRealStatement().closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.getRealStatement().isCloseOnCompletion();
    }
}

