/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import to.etc.dbpool.ConnectionProxy;
import to.etc.dbpool.IStatisticsListener;
import to.etc.dbpool.StatementProxy;
import to.etc.dbpool.info.BatchEntry;

final class StatisticsListenerMultiplexer
implements IStatisticsListener {
    private Map<String, IStatisticsListener> m_list = new HashMap<String, IStatisticsListener>();

    StatisticsListenerMultiplexer() {
    }

    private void check() {
        if (this.m_list.size() == 0) {
            System.out.println("No listeners registered!!");
        }
    }

    public void addCollector(String key, IStatisticsListener ic) {
        if (null != this.m_list.put(key, ic)) {
            System.out.println("POOLERR: Duplicate statistics collector with key=" + key);
        }
    }

    public IStatisticsListener removeCollector(String key) {
        return this.m_list.remove(key);
    }

    @Override
    public void connectionAllocated(ConnectionProxy proxy) {
        this.check();
        for (IStatisticsListener ic : this.m_list.values()) {
            ic.connectionAllocated(proxy);
        }
    }

    @Override
    public void connectionClosed(ConnectionProxy proxy) {
        this.check();
        for (IStatisticsListener ic : this.m_list.values()) {
            ic.connectionClosed(proxy);
        }
    }

    @Override
    public void statementPrepared(StatementProxy sp, long prepareDuration) {
        this.check();
        for (IStatisticsListener ic : this.m_list.values()) {
            ic.statementPrepared(sp, prepareDuration);
        }
    }

    @Override
    public void queryStatementExecuted(StatementProxy sp, long executeDuration, long fetchDuration, int rowCount, boolean prepared) {
        this.check();
        for (IStatisticsListener ic : this.m_list.values()) {
            ic.queryStatementExecuted(sp, executeDuration, fetchDuration, rowCount, prepared);
        }
    }

    @Override
    public void executeUpdateExecuted(StatementProxy sp, long updateDuration, int updatedrowcount) {
        this.check();
        for (IStatisticsListener ic : this.m_list.values()) {
            ic.executeUpdateExecuted(sp, updateDuration, updatedrowcount);
        }
    }

    @Override
    public void executeExecuted(StatementProxy sp, long updateDuration, Boolean result) {
        this.check();
        for (IStatisticsListener ic : this.m_list.values()) {
            ic.executeExecuted(sp, updateDuration, result);
        }
    }

    @Override
    public void executePreparedUpdateExecuted(StatementProxy sp, long updateDuration, int rowcount) {
        this.check();
        for (IStatisticsListener ic : this.m_list.values()) {
            ic.executePreparedUpdateExecuted(sp, updateDuration, rowcount);
        }
    }

    @Override
    public void executeBatchExecuted(long executeDuration, int totalStatements, int totalRows, List<BatchEntry> list) {
        this.check();
        for (IStatisticsListener ic : this.m_list.values()) {
            ic.executeBatchExecuted(executeDuration, totalStatements, totalRows, list);
        }
    }

    @Override
    public void finish() {
        this.check();
        for (IStatisticsListener ic : this.m_list.values()) {
            ic.finish();
        }
    }
}

