/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import to.etc.dbpool.ConnectionProxy;
import to.etc.dbpool.PoolManager;
import to.etc.dbpool.info.GlobalPerformanceStore;
import to.etc.dbpool.info.OracleStatisticsCreator;
import to.etc.dbpool.info.PerformanceCollector;
import to.etc.dbpool.info.SessionStatistics;
import to.etc.dbpool.info.StatisticsCollector;
import to.etc.dbpool.info.StatisticsCollectorBase;

public final class StatisticsRequestListener
implements ServletRequestListener {
    private static final int MAX_SESSION_REQUESTS = 50;
    private static final boolean DEBUG = false;
    private static String m_forceEncoding;
    private static boolean m_encodingSet;
    private static volatile boolean m_enableSessionStatisticsForEveryone;
    private static final ThreadLocal<PerThreadData> m_perThreadData;
    private static GlobalPerformanceStore m_globalStore;
    private static UnclosedListener m_unclosedListener;
    private static long m_nextId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed(ServletRequestEvent ev) {
        GlobalPerformanceStore global;
        StatisticsCollector statisticsCollector;
        List<ConnectionProxy> uncl;
        ServletRequest sr = ev.getServletRequest();
        if (!(sr instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest r = (HttpServletRequest)sr;
        PerThreadData threadData = m_perThreadData.get();
        if (threadData == null) {
            return;
        }
        --threadData.m_count;
        if (threadData.m_count != 0) {
            return;
        }
        m_perThreadData.set(null);
        UnclosedListener ucl = StatisticsRequestListener.getUnclosedListener();
        if (null != ucl && (uncl = PoolManager.getInstance().getThreadConnections()).size() > 0) {
            ucl.unclosed(r, uncl);
        }
        if (null == (statisticsCollector = (StatisticsCollector)PoolManager.getInstance().stopCollecting(this.getClass().getName()))) {
            return;
        }
        long duration = System.nanoTime() - statisticsCollector.getStartTS();
        PerformanceCollector pc = new PerformanceCollector();
        pc.saveCounters(statisticsCollector.getIdent(), statisticsCollector.getCounters());
        SessionStatistics sessionStatistics = threadData.m_sessionStatistics;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            global = m_globalStore;
        }
        if (global != null || sessionStatistics != null) {
            Object object;
            StatisticsCollectorBase icb = new StatisticsCollectorBase(statisticsCollector, duration);
            if (null != global) {
                object = global.getStore();
                synchronized (object) {
                    global.getStore().merge(pc);
                    global.addRequestInfo(icb);
                }
            }
            if (null != sessionStatistics) {
                object = sessionStatistics;
                synchronized (object) {
                    sessionStatistics.addRequestInfo(threadData.m_id, pc, icb);
                }
            }
        }
        statisticsCollector.reportSimple();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestInitialized(ServletRequestEvent ev) {
        StatisticsCollector ic;
        ServletRequest sr = ev.getServletRequest();
        if (!(sr instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest r = (HttpServletRequest)sr;
        PerThreadData threadData = m_perThreadData.get();
        if (threadData != null) {
            ++threadData.m_count;
            return;
        }
        PoolManager.getInstance().clearThreadConnections();
        threadData = new PerThreadData();
        threadData.m_count = 1;
        m_perThreadData.set(threadData);
        this.updateEncoding(r);
        this.checkEnableStatisticsParameter(r);
        if (!PoolManager.getInstance().isCollectStatistics()) {
            return;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (m_globalStore == null) {
                m_globalStore = new GlobalPerformanceStore();
            }
        }
        if (m_enableSessionStatisticsForEveryone) {
            threadData.m_sessionStatistics = StatisticsRequestListener.createSessionStats(r);
        } else {
            String val = r.getParameter("__session");
            if (null != val) {
                if ("on".equals(val) || val.startsWith("t")) {
                    threadData.m_sessionStatistics = StatisticsRequestListener.createSessionStats(r);
                } else if ("off".equals(val) || val.startsWith("f")) {
                    StatisticsRequestListener.destroySessionStats(r);
                }
            } else {
                threadData.m_sessionStatistics = StatisticsRequestListener.getSessionStatistics(r);
            }
        }
        threadData.m_id = StatisticsRequestListener.nextID();
        threadData.m_collector = ic = new StatisticsCollector(r.getRequestURI(), r.getQueryString(), threadData.m_sessionStatistics != null);
        PoolManager.getInstance().startCollecting(this.getClass().getName(), ic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEnableStatisticsParameter(HttpServletRequest r) {
        String val = r.getParameter("__statistics");
        if (null != val) {
            if ("on".equals(val = val.toLowerCase()) || val.startsWith("t")) {
                PoolManager.getInstance().setCollectStatistics(true);
            } else if ("off".equals(val) || val.startsWith("f")) {
                PoolManager.getInstance().setCollectStatistics(false);
                StatisticsRequestListener.destroySessionStats(r);
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    m_globalStore = null;
                }
            }
        }
        if (null != (val = r.getParameter("__trace"))) {
            OracleStatisticsCreator.enableSessionTrace("on".equals(val = val.toLowerCase()) || val.startsWith("t"));
        }
    }

    private void updateEncoding(HttpServletRequest r) {
        String enc = r.getCharacterEncoding();
        if ((null == enc || enc.trim().length() == 0) && (enc = this.getForceEncoding()) != null) {
            try {
                r.setCharacterEncoding(enc);
            }
            catch (UnsupportedEncodingException x) {
                throw new RuntimeException(x);
            }
        }
    }

    private static synchronized String nextID() {
        return Long.toString(StatisticsRequestListener.nextIDNr(), 36);
    }

    private static long nextIDNr() {
        return ++m_nextId;
    }

    public static void setSessionStatistics(boolean on) {
        m_enableSessionStatisticsForEveryone = on;
    }

    @Nullable
    public static final StatisticsCollectorBase getThreadStatistics() {
        PerThreadData perThreadData = m_perThreadData.get();
        if (null == perThreadData) {
            return null;
        }
        StatisticsCollector collector = perThreadData.m_collector;
        if (null == collector) {
            return null;
        }
        long duration = System.nanoTime() - collector.getStartTS();
        return new StatisticsCollectorBase(collector, duration);
    }

    @Nullable
    public static final String getRequestID() {
        PerThreadData perThreadData = m_perThreadData.get();
        if (null == perThreadData) {
            return null;
        }
        return perThreadData.m_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroySessionStats(HttpServletRequest r) {
        HttpSession hs = r.getSession(false);
        if (null == hs) {
            return;
        }
        HttpSession httpSession = hs;
        synchronized (httpSession) {
            hs.removeAttribute(StatisticsRequestListener.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static SessionStatistics createSessionStats(HttpServletRequest r) {
        HttpSession hs;
        HttpSession httpSession = hs = r.getSession(true);
        synchronized (httpSession) {
            SessionStatistics ss = (SessionStatistics)hs.getAttribute(StatisticsRequestListener.class.getName());
            if (null != ss) {
                return ss;
            }
            ss = new SessionStatistics(50);
            hs.setAttribute(StatisticsRequestListener.class.getName(), (Object)ss);
            return ss;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static SessionStatistics getSessionStatistics(HttpServletRequest r) {
        HttpSession hs = r.getSession(false);
        if (null == hs) {
            return null;
        }
        HttpSession httpSession = hs;
        synchronized (httpSession) {
            return (SessionStatistics)hs.getAttribute(StatisticsRequestListener.class.getName());
        }
    }

    public static synchronized GlobalPerformanceStore getGlobalStore() {
        return m_globalStore;
    }

    public static synchronized void setForceEncoding(String forceEncoding) {
        m_forceEncoding = forceEncoding;
        m_encodingSet = true;
    }

    private synchronized String getForceEncoding() {
        if (!m_encodingSet) {
            throw new RuntimeException("**** INPUT ENCODING NOT DEFINED FOR DBPOOL'S STATISTICS FILTER!!\nYou have added the to.etc.dbpool.StatisticsRequestListener to your web.xml.\nThere is of course a bug in Internet Explorer where it does not sent proper encoding\ninformation (the charset header) in data it sends back to the server. If that happens the\nserver guesses the encoding- usually wrong. This would lead to encoding errors (strange\ncharacters) in input from the browser. The only way to prevent this is to add a call in your\nweb app initialization: StatisticsRequestListener.setForceEncoding(\"utf-8\");\n");
        }
        return m_forceEncoding;
    }

    public static synchronized void setUnclosedListener(UnclosedListener ucl) {
        m_unclosedListener = ucl;
        PoolManager.getInstance().setCheckCloseConnections(true);
    }

    private static synchronized UnclosedListener getUnclosedListener() {
        return m_unclosedListener;
    }

    static {
        m_perThreadData = new ThreadLocal();
    }

    public static interface UnclosedListener {
        public void unclosed(HttpServletRequest var1, List<ConnectionProxy> var2);
    }

    private static class PerThreadData {
        public int m_count;
        @Nullable
        public StatisticsCollector m_collector;
        @Nullable
        public SessionStatistics m_sessionStatistics;
        @Nullable
        public String m_id;
    }
}

