/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import to.etc.dbpool.PoolConfigSource;

public class XmlSource
extends PoolConfigSource {
    private Node m_src;
    private Node m_backup;

    public XmlSource(File src, File back) {
        super(src, back);
    }

    private synchronized void init() throws Exception {
        if (this.m_src != null) {
            return;
        }
        if (!this.getSrc().exists()) {
            throw new IllegalArgumentException("The pool manager config file " + this.getSrc() + " does not exist.");
        }
        this.m_src = this.getDocument(this.getSrc(), false);
        if (this.getBackupSrc() != null && this.getBackupSrc().exists()) {
            this.m_backup = this.getDocument(this.getBackupSrc(), false);
        }
    }

    private Node getDocument(File f, boolean nsaware) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(nsaware);
        DocumentBuilder db = dbf.newDocumentBuilder();
        FileInputStream is = null;
        DefaultErrorHandler deh = new DefaultErrorHandler();
        try {
            is = new FileInputStream(f);
            db.setErrorHandler(deh);
            InputSource ins = new InputSource(is);
            ins.setPublicId(f.toString());
            Document doc = db.parse(ins);
            if (deh.hasErrors()) {
                throw new Exception(f + ": xml parse errors: " + deh.getErrors());
            }
            Node node = XmlSource.getRootElement(doc);
            return node;
        }
        catch (IOException x) {
            throw new IOException("XML Parser IO error on " + f + ": " + x.toString());
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static Node getRootElement(Document doc) throws Exception {
        NodeList nl = doc.getChildNodes();
        Node root = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            if (root != null) {
                throw new IllegalStateException("Multiple root nodes in document: " + root.getNodeName() + " and " + n.getNodeName());
            }
            root = n;
        }
        if (root == null) {
            throw new IllegalStateException("No root node in XML document.");
        }
        return root;
    }

    private Node findPoolNode(Node root, String sec) throws Exception {
        NodeList nl = root.getChildNodes();
        Node found = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            String s;
            Node nn;
            NamedNodeMap m;
            Node n = nl.item(i);
            if (!n.getNodeName().equals("pool") || (m = n.getAttributes()) == null || (nn = m.getNamedItem("name")) == null || (s = nn.getNodeValue()) == null || !sec.equals(s.trim())) continue;
            if (found != null) {
                throw new Exception("Duplicate pool ID=" + sec + " in xml file");
            }
            found = n;
        }
        return found;
    }

    private String getValue(Node pool, String name) throws Exception {
        NamedNodeMap m = pool.getAttributes();
        if (m == null) {
            return null;
        }
        Node n = m.getNamedItem(name);
        if (n == null) {
            return null;
        }
        if (n.getNodeValue() == null) {
            return "";
        }
        return n.getNodeValue().trim();
    }

    private String getValue(Node root, String section, String name) throws Exception {
        Node pool = this.findPoolNode(root, section);
        if (pool == null) {
            return null;
        }
        return this.getValue(pool, name);
    }

    @Override
    public String getProperty(String section, String name) throws Exception {
        this.init();
        String v = null;
        if (null != this.m_backup) {
            v = this.getValue(this.m_backup, section, name);
        }
        if (v == null) {
            v = this.getValue(this.m_src, section, name);
        }
        return v;
    }

    static class DefaultErrorHandler
    implements ErrorHandler {
        private StringBuilder m_xmlerr_sb = new StringBuilder();
        private boolean m_errors;

        DefaultErrorHandler() {
        }

        private void genErr(SAXParseException exception, String type) {
            String id;
            if (this.m_xmlerr_sb.length() > 0) {
                this.m_xmlerr_sb.append("\n");
            }
            if ((id = exception.getPublicId()) == null || id.length() == 0) {
                id = exception.getPublicId();
            }
            if (id == null || id.length() == 0) {
                id = "unknown-source";
            }
            this.m_xmlerr_sb.append(id);
            this.m_xmlerr_sb.append('(');
            this.m_xmlerr_sb.append(Integer.toString(exception.getLineNumber()));
            this.m_xmlerr_sb.append(':');
            this.m_xmlerr_sb.append(Integer.toString(exception.getColumnNumber()));
            this.m_xmlerr_sb.append(") ");
            this.m_xmlerr_sb.append(type);
            this.m_xmlerr_sb.append(":");
            this.m_xmlerr_sb.append(exception.getMessage());
        }

        @Override
        public final void warning(SAXParseException exception) throws SAXException {
            this.genErr(exception, "warning");
        }

        @Override
        public final void error(SAXParseException exception) throws SAXException {
            this.m_errors = true;
            this.genErr(exception, "error");
        }

        @Override
        public final void fatalError(SAXParseException exception) throws SAXException {
            this.m_errors = true;
            this.genErr(exception, "fatal");
        }

        public String getErrors() {
            return this.m_xmlerr_sb.toString();
        }

        public boolean hasErrors() {
            return this.m_errors;
        }
    }
}

