/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool.info;

import to.etc.dbpool.info.MetricsDefinition;

public final class DbMetric {
    private final MetricsDefinition m_definition;
    private double m_value;

    public DbMetric(MetricsDefinition md, double value) {
        this.m_definition = md;
        this.m_value = value;
    }

    public DbMetric(DbMetric src) {
        this.m_definition = src.m_definition;
        this.m_value = src.m_value;
    }

    public MetricsDefinition getDefinition() {
        return this.m_definition;
    }

    public double getValue() {
        return this.m_value;
    }

    public void setValue(double val) {
        this.m_value = val;
    }

    public String getKey() {
        return this.m_definition.getKey();
    }

    public String getLabel() {
        return this.m_definition.getLabel();
    }

    public String getDescription() {
        return this.m_definition.getDescription();
    }

    public String getFormattedValue() {
        return this.m_definition.getTranslator().translate(this.getValue());
    }

    public String toString() {
        return this.m_definition.toString() + " = " + this.m_value;
    }
}

