/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool.info;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import to.etc.dbpool.info.PerfItem;
import to.etc.dbpool.info.PerfList;
import to.etc.dbpool.info.PerformanceCollector;
import to.etc.dbpool.info.PerformanceStore;
import to.etc.dbpool.info.StatisticsCollectorBase;

public final class GlobalPerformanceStore {
    private static final String REQ_EXEC_TIME = "request-exec-time";
    private static final String REQ_CONNALLOCS = "request-connection-allocations";
    private final PerformanceStore m_store = new PerformanceCollector();

    public GlobalPerformanceStore() {
        this.m_store.define(REQ_EXEC_TIME, "REQ: slowest requests", true, 20);
        this.m_store.define(REQ_CONNALLOCS, "REQ: largest #of connection allocations", true, 20);
    }

    public PerformanceStore getStore() {
        return this.m_store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PerfList> getLists() {
        List<PerfList> dupl;
        PerformanceStore performanceStore = this.m_store;
        synchronized (performanceStore) {
            dupl = this.m_store.getLists();
        }
        Collections.sort(dupl, new Comparator<PerfList>(){

            @Override
            public int compare(PerfList a, PerfList b) {
                return a.getKey().compareTo(b.getKey());
            }
        });
        return dupl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerfList getList(String name) {
        PerformanceStore performanceStore = this.m_store;
        synchronized (performanceStore) {
            return this.m_store.getList(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PerfItem> getItems(String listKey) {
        PerformanceStore performanceStore = this.m_store;
        synchronized (performanceStore) {
            return this.m_store.getItems(listKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestInfo(StatisticsCollectorBase icb) {
        if (icb.getNAnything() == 0L) {
            return;
        }
        PerformanceStore performanceStore = this.getStore();
        synchronized (performanceStore) {
            this.m_store.addItem(REQ_EXEC_TIME, icb.getIdent(), icb.getDuration(), null, icb);
            this.m_store.addItem(REQ_CONNALLOCS, icb.getIdent(), icb.getNConnectionAllocations(), null, icb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        PerformanceStore performanceStore = this.getStore();
        synchronized (performanceStore) {
            this.getStore().clear();
        }
    }
}

