/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool.info;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import to.etc.dbpool.ConnState;
import to.etc.dbpool.ConnectionPool;
import to.etc.dbpool.ConnectionProxy;
import to.etc.dbpool.DbPoolUtil;
import to.etc.dbpool.PoolManager;
import to.etc.dbpool.PoolStats;
import to.etc.dbpool.StatisticsRequestListener;
import to.etc.dbpool.info.GlobalPerformanceStore;
import to.etc.dbpool.info.JsTemplater;
import to.etc.dbpool.info.PerfItem;
import to.etc.dbpool.info.PerfList;
import to.etc.dbpool.info.SessionStatistics;
import to.etc.dbpool.info.SessionStatisticsEntry;

public final class JspPageHandler {
    private JspWriter m_out;
    private HttpServletRequest m_request;
    private ConnectionPool m_pool;
    private String m_message;
    private String m_jspname;
    private String m_url;
    private int m_timeout = 0;
    private boolean m_error;
    private boolean m_odd;
    private GlobalPerformanceStore m_globalStore;
    private SessionStatistics m_sessionStats;
    private boolean m_intag;
    private ScriptEngine m_scripter;

    public JspPageHandler(JspWriter out, HttpServletRequest request, String jspname) {
        this.m_out = out;
        this.m_request = request;
        this.m_jspname = jspname;
        this.m_globalStore = StatisticsRequestListener.getGlobalStore();
        this.m_sessionStats = StatisticsRequestListener.getSessionStatistics(request);
    }

    public JspWriter getOut() {
        return this.m_out;
    }

    public HttpServletRequest getRequest() {
        return this.m_request;
    }

    private String getParam(String name) {
        String s = this.getRequest().getParameter(name);
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s;
    }

    public ConnectionPool getPool() {
        if (null == this.m_pool) {
            this.addError("The command requires the pool= parameter and a valid pool id");
            return null;
        }
        return this.m_pool;
    }

    public String getMessage() {
        return this.m_message;
    }

    public void addMessage(String msg) {
        this.m_timeout = 5;
        this.m_url = this.m_jspname;
        this.m_message = this.m_message == null ? msg : this.m_message + "<br>" + msg;
    }

    public void addError(String msg) {
        this.addMessage(msg);
        this.m_error = true;
    }

    private void executeHandler(String name) throws Exception {
        Method m;
        try {
            m = this.getClass().getMethod(name, new Class[0]);
        }
        catch (Exception x) {
            throw new IllegalStateException("Unknown pool display task: " + name);
        }
        try {
            m.invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException x) {
            if (x.getCause() instanceof Exception) {
                throw (Exception)x.getCause();
            }
            throw x;
        }
    }

    private static String niceName(String in) {
        if (in == null || in.length() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        char c = in.charAt(0);
        sb.append(Character.toUpperCase(c));
        sb.append(in.substring(1).toLowerCase());
        return sb.toString();
    }

    public void initialize() throws Exception {
        String s = this.getRequest().getParameter("pool");
        if (null != s) {
            this.m_pool = PoolManager.getInstance().getPool(s);
            if (null == this.m_pool) {
                this.addError("The database pool " + s + " is not found.");
                return;
            }
        }
        this.m_url = this.m_jspname;
        s = this.getParam("action");
        if (null != s) {
            this.executeHandler("action" + JspPageHandler.niceName(s));
            if (this.m_error) {
                return;
            }
        }
        if (this.m_timeout == 0 && this.getParam("show") == null) {
            this.m_timeout = 30;
        }
    }

    public void displayPage() throws Exception {
        if (this.getMessage() != null) {
            this.expandTemplate("jspMessage", new Object[0]);
            return;
        }
        String s = this.getParam("show");
        if (s == null) {
            this.showIndex();
        } else {
            this.executeHandler("show" + JspPageHandler.niceName(s));
        }
    }

    public void generateRefresh() throws IOException {
        if (this.m_timeout > 0) {
            this.tag("meta", "http-equiv", "refresh", "content", this.m_timeout + ";URL=" + this.m_url);
            this.finishOpenTag();
        }
    }

    public void tag(String name, String ... attr) throws IOException {
        this.finishOpenTag();
        this.m_intag = true;
        this.getOut().append((CharSequence)"<").append(name);
        if ((attr.length & 1) != 0) {
            throw new IllegalStateException("Usage error: need even set of attribute name/value.");
        }
        for (int i = 0; i < attr.length; i += 2) {
            String an = attr[i];
            String av = attr[i + 1];
            this.attr(an, av);
        }
    }

    public void etag(String name) throws IOException {
        this.finishOpenTag();
        this.getOut().append((CharSequence)"</").append(name).append(">");
    }

    public JspPageHandler full(String name, String ... attr) throws IOException {
        this.tag(name, attr);
        this.finishOpenTag();
        return this;
    }

    public JspPageHandler text(String text) throws IOException {
        this.getOut().append((CharSequence)DbPoolUtil.q(text));
        return this;
    }

    public JspPageHandler tagText(String tag, String text, String ... attr) throws IOException {
        this.full(tag, attr);
        this.text(text);
        this.etag(tag);
        return this;
    }

    public JspPageHandler nl() throws IOException {
        this.getOut().append((CharSequence)"\n");
        return this;
    }

    public JspPageHandler attr(String name, String value) throws IOException {
        if (!this.m_intag) {
            throw new IllegalStateException("Usage error: need to be in tag.");
        }
        this.getOut().append((CharSequence)" ").append(name).append("=\"");
        value = value.replace("\"", "&quot;");
        this.getOut().append((CharSequence)value).append("\"");
        return this;
    }

    private void finishOpenTag() throws IOException {
        if (this.m_intag) {
            this.m_intag = false;
            this.getOut().append((CharSequence)">");
        }
    }

    public void h1(String text) throws IOException {
        this.tagText("h1", text, new String[0]);
    }

    private String urlBuilder(String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_jspname);
        for (int i = 0; i < args.length; i += 2) {
            sb.append(i == 0 ? "?" : "&");
            sb.append(args[i]);
            sb.append('=');
            sb.append(args[i + 1]);
        }
        return sb.toString();
    }

    public void actionTag(ConnectionPool pool, String action, String text) throws IOException {
        String url = this.urlBuilder("pool", pool.getID(), "action", action);
        this.tagText("a", text, "href", url);
    }

    public void showTag(ConnectionPool pool, String action, String text) throws IOException {
        String url = this.urlBuilder("pool", pool.getID(), "show", action);
        this.tagText("a", text, "href", url);
    }

    public void atag(String contents, String ... args) throws IOException {
        this.tagText("a", contents, "href", this.urlBuilder(args));
    }

    public void backlink() throws IOException {
        this.tagText("a", "<--- Back to the main page", "href", this.m_jspname);
    }

    public String odd() {
        this.m_odd = !this.m_odd;
        return this.m_odd ? "odd" : "even";
    }

    public long now() {
        return System.currentTimeMillis();
    }

    public void actionTraceon() throws Exception {
        ConnectionPool pool = this.getPool();
        if (null == pool) {
            return;
        }
        this.addMessage("Use tracing for pool " + pool.getID() + " enabled.");
        pool.dbgSetStacktrace(true);
    }

    public void actionTraceoff() throws Exception {
        ConnectionPool pool = this.getPool();
        if (null == pool) {
            return;
        }
        this.addMessage("Use tracing for pool " + pool.getID() + " disabled.");
        pool.dbgSetStacktrace(false);
    }

    public void actionErrorson() throws Exception {
        ConnectionPool pool = this.getPool();
        if (null == pool) {
            return;
        }
        this.addMessage("Error logging for pool " + pool.getID() + " enabled.");
        pool.setSaveErrors(true);
    }

    public void actionErrorsoff() throws Exception {
        ConnectionPool pool = this.getPool();
        if (null == pool) {
            return;
        }
        this.addMessage("Error logging for pool " + pool.getID() + " disabled.");
        pool.setSaveErrors(false);
    }

    public void actionSessionon() throws Exception {
        this.addMessage("Session statistics collection has been ENABLED. Do not forget to disable to prevent out-of-memory errors!!!");
        StatisticsRequestListener.createSessionStats(this.getRequest());
    }

    public void actionSessionoff() throws Exception {
        this.addMessage("Session statistics collection has been DISABLED and data has been destroyed.");
        StatisticsRequestListener.destroySessionStats(this.getRequest());
    }

    public void actionForceexpired() throws Exception {
        ConnectionPool pool = this.getPool();
        if (null == pool) {
            return;
        }
        this.addError("Forced hanging connection expiry for pool " + pool.getID());
        pool.scanExpiredConnections(120, true);
    }

    public void actionClearglobal() throws Exception {
        if (this.m_globalStore != null) {
            this.m_globalStore.clear();
            this.addMessage("Global statistics cleared");
        } else {
            this.addMessage("?? Statistics not enabled??");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResource(String name) throws IOException {
        InputStream is = null;
        try {
            int szrd;
            File inf = new File("/home/jal/bzr/trunk-newpool/shared/to.etc.db/src/to/etc/dbpool/info/" + name);
            is = inf.exists() ? new FileInputStream(inf) : this.getClass().getResourceAsStream(name);
            if (null == is) {
                throw new IllegalStateException("Unknown classpath-resource " + name);
            }
            InputStreamReader isr = new InputStreamReader(is, "utf-8");
            char[] data = new char[1024];
            StringBuilder sb = new StringBuilder();
            while (0 < (szrd = isr.read(data))) {
                sb.append(data, 0, szrd);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private ScriptEngine getScripter() throws Exception {
        if (this.m_scripter == null) {
            ScriptEngineManager em = new ScriptEngineManager();
            this.m_scripter = em.getEngineByName("JavaScript");
            Bindings b = this.m_scripter.getBindings(100);
            b.put("this", (Object)this);
            b.put("out", (Object)this.getOut());
            b.put("pool", (Object)this.m_pool);
            b.put("self", (Object)this);
            this.m_scripter.eval("load(\"nashorn:mozilla_compat.js\")");
            this.m_scripter.eval("importPackage(Packages.to.etc.dbpool)");
        }
        return this.m_scripter;
    }

    public void expandTemplate(String name, Object ... values) throws Exception {
        name = name + ".html";
        String resource = this.readResource(name);
        this.getScripter().getBindings(100).put("javax.script.filename", (Object)name);
        this.expandTemplateString(resource, values);
    }

    private void expandTemplateString(String resource, Object[] values) throws Exception {
        boolean hascode = false;
        int ix = 0;
        int len = resource.length();
        while (ix < len) {
            int mark = resource.indexOf("<%", ix);
            if (mark == -1) {
                this.getOut().append((CharSequence)resource, ix, len);
                return;
            }
            this.getOut().append((CharSequence)resource, ix, mark);
            int emark = resource.indexOf("%>", mark += 2);
            if (emark == -1) {
                this.getOut().append((CharSequence)"<%");
                ix = mark;
                continue;
            }
            ix = emark + 2;
            boolean asexpr = false;
            if (resource.charAt(mark) == '=') {
                asexpr = true;
                ++mark;
            }
            String code = resource.substring(mark, emark);
            ScriptEngine se = this.getScripter();
            if (!hascode) {
                for (int i = 0; i < values.length; i += 2) {
                    String name = (String)values[i];
                    Object value = values[i + 1];
                    se.put(name, value);
                }
                hascode = true;
            }
            Object res = se.eval(code);
            if (!asexpr || res == null) continue;
            this.getOut().append((CharSequence)res.toString());
        }
    }

    public void expandTemplate2(String name, Object ... values) throws Exception {
        name = name + ".html";
        String resource = this.readResource(name);
        ScriptEngine se = this.getScripter();
        se.getBindings(100).put("javax.script.filename", (Object)name);
        for (int i = 0; i < values.length; i += 2) {
            String vname = (String)values[i];
            Object value = values[i + 1];
            se.put(vname, value);
        }
        JsTemplater tp = new JsTemplater();
        String exp = tp.replaceTemplate(resource);
        try {
            se.eval(exp);
        }
        catch (Exception x) {
            System.out.println("**** Javascript Template error ****\nJavascript:\n");
            System.out.println(exp);
            System.out.println("Error: " + x);
            throw x;
        }
    }

    public void write(String s) throws IOException {
        this.getOut().append((CharSequence)s);
    }

    public void writeExpr(Object o) throws IOException {
        if (null == o) {
            return;
        }
        this.write(String.valueOf(o));
    }

    public void showIndex() throws Exception {
        ConnectionPool[] par = PoolManager.getInstance().getPoolList();
        if (null != this.m_globalStore) {
            this.tagText("a", "Show global statistics", "href", this.urlBuilder("show", "globalstats"));
            this.text("\u00a0\u00a0\u00a0");
            if (null == StatisticsRequestListener.getSessionStatistics(this.getRequest())) {
                this.atag("Enable session tracing", "action", "sessionon");
            } else {
                this.atag("Show session trace", "show", "session");
                this.text("\u00a0\u00a0\u00a0");
                this.atag("Disable session tracing", "action", "sessionoff");
                this.text("\u00a0\u00a0\u00a0");
            }
            this.text("\u00a0\u00a0\u00a0");
            this.atag("Disable statistics", "__statistics", "f");
        } else {
            this.text("Statistics disabled in database pool config. Click ");
            this.atag("here", "__statistics", "t");
            this.text(" to enable them.");
        }
        this.full("br", new String[0]);
        this.h1("All defined database pools - overview");
        this.displayPoolOverview(par);
    }

    private void displayPoolOverview(ConnectionPool[] poolar) throws Exception {
        this.expandTemplate("jspPoolOverview", new Object[0]);
        boolean odd = false;
        for (ConnectionPool pool : poolar) {
            odd = !odd;
            String css = odd ? "oddpool" : "evenpool";
            PoolStats ps = pool.getPoolStatistics();
            int udangles = 0;
            int pdangles = 0;
            for (ConnectionProxy px : ps.getCurrentlyHangingConnections()) {
                if (px.isUnpooled()) {
                    ++udangles;
                    continue;
                }
                ++pdangles;
            }
            this.expandTemplate("jspPoolEntry", "pool", pool, "udangles", udangles, "pdangles", pdangles, "ps", ps, "css", css);
        }
        this.etag("table");
    }

    private void displayPoolOverview(ConnectionPool pool) throws Exception {
        this.displayPoolOverview(new ConnectionPool[]{pool});
    }

    public void showHanging() throws Exception {
        ConnectionPool pool = this.getPool();
        if (pool == null) {
            return;
        }
        this.backlink();
        this.h1("Hanging connections for pool " + pool.getID());
        this.displayPoolOverview(pool);
        PoolStats ps = pool.getPoolStatistics();
        ArrayList<ConnectionProxy> res = new ArrayList<ConnectionProxy>();
        for (ConnectionProxy px : ps.getCurrentlyHangingConnections()) {
            if (px.getState() != ConnState.OPEN) continue;
            res.add(px);
        }
        this.expandTemplate("jspHangingOverview", "pool", pool, "ps", ps);
        for (ConnectionProxy px : res) {
            this.expandTemplate2("jspHangingEntry", "pool", pool, "ps", ps, "px", px);
        }
        this.etag("table");
    }

    public void showUsed() throws Exception {
        ConnectionPool pool = this.getPool();
        if (pool == null) {
            return;
        }
        this.backlink();
        this.h1("Used connections for pool " + pool.getID());
        this.displayPoolOverview(pool);
        PoolStats ps = pool.getPoolStatistics();
        ArrayList<ConnectionProxy> res = new ArrayList<ConnectionProxy>();
        for (ConnectionProxy px : pool.getUsedConnections()) {
            if (px.getState() != ConnState.OPEN) continue;
            res.add(px);
        }
        this.expandTemplate("jspUsedOverview", "pool", pool, "ps", ps);
        for (ConnectionProxy px : res) {
            this.expandTemplate2("jspUsedEntry", "pool", pool, "ps", ps, "px", px);
        }
        this.etag("table");
    }

    public void showGlobalstats() throws Exception {
        this.backlink();
        this.expandTemplate2("jspGlobalOverview", "list", this.m_globalStore.getLists());
    }

    public void showGloballist() throws Exception {
        this.backlink();
        this.full("br", new String[0]);
        this.atag("<--- Back to list of indicators", "show", "globalstats");
        this.full("br", new String[0]);
        String name = this.getParam("list");
        PerfList pl = this.m_globalStore.getList(name);
        List<PerfItem> iteml = this.m_globalStore.getItems(name);
        this.expandTemplate2("jspPerfList", "plist", pl, "items", iteml);
        this.expandTemplate2("perf-stmt-stmtcount", "plist", pl, "items", iteml);
    }

    public void showSession() throws Exception {
        if (this.m_sessionStats == null) {
            this.addError("No session data can be found.");
            return;
        }
        this.backlink();
        this.full("br", new String[0]);
        List<SessionStatisticsEntry> entries = this.m_sessionStats.getRequests();
        this.expandTemplate2("jspSessionList", "list", entries, "session", this.m_sessionStats);
    }

    public void showSessionstat() throws Exception {
        if (this.m_sessionStats == null) {
            this.addError("No session data can be found.");
            return;
        }
        String id = this.getParam("id");
        if (null == id) {
            this.addError("Missing id");
            return;
        }
        SessionStatisticsEntry e = this.m_sessionStats.getEntry(id);
        if (null == e) {
            this.addError("Unknown request ID");
            return;
        }
        this.backlink();
        this.text("\u00a0\u00a0\u00a0");
        this.atag("<--- Back to request list", "show", "session");
        this.full("br", new String[0]);
        String key = this.getParam("list");
        PerfList plist = e.getStore().getList(key);
        this.expandTemplate2("jspListHeader", "id", id, "plist", plist, "item", e, "key", key);
        List<PerfItem> pitems = e.getStore().getItems(key);
        this.expandTemplate2("jspSessionEntry", "entry", e, "session", this.m_sessionStats, "plist", plist, "pitems", pitems);
    }
}

