/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.dbpool.DbPoolUtil;
import to.etc.dbpool.info.DbMetric;
import to.etc.dbpool.info.IMetricValueTranslator;

@DefaultNonNull
public final class MetricsDefinition {
    public static final int M_PHYSICAL_READS = 1;
    public static final int M_LOGICAL_READS = 2;
    public static final int M_LOGICAL_WRITES = 3;
    private final int m_id;
    private final String m_key;
    private final String m_label;
    private final IMetricValueTranslator m_translator;
    private final String m_description;
    private final boolean m_defined;
    private static Map<String, MetricsDefinition> m_definitionMap = new HashMap<String, MetricsDefinition>();
    private final int m_order;
    private final int[] m_minmax;

    public MetricsDefinition(int id, String key, String label, IMetricValueTranslator translator, String description, boolean defined) {
        this(id, key, label, translator, description, defined, 100, new int[0]);
    }

    public MetricsDefinition(int id, String key, String label, IMetricValueTranslator translator, String description, boolean defined, int order, int[] minmax) {
        this.m_id = id;
        this.m_key = key;
        this.m_label = label;
        this.m_translator = translator;
        this.m_description = description;
        this.m_defined = defined;
        this.m_order = order;
        this.m_minmax = minmax;
    }

    public static synchronized void register(MetricsDefinition md) {
        m_definitionMap.put(md.getKey(), md);
    }

    public static void register(String key, String label, String description, IMetricValueTranslator tx) {
        MetricsDefinition.register(new MetricsDefinition(0, key, label, tx, description, true));
    }

    public static void register(String key, String label, IMetricValueTranslator tx) {
        MetricsDefinition.register(new MetricsDefinition(0, key, label, tx, label, true));
    }

    public static void register(String key, IMetricValueTranslator tx) {
        MetricsDefinition.register(new MetricsDefinition(0, key, key, tx, key, true));
    }

    public static void register(int id, String key, String label, String description, IMetricValueTranslator tx) {
        MetricsDefinition.register(new MetricsDefinition(id, key, label, tx, description, true));
    }

    public static void register(int id, String key, String label, IMetricValueTranslator tx) {
        MetricsDefinition.register(new MetricsDefinition(id, key, label, tx, label, true));
    }

    public static void register(int id, String key, IMetricValueTranslator tx) {
        MetricsDefinition.register(new MetricsDefinition(id, key, key, tx, key, true));
    }

    public String getKey() {
        return this.m_key;
    }

    public int getId() {
        return this.m_id;
    }

    public String getLabel() {
        return this.m_label;
    }

    public IMetricValueTranslator getTranslator() {
        return this.m_translator;
    }

    public String getDescription() {
        return this.m_description;
    }

    public static Map<String, MetricsDefinition> getDefinitionMap() {
        return m_definitionMap;
    }

    public static MetricBuilder def(String key) {
        return new MetricBuilder(key);
    }

    public static List<String> metricNamesByID(int id) {
        ArrayList<String> res = new ArrayList<String>();
        for (MetricsDefinition md : m_definitionMap.values()) {
            if (md.getId() != id) continue;
            res.add(md.getKey());
        }
        return res;
    }

    public static synchronized MetricsDefinition getOrCreate(@Nonnull String name) {
        MetricsDefinition md = m_definitionMap.get(name);
        if (null == md) {
            md = new MetricsDefinition(-1, name, name, a -> String.valueOf(a), null, false, 0, null);
            m_definitionMap.put(name, md);
        }
        return md;
    }

    public static DbMetric createByName(String metricName, double value) {
        MetricsDefinition md = MetricsDefinition.getOrCreate(metricName);
        return new DbMetric(md, value);
    }

    public int getOrder() {
        return this.m_order;
    }

    public boolean isDefined() {
        return this.m_defined;
    }

    public int[] getMinmax() {
        return this.m_minmax;
    }

    public String toString() {
        return this.m_key;
    }

    static {
        IMetricValueTranslator time = new IMetricValueTranslator(){

            @Override
            public String translate(double value) {
                return DbPoolUtil.strNanoTime((long)(value * 1000.0));
            }
        };
        IMetricValueTranslator num = new IMetricValueTranslator(){

            @Override
            public String translate(double value) {
                return DbPoolUtil.strCommad((long)value);
            }
        };
        IMetricValueTranslator bytes = a -> DbPoolUtil.strSize((long)a);
        IMetricValueTranslator tensofms = a -> DbPoolUtil.strNanoTime((long)a * 10L * 1000L * 1000L);
        IMetricValueTranslator buffers = new IMetricValueTranslator(){

            @Override
            public String translate(double value) {
                long v = (long)value;
                return DbPoolUtil.strCommad(v) + " (" + DbPoolUtil.strSize(v * 8192L) + ")";
            }
        };
        MetricsDefinition.register("DB CPU", "Database CPU time", time);
        MetricsDefinition.register("DB time", "Database time", "CPU time and wait time, accumulated", time);
        MetricsDefinition.register("execute count", "Number of executes", num);
        MetricsDefinition.register("opened cursors cumulative", "Total opened cursors", num);
        MetricsDefinition.register("parse count (total)", num);
        MetricsDefinition.register("parse time elapsed", time);
        MetricsDefinition.register("session cursor cache hits", num);
        MetricsDefinition.def("session logical reads").id(2).xlat(buffers).order(120).register();
        MetricsDefinition.register("sql execute elapsed time", time);
        MetricsDefinition.register("user I/O wait time", time);
        MetricsDefinition.def("physical reads").id(1).xlat(buffers).order(120).register();
        MetricsDefinition.def("db block changes").id(3).xlat(buffers).order(120).register();
        MetricsDefinition.register("redo size", bytes);
        MetricsDefinition.def("CPU used by this session").order(10).xlat(tensofms).minmax(new int[0]).register();
        MetricsDefinition.def("CPU used when call started").order(10).xlat(tensofms).minmax(new int[0]).register();
        MetricsDefinition.def("CR blocks created").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("Commit SCN cached").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("Requests to/from client").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("SQL*Net roundtrips to/from client").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("bytes received via SQL*Net from client").order(10).xlat(bytes).minmax(new int[0]).register();
        MetricsDefinition.def("bytes sent via SQL*Net to client").order(10).xlat(bytes).minmax(new int[0]).register();
        MetricsDefinition.def("concurrency wait time").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("consistent changes").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("consistent gets").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("consistent gets - examination").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("consistent gets direct").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("consistent gets from cache").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("consistent gets from cache (fastpath)").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("data blocks consistent reads - undo records applied").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("db block gets").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("db block gets direct").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("db block gets from cache").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("db block gets from cache (fastpath)").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("index fast full scans (full)").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("index fetch by key").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("index scans kdiixs1").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("lob reads").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("lob writes").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("lob writes unaligned").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("logical read bytes from cache").order(10).xlat(bytes).minmax(new int[0]).register();
        MetricsDefinition.def("messages received").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("messages sent").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("no buffer to keep pinned count").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("no work - consistent read gets").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("non-idle wait count").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("non-idle wait time").order(10).xlat(tensofms).minmax(new int[0]).register();
        MetricsDefinition.def("opened cursors cumulative").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("opened cursors current").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("parse count (failures)").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("parse count (hard)").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("parse time cpu").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("physical read IO requests").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("physical read bytes").order(10).xlat(bytes).minmax(new int[0]).register();
        MetricsDefinition.def("physical read total IO requests").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("physical read total bytes").order(10).xlat(bytes).minmax(new int[0]).register();
        MetricsDefinition.def("physical read total multi block requests").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("physical reads cache").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("physical reads cache prefetch").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("physical reads direct").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("physical reads direct (lob)").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("physical reads direct temporary tablespace").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("physical reads prefetch warmup").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("physical write IO requests").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("physical write bytes").order(10).xlat(bytes).minmax(new int[0]).register();
        MetricsDefinition.def("physical write total IO requests").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("physical write total bytes").order(10).xlat(bytes).minmax(new int[0]).register();
        MetricsDefinition.def("physical write total multi block requests").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("physical writes").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("physical writes direct").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("physical writes direct (lob)").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("physical writes direct temporary tablespace").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("physical writes from cache").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("physical writes non checkpoint").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("sorts (memory)").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("sorts (rows)").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("table fetch by rowid").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("table fetch continued row").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("table scan blocks gotten").order(10).xlat(buffers).minmax(new int[0]).register();
        MetricsDefinition.def("table scan rows gotten").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("table scans (direct read)").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("table scans (long tables)").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("table scans (short tables)").order(10).xlat(num).minmax(new int[0]).register();
        MetricsDefinition.def("transaction rollbacks").order(10).xlat(num).minmax(new int[0]).register();
    }

    public static class MetricBuilder {
        private int m_id = -1;
        private final String m_key;
        @Nullable
        private String m_label;
        @Nullable
        private String m_desc;
        @Nullable
        private IMetricValueTranslator m_xlat;
        private int m_order;
        private int[] m_minmax;

        public MetricBuilder(String key) {
            this.m_key = key;
        }

        public MetricBuilder id(int id) {
            this.m_id = id;
            return this;
        }

        public MetricBuilder d(String desc) {
            this.m_desc = desc;
            return this;
        }

        public MetricBuilder l(String lbl) {
            this.m_label = lbl;
            return this;
        }

        public MetricBuilder order(int order) {
            this.m_order = order;
            return this;
        }

        public MetricBuilder minmax(int ... minmax) {
            this.m_minmax = minmax;
            return this;
        }

        public MetricBuilder xlat(IMetricValueTranslator xl) {
            this.m_xlat = xl;
            return this;
        }

        public void register() {
            IMetricValueTranslator xlat = this.m_xlat;
            if (xlat == null) {
                xlat = a -> String.valueOf(a);
            }
            MetricsDefinition.register(new MetricsDefinition(this.m_id, this.m_key, this.m_label == null ? this.m_key : this.m_label, xlat, this.m_desc == null ? this.m_key : this.m_desc, true, this.m_order, this.m_minmax));
        }
    }
}

