/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool.info;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.DefaultNonNull;
import to.etc.dbpool.ConnectionProxy;
import to.etc.dbpool.info.DbMetric;
import to.etc.dbpool.info.MetricsDefinition;

@DefaultNonNull
public final class OracleStatisticsCreator {
    private static final String KEY = "OraStatCtx";
    private static volatile boolean m_enableSessionTrace;
    private static boolean m_allStatistics;
    private final Map<ConnectionProxy, Map<MetricsDefinition, DbMetric>> m_storeMap = new HashMap<ConnectionProxy, Map<MetricsDefinition, DbMetric>>();

    public static OracleStatisticsCreator get(ConnectionProxy px) {
        return px.getPool().getOrCreateAttribute(KEY, () -> new OracleStatisticsCreator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableConnectionStatistics(ConnectionProxy px, String sessionID) throws Exception {
        try (Statement statement = px.createStatement();){
            statement.execute("begin dbms_session.set_identifier('" + sessionID + "'); end;");
            try {
                try {
                    statement.execute("begin dbms_monitor.client_id_stat_enable('" + sessionID + "'); end;");
                }
                catch (Exception x) {
                    if (!x.getMessage().contains("ORA-13861")) {
                        throw x;
                    }
                    statement.execute("begin dbms_monitor.client_id_stat_disable('" + sessionID + "'); end;");
                    statement.execute("begin dbms_monitor.client_id_stat_enable('" + sessionID + "'); end;");
                }
                if (m_allStatistics) {
                    Map<MetricsDefinition, DbMetric> map = this.loadExtendedStatistics(px);
                    Map<ConnectionProxy, Map<MetricsDefinition, DbMetric>> map2 = this.m_storeMap;
                    synchronized (map2) {
                        this.m_storeMap.put(px, map);
                    }
                }
                if (m_enableSessionTrace) {
                    statement.execute("begin dbms_monitor.client_id_trace_enable(client_id => '" + sessionID + "', waits => true, binds => false); end;");
                }
            }
            catch (Exception x) {
                System.err.println("dbpool: " + x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DbMetric> disableConnectionStatistics(ConnectionProxy px, String sessionID) throws Exception {
        Map<MetricsDefinition, DbMetric> newMap;
        HashMap<MetricsDefinition, DbMetric> map = new HashMap<MetricsDefinition, DbMetric>();
        try (PreparedStatement ps = px.prepareStatement("select stat_name, value from v$client_stats where client_identifier = ?");){
            ps.setString(1, sessionID);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    DbMetric m = MetricsDefinition.createByName(rs.getString(1), rs.getDouble(2));
                    map.put(m.getDefinition(), m);
                }
            }
        }
        var5_5 = null;
        try (Statement st = px.createStatement();){
            try {
                st.execute("begin dbms_monitor.client_id_stat_disable('" + sessionID + "'); end;");
                if (m_enableSessionTrace) {
                    st.execute("begin dbms_monitor.client_id_trace_disable(client_id => '" + sessionID + "'); end;");
                }
            }
            catch (Exception x) {
                System.err.println("dbpool: " + x);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        if (m_allStatistics && (newMap = this.loadExtendedStatistics(px)).size() > 0) {
            Map<MetricsDefinition, DbMetric> oldMap;
            Map<ConnectionProxy, Map<MetricsDefinition, DbMetric>> map2 = this.m_storeMap;
            synchronized (map2) {
                oldMap = this.m_storeMap.remove(px);
            }
            if (oldMap != null) {
                this.mergeMaps(map, oldMap, newMap);
            }
        }
        return new ArrayList<DbMetric>(map.values());
    }

    private void mergeMaps(Map<MetricsDefinition, DbMetric> map, Map<MetricsDefinition, DbMetric> oldMap, Map<MetricsDefinition, DbMetric> newMap) {
        newMap.forEach((name, metric) -> {
            double value;
            DbMetric old = (DbMetric)oldMap.get(name);
            if (old != null && (value = metric.getValue() - old.getValue()) > 0.0) {
                metric.setValue(value);
                if (!map.containsKey(metric.getDefinition())) {
                    map.put(metric.getDefinition(), (DbMetric)metric);
                }
            }
        });
    }

    private Map<MetricsDefinition, DbMetric> loadExtendedStatistics(ConnectionProxy cx) {
        HashMap<MetricsDefinition, DbMetric> map = new HashMap<MetricsDefinition, DbMetric>();
        try (Statement st = cx.createStatement();
             ResultSet rs = st.executeQuery("select value, name from v$sesstat s join v$statname n on s.statistic# = n.statistic# where sid=sys_context('USERENV', 'SID') and value > 0");){
            while (rs.next()) {
                double value = rs.getDouble(1);
                String name = rs.getString(2);
                DbMetric m = MetricsDefinition.createByName(name, value);
                map.put(m.getDefinition(), m);
            }
        }
        catch (Exception x) {
            System.err.println("dbpool: " + x);
        }
        return map;
    }

    public static void enableSessionTrace(boolean on) {
        m_enableSessionTrace = on;
    }

    static {
        m_allStatistics = System.getProperty("db.extended") != null;
        m_enableSessionTrace = System.getProperty("db.trace") != null;
    }
}

