/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.dbpool.info.PerfItem;

public final class PerfList {
    private final String m_key;
    private final String m_description;
    private final boolean m_descending;
    private final int m_maxSize;
    private final List<PerfItem> m_itemList;
    private Map<String, PerfItem> m_existingMap = new HashMap<String, PerfItem>();
    private static final Comparator<PerfItem> C_ASCENDING = new Comparator<PerfItem>(){

        @Override
        public int compare(PerfItem a, PerfItem b) {
            long v = a.getMetric() - b.getMetric();
            if (v == 0L) {
                return 0;
            }
            return v > 0L ? 1 : -1;
        }
    };
    private static final Comparator<PerfItem> C_DESCENDING = new Comparator<PerfItem>(){

        @Override
        public int compare(PerfItem a, PerfItem b) {
            long v = a.getMetric() - b.getMetric();
            if (v == 0L) {
                return 0;
            }
            return v > 0L ? -1 : 1;
        }
    };

    public PerfList(String key, String description, boolean descending, int maxSize) {
        this.m_key = key;
        this.m_description = description;
        this.m_descending = descending;
        this.m_maxSize = maxSize;
        this.m_itemList = new ArrayList<PerfItem>();
    }

    PerfList(PerfList other) {
        this.m_key = other.getKey();
        this.m_description = other.getDescription();
        this.m_descending = other.isDescending();
        this.m_maxSize = other.getMaxSize();
        this.m_itemList = new ArrayList<PerfItem>(other.m_itemList);
    }

    public String getKey() {
        return this.m_key;
    }

    public String getDescription() {
        return this.m_description;
    }

    public boolean isDescending() {
        return this.m_descending;
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }

    void addItem(@Nonnull String itemKey, long value, @Nullable String request, @Nullable Object data) {
        PerfItem pi;
        if (this.m_itemList.size() >= this.m_maxSize) {
            pi = this.m_itemList.get(this.m_maxSize - 1);
            if (this.m_descending ? value <= pi.getMetric() : value >= pi.getMetric()) {
                return;
            }
        }
        if (null != itemKey && null != (pi = this.m_existingMap.get(itemKey))) {
            if (this.m_descending ? value <= pi.getMetric() : value >= pi.getMetric()) {
                return;
            }
            this.m_itemList.remove(pi);
        }
        PerfItem npi = new PerfItem(itemKey, value, request, data);
        this.addItem(npi);
    }

    void addItem(@Nonnull PerfItem npi) {
        int ispot = Collections.binarySearch(this.m_itemList, npi, this.m_descending ? C_DESCENDING : C_ASCENDING);
        if (ispot < 0) {
            ispot = -ispot - 1;
        }
        this.m_itemList.add(ispot, npi);
        while (this.m_itemList.size() > this.m_maxSize) {
            this.m_itemList.remove(this.m_itemList.size() - 1);
        }
    }

    void mergeList(PerfList otherpl) {
        int len = otherpl.m_itemList.size();
        for (int i = 0; i < len; ++i) {
            PerfItem opi = otherpl.m_itemList.get(i);
            if (this.m_itemList.size() < this.m_maxSize) {
                this.addItem(opi);
                continue;
            }
            PerfItem lpi = this.m_itemList.get(this.m_itemList.size() - 1);
            if (this.m_descending) {
                if (opi.getMetric() > lpi.getMetric()) {
                    this.addItem(opi);
                    continue;
                }
                return;
            }
            if (opi.getMetric() < lpi.getMetric()) {
                this.addItem(opi);
                continue;
            }
            return;
        }
    }

    List<PerfItem> getItemList() {
        return new ArrayList<PerfItem>(this.m_itemList);
    }

    public void clear() {
        this.m_itemList.clear();
        this.m_existingMap.clear();
    }
}

