/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool.info;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import to.etc.dbpool.info.IPerformanceCollector;
import to.etc.dbpool.info.PerformanceStore;
import to.etc.dbpool.info.StatementStatistics;

public final class PerformanceCollector
extends PerformanceStore
implements IPerformanceCollector {
    private static final String SQL_EXEC_TIME = "stmt-exec-time";
    private static final String SQL_EXEC_COUNT = "stmt-exec-count";
    private static final String SQL_ROW_COUNT = "stmt-row-count";
    private static final String SQL_FETCH_TIME = "stmt-fetch-time";
    private static final String SQL_TOTAL_TIME = "stmt-total-time";
    private static final Comparator<StatementStatistics> C_BYEXEC = new Comparator<StatementStatistics>(){

        @Override
        public int compare(StatementStatistics a, StatementStatistics b) {
            return b.getExecutions() - a.getExecutions();
        }
    };
    private static final Comparator<StatementStatistics> C_BYROWS = new Comparator<StatementStatistics>(){

        @Override
        public int compare(StatementStatistics a, StatementStatistics b) {
            long r = a.getRows() - b.getRows();
            if (r == 0L) {
                return 0;
            }
            return r > 0L ? -1 : 1;
        }
    };
    private static final Comparator<StatementStatistics> C_BYFETCH = new Comparator<StatementStatistics>(){

        @Override
        public int compare(StatementStatistics a, StatementStatistics b) {
            long r = a.getTotalFetchDuration() - b.getTotalFetchDuration();
            if (r == 0L) {
                return 0;
            }
            return r > 0L ? -1 : 1;
        }
    };
    private static final Comparator<StatementStatistics> C_BYEXEC_TIME = new Comparator<StatementStatistics>(){

        @Override
        public int compare(StatementStatistics a, StatementStatistics b) {
            long v = a.getTotalExecuteDuration() - b.getTotalExecuteDuration();
            return v == 0L ? 0 : (v < 0L ? 1 : -1);
        }
    };
    private static final Comparator<StatementStatistics> C_BYTOTAL_TIME = new Comparator<StatementStatistics>(){

        @Override
        public int compare(StatementStatistics a, StatementStatistics b) {
            long bt;
            long at = a.getTotalExecuteDuration() + a.getTotalFetchDuration();
            long v = at - (bt = b.getTotalExecuteDuration() + b.getTotalFetchDuration());
            return v == 0L ? 0 : (v < 0L ? 1 : -1);
        }
    };

    public PerformanceCollector() {
        this.define(SQL_TOTAL_TIME, "SQL: total time (execute+fetch) per statement", true, 20);
        this.define(SQL_EXEC_TIME, "SQL: longest statement execution time", true, 20);
        this.define(SQL_EXEC_COUNT, "SQL: statements executed most", true, 20);
        this.define(SQL_ROW_COUNT, "SQL: statements returning/altering largest number of rows", true, 20);
        this.define(SQL_FETCH_TIME, "SQL: statements with the largest result set fetch time (time till rs.close is called)", true, 20);
    }

    @Override
    public void saveCounters(String request, List<StatementStatistics> counterList) {
        StatementStatistics sc;
        int i;
        Collections.sort(counterList, C_BYEXEC);
        int max = 20;
        if (counterList.size() < max) {
            max = counterList.size();
        }
        for (i = 0; i < max; ++i) {
            sc = counterList.get(i);
            this.addItem(SQL_EXEC_COUNT, sc.getSQL(), sc.getExecutions(), request, sc);
        }
        Collections.sort(counterList, C_BYROWS);
        max = 20;
        if (counterList.size() < max) {
            max = counterList.size();
        }
        for (i = 0; i < max; ++i) {
            sc = counterList.get(i);
            this.addItem(SQL_ROW_COUNT, sc.getSQL(), sc.getRows(), request, sc);
        }
        Collections.sort(counterList, C_BYFETCH);
        max = 20;
        if (counterList.size() < max) {
            max = counterList.size();
        }
        for (i = 0; i < max; ++i) {
            sc = counterList.get(i);
            this.addItem(SQL_FETCH_TIME, sc.getSQL(), sc.getTotalFetchDuration(), request, sc);
        }
        Collections.sort(counterList, C_BYEXEC_TIME);
        max = 20;
        if (counterList.size() < max) {
            max = counterList.size();
        }
        for (i = 0; i < max; ++i) {
            sc = counterList.get(i);
            this.addItem(SQL_EXEC_TIME, sc.getSQL(), sc.getTotalExecuteDuration(), request, sc);
        }
        Collections.sort(counterList, C_BYTOTAL_TIME);
        max = 20;
        if (counterList.size() < max) {
            max = counterList.size();
        }
        for (i = 0; i < max; ++i) {
            sc = counterList.get(i);
            this.addItem(SQL_TOTAL_TIME, sc.getSQL(), sc.getTotalExecuteDuration() + sc.getTotalFetchDuration(), request, sc);
        }
    }
}

