/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.dbpool.info.PerfItem;
import to.etc.dbpool.info.PerfList;

public class PerformanceStore {
    private final Map<String, PerfList> m_listMap = new HashMap<String, PerfList>();

    public void define(String key, String desc, boolean descending, int maxsize) {
        if (this.m_listMap.get(key) != null) {
            return;
        }
        PerfList pl = new PerfList(key, desc, descending, maxsize);
        this.m_listMap.put(key, pl);
    }

    @Nonnull
    public final PerfList getList(String key) {
        PerfList pl = this.m_listMap.get(key);
        if (null == pl) {
            throw new IllegalArgumentException("Unknown performance list '" + key + "'");
        }
        return pl;
    }

    public final List<PerfList> getLists() {
        return new ArrayList<PerfList>(this.m_listMap.values());
    }

    public final List<PerfItem> getItems(String listKey) {
        PerfList pl = this.getList(listKey);
        return pl.getItemList();
    }

    public void addItem(@Nonnull String listKey, @Nonnull String itemKey, long value, @Nullable String request, @Nullable Object data) {
        PerfList pl = this.getList(listKey);
        pl.addItem(itemKey, value, request, data);
    }

    public void addItem(@Nonnull String listKey, @Nonnull PerfItem pi) {
        PerfList pl = this.getList(listKey);
        pl.addItem(pi);
    }

    public void merge(PerformanceStore other) {
        if (null == other) {
            return;
        }
        for (PerfList otherpl : other.m_listMap.values()) {
            PerfList pl = this.m_listMap.get(otherpl.getKey());
            if (null == pl) {
                pl = new PerfList(otherpl);
                this.m_listMap.put(pl.getKey(), pl);
                continue;
            }
            pl.mergeList(otherpl);
        }
    }

    public void clear() {
        for (PerfList pl : this.m_listMap.values()) {
            pl.clear();
        }
    }
}

