/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool.info;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import to.etc.dbpool.info.PerformanceCollector;
import to.etc.dbpool.info.PerformanceStore;
import to.etc.dbpool.info.SessionStatisticsEntry;
import to.etc.dbpool.info.StatisticsCollectorBase;

public final class SessionStatistics {
    private final int m_maxRequests;
    private int m_idCounter;
    private final List<SessionStatisticsEntry> m_entryList;

    public SessionStatistics(int maxRequests) {
        this.m_maxRequests = maxRequests;
        this.m_entryList = new ArrayList<SessionStatisticsEntry>(maxRequests + 1);
    }

    public synchronized List<SessionStatisticsEntry> getRequests() {
        return new ArrayList<SessionStatisticsEntry>(this.m_entryList);
    }

    private synchronized int nextID() {
        return this.m_idCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequestInfo(String requestId, PerformanceCollector collector, StatisticsCollectorBase thisrequest) {
        if (thisrequest.getNAnything() == 0L) {
            return;
        }
        PerformanceStore ps = new PerformanceStore();
        ps.merge(collector);
        int requestNumber = this.nextID();
        SessionStatisticsEntry sse = new SessionStatisticsEntry(thisrequest, requestId, requestNumber, ps);
        SessionStatistics sessionStatistics = this;
        synchronized (sessionStatistics) {
            if (this.m_entryList.size() >= this.m_maxRequests) {
                this.m_entryList.remove(0);
            }
            this.m_entryList.add(sse);
        }
    }

    @Nullable
    public SessionStatisticsEntry getEntry(String requestId) {
        for (SessionStatisticsEntry e : this.m_entryList) {
            if (!requestId.equals(e.getRequestId())) continue;
            return e;
        }
        return null;
    }
}

