/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool.info;

import java.util.Date;
import java.util.List;
import to.etc.dbpool.info.DbMetric;
import to.etc.dbpool.info.PerformanceStore;
import to.etc.dbpool.info.StatisticsCollectorBase;

public class SessionStatisticsEntry {
    private final int m_id;
    private final long m_ts;
    private final StatisticsCollectorBase m_request;
    private final String m_requestId;
    private PerformanceStore m_store;

    public SessionStatisticsEntry(StatisticsCollectorBase request, String requestId, int id, PerformanceStore ps) {
        this.m_requestId = requestId;
        this.m_request = request;
        this.m_id = id;
        this.m_ts = System.currentTimeMillis();
        this.m_store = ps;
    }

    public String getRequestId() {
        return this.m_requestId;
    }

    public StatisticsCollectorBase getRequest() {
        return this.m_request;
    }

    public List<DbMetric> getMetrics() {
        return this.m_request.getMetrics();
    }

    public int getId() {
        return this.m_id;
    }

    public Date getTS() {
        return new Date(this.m_ts);
    }

    public PerformanceStore getStore() {
        return this.m_store;
    }
}

