/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool.info;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import to.etc.dbpool.ConnectionProxy;
import to.etc.dbpool.DbPoolUtil;
import to.etc.dbpool.IStatisticsListener;
import to.etc.dbpool.StatementProxy;
import to.etc.dbpool.info.BatchEntry;
import to.etc.dbpool.info.DbMetric;
import to.etc.dbpool.info.IConnectionStatisticsFactory;
import to.etc.dbpool.info.StatementStatistics;
import to.etc.dbpool.info.StatisticsCollectorBase;

public final class StatisticsCollector
extends StatisticsCollectorBase
implements IStatisticsListener {
    private static long m_nextId = System.currentTimeMillis();
    private final boolean m_collectOraclePerformanceData;
    private Map<String, StatementStatistics> m_sqlMap = new HashMap<String, StatementStatistics>();
    private final String m_fullRequestURL;
    private boolean m_disabled;

    public StatisticsCollector(String ident, String queryString, boolean collectOraclePerformanceData) {
        super(ident);
        this.m_collectOraclePerformanceData = collectOraclePerformanceData;
        this.m_fullRequestURL = queryString == null || queryString.length() == 0 ? ident : ident + "?" + queryString;
    }

    @Override
    public void finish() {
    }

    private StatementStatistics findCounter(String sql) {
        StatementStatistics c = this.m_sqlMap.get(sql);
        if (c == null) {
            c = new StatementStatistics(sql);
            this.m_sqlMap.put(sql, c);
        }
        return c;
    }

    public Map<String, StatementStatistics> getStatementMap() {
        return this.m_sqlMap;
    }

    public List<StatementStatistics> getCounters() {
        return new ArrayList<StatementStatistics>(this.m_sqlMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionAllocated(ConnectionProxy proxy) {
        IConnectionStatisticsFactory collector;
        ++this.m_nConnectionAllocations;
        ++this.m_currentOpenConnections;
        if (this.m_currentOpenConnections >= this.m_maxConcurrentConnections) {
            this.m_maxConcurrentConnections = this.m_currentOpenConnections;
        }
        if (this.m_collectOraclePerformanceData && null != (collector = proxy.getPool().getConnectionStatisticsFactory())) {
            try {
                collector.startConnectionStatistics(proxy);
            }
            catch (Exception x) {
                System.err.println("dbpool: db statistics init failed " + x);
            }
            finally {
                this.m_disabled = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(ConnectionProxy proxy) {
        if (this.m_currentOpenConnections > 0) {
            --this.m_currentOpenConnections;
        }
        if (!this.m_collectOraclePerformanceData) {
            return;
        }
        IConnectionStatisticsFactory collector = proxy.getPool().getConnectionStatisticsFactory();
        if (null == collector) {
            return;
        }
        try {
            List<DbMetric> list = collector.finishConnectionStatistics(proxy);
            this.mergeMetrics(list);
        }
        catch (Exception x) {
            System.err.println("dbpool: oracle db statistics gather failed " + x);
        }
        finally {
            this.m_disabled = false;
        }
    }

    @Override
    public void statementPrepared(StatementProxy sp, long prepareDuration) {
        if (this.m_disabled) {
            return;
        }
        ++this.m_nPrepares;
        this.m_prepareDuration += prepareDuration;
    }

    @Override
    public void queryStatementExecuted(StatementProxy sp, long executeDuration, long fetchDuration, int rowCount, boolean prepared) {
        if (this.m_disabled) {
            return;
        }
        if (prepared) {
            ++this.m_nPreparedQueries;
            this.m_preparedQueryDuration += executeDuration;
        } else {
            ++this.m_nStatementQueries;
            this.m_statementQueryDuration += executeDuration;
        }
        this.m_totalFetchDuration += fetchDuration;
        this.m_nRows += rowCount;
        StatementStatistics c = this.findCounter(sp.getSQL());
        c.incExecutions();
        c.incRows(rowCount);
        c.addTotalFetchDuration(fetchDuration);
        c.addTotalExecuteDuration(executeDuration);
    }

    @Override
    public void executePreparedUpdateExecuted(StatementProxy sp, long updateDuration, int rowcount) {
        if (this.m_disabled) {
            return;
        }
        ++this.m_nPreparedUpdates;
        this.m_nUpdatedRows += (long)rowcount;
        this.m_preparedUpdateDuration += updateDuration;
        StatementStatistics c = this.findCounter(sp.getSQL());
        c.incExecutions();
        c.incRows(rowcount);
        c.addTotalExecuteDuration(updateDuration);
    }

    @Override
    public void executeUpdateExecuted(StatementProxy sp, long updateDuration, int updatedrowcount) {
        if (this.m_disabled) {
            return;
        }
        ++this.m_nStatementUpdates;
        this.m_nUpdatedRows += (long)updatedrowcount;
        this.m_statementUpdateDuration += updateDuration;
        StatementStatistics c = this.findCounter(sp.getSQL());
        c.incExecutions();
        c.incRows(updatedrowcount);
        c.addTotalExecuteDuration(updateDuration);
    }

    @Override
    public void executeExecuted(StatementProxy sp, long updateDuration, Boolean result) {
        if (this.m_disabled) {
            return;
        }
        ++this.m_nExecutes;
        this.m_executeDuration += updateDuration;
        StatementStatistics c = this.findCounter(sp.getSQL());
        c.incExecutions();
        c.addTotalExecuteDuration(updateDuration);
    }

    @Override
    public void executeBatchExecuted(long executeDuration, int totalStatements, int totalRows, List<BatchEntry> list) {
        if (this.m_disabled) {
            return;
        }
        this.m_nExecutes += totalStatements;
        this.m_nUpdatedRows += (long)totalRows;
        double totalToGive = executeDuration;
        double rowsLeft = totalRows;
        for (BatchEntry be : list) {
            StatementStatistics c = this.findCounter(be.getStatement());
            c.addExecutions(be.getExecCount());
            c.incRows(be.getRowCount());
            if (rowsLeft <= 0.0) {
                rowsLeft = 1.0;
            }
            double duration = totalToGive / rowsLeft * (double)be.getRowCount();
            duration = Math.round(duration);
            rowsLeft -= (double)be.getRowCount();
            totalToGive -= duration;
            c.addTotalExecuteDuration((long)duration);
        }
    }

    public void reportSimple() {
        if (this.getNAnything() == 0L) {
            return;
        }
        long rd = System.nanoTime() - this.getStartTS();
        System.out.println("S: " + this.getIdent() + ":" + DbPoolUtil.strNanoTime(rd) + " #conn=" + this.getNConnectionAllocations() + " #q=" + this.getTotalQueries() + " #u=" + this.getTotalUpdates() + " #qrow=" + this.getNRows() + " #urow=" + this.getNUpdatedRows() + " #errs=" + this.getNErrors() + ", #any=" + this.getNAnything());
    }
}

