/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbpool.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import to.etc.dbpool.info.DbMetric;
import to.etc.dbpool.info.MetricsDefinition;

public class StatisticsCollectorBase {
    private final String m_ident;
    private final long m_ts_started;
    private long m_duration;
    protected int m_nConnectionAllocations;
    protected int m_maxConcurrentConnections;
    protected int m_currentOpenConnections;
    protected int m_nPrepares;
    protected long m_prepareDuration;
    protected int m_nPreparedQueries;
    protected int m_nPreparedUpdates;
    protected int m_nStatementUpdates;
    protected long m_nUpdatedRows;
    protected long m_preparedQueryDuration;
    protected long m_preparedUpdateDuration;
    protected long m_statementQueryDuration;
    protected long m_statementUpdateDuration;
    protected int m_nExecutes;
    protected long m_executeDuration;
    protected int m_nErrors;
    protected int m_nRows;
    protected long m_totalFetchDuration;
    protected int m_nStatementQueries;
    private int m_id;
    @Nullable
    private Map<MetricsDefinition, DbMetric> m_metricMap;

    public StatisticsCollectorBase(String ident) {
        this.m_ts_started = System.nanoTime();
        this.m_ident = ident;
    }

    public StatisticsCollectorBase(StatisticsCollectorBase o, long duration) {
        this.m_executeDuration = o.m_executeDuration;
        this.m_ident = o.m_ident;
        this.m_nConnectionAllocations = o.m_nConnectionAllocations;
        this.m_nErrors = o.m_nErrors;
        this.m_nExecutes = o.m_nExecutes;
        this.m_nPreparedQueries = o.m_nPreparedQueries;
        this.m_nPreparedUpdates = o.m_nPreparedUpdates;
        this.m_nPrepares = o.m_nPrepares;
        this.m_nRows = o.m_nRows;
        this.m_totalFetchDuration = o.m_totalFetchDuration;
        this.m_nStatementQueries = o.m_nStatementQueries;
        this.m_nStatementUpdates = o.m_nStatementUpdates;
        this.m_nUpdatedRows = o.m_nUpdatedRows;
        this.m_preparedQueryDuration = o.m_preparedQueryDuration;
        this.m_preparedUpdateDuration = o.m_preparedUpdateDuration;
        this.m_prepareDuration = o.m_prepareDuration;
        this.m_statementQueryDuration = o.m_statementQueryDuration;
        this.m_statementUpdateDuration = o.m_statementUpdateDuration;
        this.m_ts_started = o.m_ts_started;
        this.m_duration = duration;
        this.m_maxConcurrentConnections = o.m_maxConcurrentConnections;
        Map<MetricsDefinition, DbMetric> metricMap = o.m_metricMap;
        if (null != metricMap) {
            this.m_metricMap = new HashMap<MetricsDefinition, DbMetric>();
            HashMap<MetricsDefinition, DbMetric> map = this.m_metricMap;
            for (DbMetric mm : metricMap.values()) {
                map.put(mm.getDefinition(), new DbMetric(mm));
            }
        }
    }

    public void mergeMetrics(List<DbMetric> metrics) {
        if (metrics.size() == 0) {
            return;
        }
        Map<MetricsDefinition, DbMetric> map = this.m_metricMap;
        if (null == map) {
            this.m_metricMap = map = new HashMap<MetricsDefinition, DbMetric>();
        }
        for (DbMetric m : metrics) {
            DbMetric out = map.get(m.getDefinition());
            if (null == out) {
                out = new DbMetric(m.getDefinition(), m.getValue());
                map.put(m.getDefinition(), out);
                continue;
            }
            out.setValue(m.getValue() + out.getValue());
        }
    }

    public List<DbMetric> getMetrics() {
        Map<MetricsDefinition, DbMetric> map = this.m_metricMap;
        if (null == map) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DbMetric> list = new ArrayList<DbMetric>(map.values());
        Collections.sort(list, (a, b) -> {
            int res = -Integer.compare(a.getDefinition().getOrder(), b.getDefinition().getOrder());
            if (res != 0) {
                return res;
            }
            return a.getLabel().compareTo(b.getLabel());
        });
        return list;
    }

    @Nullable
    public DbMetric getMetric(int id) {
        Map<MetricsDefinition, DbMetric> map = this.m_metricMap;
        if (map == null) {
            return null;
        }
        for (DbMetric metric : map.values()) {
            if (metric.getDefinition().getId() != id) continue;
            return metric;
        }
        return null;
    }

    public int getNConnectionAllocations() {
        return this.m_nConnectionAllocations;
    }

    public int getMaxConcurrentConnections() {
        return this.m_maxConcurrentConnections;
    }

    public int getNPrepares() {
        return this.m_nPrepares;
    }

    public long getPrepareDuration() {
        return this.m_prepareDuration;
    }

    public int getNPreparedQueries() {
        return this.m_nPreparedQueries;
    }

    public int getNPreparedUpdates() {
        return this.m_nPreparedUpdates;
    }

    public int getNStatementUpdates() {
        return this.m_nStatementUpdates;
    }

    public long getNUpdatedRows() {
        return this.m_nUpdatedRows;
    }

    public long getPreparedQueryDuration() {
        return this.m_preparedQueryDuration;
    }

    public long getPreparedUpdateDuration() {
        return this.m_preparedUpdateDuration;
    }

    public long getStatementQueryDuration() {
        return this.m_statementQueryDuration;
    }

    public long getStatementUpdateDuration() {
        return this.m_statementUpdateDuration;
    }

    public int getNExecutes() {
        return this.m_nExecutes;
    }

    public long getExecuteDuration() {
        return this.m_executeDuration;
    }

    public int getNErrors() {
        return this.m_nErrors;
    }

    public int getNStatementQueries() {
        return this.m_nStatementQueries;
    }

    public int getTotalQueries() {
        return this.m_nExecutes + this.m_nStatementQueries + this.m_nPreparedQueries;
    }

    public int getTotalUpdates() {
        return this.m_nPreparedUpdates + this.m_nStatementUpdates;
    }

    public int getTotalDBRequests() {
        return this.getTotalQueries() + this.getTotalUpdates();
    }

    public long getTotalDBTime() {
        return this.m_executeDuration + this.m_preparedQueryDuration + this.m_preparedUpdateDuration + this.m_prepareDuration + this.m_statementQueryDuration + this.m_statementUpdateDuration + this.m_totalFetchDuration;
    }

    public int getNRows() {
        return this.m_nRows;
    }

    public long getTotalFetchDuration() {
        return this.m_totalFetchDuration;
    }

    public long getStartTS() {
        return this.m_ts_started;
    }

    public long getDuration() {
        return this.m_duration;
    }

    public long getNAnything() {
        return this.m_nUpdatedRows + (long)this.m_nConnectionAllocations + (long)this.m_nErrors + (long)this.m_nExecutes + (long)this.m_nPreparedQueries + (long)this.m_nPreparedUpdates + (long)this.m_nPrepares + (long)this.m_nRows + (long)this.m_nStatementQueries + (long)this.m_nStatementUpdates + this.m_nUpdatedRows;
    }

    public String getIdent() {
        return this.m_ident;
    }
}

