/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbreplay;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import to.etc.dbpool.ConnectionPool;
import to.etc.dbpool.DbPoolUtil;
import to.etc.dbpool.PoolManager;
import to.etc.dbreplay.IReplayer;
import to.etc.dbreplay.ReplayExecutor;
import to.etc.dbreplay.ReplayRecord;
import to.etc.dbreplay.SpeedyReplayer;
import to.etc.dbreplay.TimeBasedReplayer;

public class DbReplay {
    private File m_inputFile;
    private File m_driverPath;
    private BufferedInputStream m_bis;
    private long m_firstTime;
    private long m_lastRecordTime;
    private long m_startTime;
    private long m_endTime;
    private File m_poolFile;
    private String m_poolId;
    private ConnectionPool m_pool;
    private String m_runSchema;
    private String m_dbHost;
    private String m_dbSid;
    private String m_dbUser;
    private String m_dbPass;
    private int m_executors = 20;
    private int m_runningExecutors;
    private long m_maxStatementDelay = Long.MAX_VALUE;
    private XType m_runType;
    private PrintWriter m_log;
    private boolean m_stopped;
    private IReplayer m_replayer;
    private long m_fileOffset;
    private int m_recordNumber;
    private List<ReplayExecutor> m_executorList = new ArrayList<ReplayExecutor>(100);
    private List<ReplayExecutor> m_freeExecutors = new ArrayList<ReplayExecutor>();
    private Set<ReplayExecutor> m_idleExecutorList = new HashSet<ReplayExecutor>();
    private long m_ignoredStatements;
    private long m_executedQueries;
    private long m_resultRows;
    private long m_execErrors;
    private int m_inExecution;
    private long m_connSkips;
    private long m_missingConnections;
    private int m_statusLines;
    private long m_ts_laststatus;
    private long m_previousRowCount;
    private long m_previousQueryCount;
    public static final DateFormat DATEFORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final ThreadLocal<DateFormat> m_dateFormat = new ThreadLocal();
    private StringBuilder m_status_sb = new StringBuilder(128);
    private static final String SPACES = "                                     ";

    public static void main(String[] args) {
        try {
            new DbReplay().run(args);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void run(String[] args) throws Exception {
        if (!this.decodeOptions(args)) {
            return;
        }
        try {
            this.openSource();
            switch (this.m_runType) {
                default: {
                    throw new IllegalStateException((Object)((Object)this.m_runType) + ": unknown");
                }
                case DUMP: {
                    this.runDump();
                    return;
                }
                case RUN: {
                    this.runEmulation();
                    return;
                }
            }
        }
        catch (Exception x) {
            System.err.println("Error: " + x);
            System.err.println("   -at record " + this.m_recordNumber + ", file offset " + this.m_fileOffset);
            x.printStackTrace();
            return;
        }
        finally {
            this.releaseAll();
        }
    }

    private void openLog() throws Exception {
        File log = new File("dbreplay.log");
        this.m_log = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(log), 65536), "utf-8"));
        this.m_log.println("Log file start @" + new Date());
    }

    public void log(String s) {
        if (this.m_log == null) {
            return;
        }
        this.m_log.println(s);
    }

    public boolean isLogging() {
        return this.m_log != null;
    }

    public long getMaxStatementDelay() {
        return this.m_maxStatementDelay;
    }

    private void runDump() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runEmulation() throws Exception {
        Object rr;
        this.initialize();
        this.m_startTime = System.currentTimeMillis();
        while (null != (rr = ReplayRecord.readRecord(this))) {
            if (this.m_recordNumber == 0) {
                this.m_firstTime = ((ReplayRecord)rr).getStatementTime();
            }
            this.m_lastRecordTime = ((ReplayRecord)rr).getStatementTime();
            ++this.m_recordNumber;
            this.handleRecord((ReplayRecord)rr);
        }
        this.waitForIdle(60000L);
        rr = this;
        synchronized (rr) {
            this.m_stopped = true;
        }
        this.m_endTime = System.currentTimeMillis();
        System.out.println("Normal EOF after " + this.m_recordNumber + " records and " + this.m_fileOffset + " file bytes");
        Date st = new Date(this.m_firstTime);
        Date et = new Date(this.m_lastRecordTime);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("  - input time from " + df.format(st) + " till " + df.format(et) + ", " + DbPoolUtil.strMillis(this.m_lastRecordTime - this.m_firstTime));
        System.out.println("  - real time spent: " + DbPoolUtil.strMillis(this.m_endTime - this.m_startTime));
    }

    private boolean decodeOptions(String[] args) throws Exception {
        int argc = 0;
        while (argc < args.length) {
            String s;
            if ((s = args[argc++]).startsWith("-")) {
                if ("-pf".equals(s) || "-poolfile".equals(s)) {
                    if (argc >= args.length) {
                        throw new IllegalArgumentException("Missing file name after -poolfile");
                    }
                    this.m_poolFile = new File(args[argc++]);
                    if (this.m_poolFile.exists() && this.m_poolFile.isFile()) continue;
                    throw new IllegalArgumentException(this.m_poolFile + ": file not found");
                }
                if ("-dump".equals(s)) {
                    this.m_runType = XType.DUMP;
                    continue;
                }
                if ("-schema".equals(s)) {
                    if (argc >= args.length) {
                        throw new IllegalArgumentException("Missing name after -schema");
                    }
                    this.m_runSchema = args[argc++];
                    continue;
                }
                if ("-db".equals(s)) {
                    if (argc >= args.length) {
                        throw new IllegalArgumentException("Missing db string after -db");
                    }
                    this.decodeDb(args[argc++]);
                    continue;
                }
                if ("-dp".equals(s) || "-driver".equals(s)) {
                    if (argc >= args.length) {
                        throw new IllegalArgumentException("Missing driver path after " + s);
                    }
                    this.m_driverPath = new File(args[argc++]);
                    if (this.m_driverPath.exists() && this.m_driverPath.isFile()) continue;
                    throw new IllegalArgumentException(this.m_driverPath + ": invalid path (not a file or does not exist)");
                }
                if ("-maxwait".equals(s)) {
                    if (argc >= args.length) {
                        throw new IllegalArgumentException("Missing numeric value (milliseconds) after -maxwait");
                    }
                    this.m_maxStatementDelay = Long.parseLong(args[argc++]);
                    continue;
                }
                if ("-log".equals(s)) {
                    this.openLog();
                    continue;
                }
                if ("-speedy".equals(s)) {
                    this.m_replayer = new SpeedyReplayer();
                    continue;
                }
                if (this.m_replayer != null) {
                    if (-1 != (argc = this.m_replayer.decodeArgs(s, args, argc))) continue;
                    this.usage("Unknown option: " + s);
                    return false;
                }
                this.usage("Unknown option: " + s);
                return false;
            }
            if (this.m_inputFile == null) {
                this.m_inputFile = new File(s);
                if (this.m_inputFile.exists() && this.m_inputFile.isFile()) continue;
                throw new Exception(this.m_inputFile + ": file does not exist or is not a file.");
            }
            if (this.m_poolId == null) {
                this.m_poolId = s;
                continue;
            }
            this.usage("Unexpected extra argument on command line");
            return false;
        }
        if (this.m_inputFile == null) {
            this.usage("Missing input file name");
            return false;
        }
        if (this.m_poolId == null && this.m_dbHost == null) {
            this.usage("Missing pool ID or database (-db) specification");
            return false;
        }
        if (this.m_runType == null) {
            this.m_runType = XType.RUN;
        }
        if (this.m_replayer == null) {
            this.m_replayer = new TimeBasedReplayer();
        }
        return true;
    }

    private void decodeDb(String s) throws Exception {
        int pos = s.indexOf(64);
        if (pos != -1) {
            String a = s.substring(0, pos);
            String b = s.substring(pos + 1);
            pos = a.indexOf(58);
            if (pos != -1) {
                this.m_dbUser = a.substring(0, pos);
                this.m_dbPass = a.substring(pos + 1);
                pos = b.indexOf(47);
                if (pos != -1) {
                    this.m_dbHost = b.substring(0, pos);
                    this.m_dbSid = b.substring(pos + 1);
                    return;
                }
            }
        }
        throw new RuntimeException("Bad DB string: format is user:password@host/sid");
    }

    private void usage(String msg) {
        System.out.println("Error: " + msg);
        System.out.println("Usage: DbReplay [options] filename poolID");
        System.out.println("Options are:\n-poolfile|-pf [filename]: The name of the pool.properties defining the database connection.\n-schema [name]: set the 'current schema' before starting the tests (useful to run test logged in as a different user). For instance when running as a user 'TEST' when tables in schema VIEWPOINT are needed\n-db [userid:password@host/sid]: shorthand to connect to this specific database.\n-driver|-dp [path]: path to the Oracle driver .jar file, if not present on the classpath\n\n** replay options **\n-maxwait [milliseconds]: set the max time to wait between successive statements to a #of milliseconds. This ignores the real times that statements were sent to the database.\n-log: create a log of statements in dbreplay.log\n-speedy: run using the 'speedy' replayer\n\nSpeedy executor options:\n-perwait n: schedule this many SQL commands per 'maxwait' period. Example: -maxwait 1 -perwait 10 will try to execute 10 SQL statements every millisecond\n");
    }

    private void releaseAll() {
        try {
            if (this.m_log != null) {
                this.m_log.close();
            }
        }
        catch (Exception x) {
            System.err.println("Cannot close log: " + x);
        }
        finally {
            this.m_log = null;
        }
        try {
            if (this.m_bis != null) {
                this.m_bis.close();
            }
            this.m_bis = null;
        }
        catch (Exception x) {
            System.err.println("term: cannot close input file: " + x);
        }
        try {
            this.terminateAll();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public synchronized ConnectionPool getPool() {
        return this.m_pool;
    }

    public synchronized String getRunSchema() {
        return this.m_runSchema;
    }

    private void openSource() throws Exception {
        this.m_bis = new BufferedInputStream(new FileInputStream(this.m_inputFile), 65536);
    }

    private void initialize() throws Exception {
        if (this.m_dbHost != null) {
            String url = "jdbc:oracle:thin:@" + this.m_dbHost + ":1521:" + this.m_dbSid.toUpperCase();
            this.m_pool = PoolManager.getInstance().definePool("db", "oracle.jdbc.driver.OracleDriver", url, this.m_dbUser, this.m_dbPass, this.m_driverPath == null ? null : this.m_driverPath.toString());
        } else {
            this.m_pool = this.m_poolFile == null ? PoolManager.getInstance().definePool(this.m_poolId) : PoolManager.getInstance().definePool(this.m_poolFile, this.m_poolId);
        }
        this.startExecutors();
        this.startStatusReporter();
        this.waitForReady();
    }

    private synchronized boolean isStopped() {
        return this.m_stopped;
    }

    @Nullable
    public String readString() throws Exception {
        int len = this.readInt();
        if (len < 0) {
            return null;
        }
        byte[] data = new byte[len];
        int szrd = this.m_bis.read(data);
        if (szrd != len) {
            throw new IOException("Unexpected EOF: got " + szrd + " bytes but needed " + len);
        }
        this.m_fileOffset += (long)len;
        return new String(data, "utf-8");
    }

    public long readLong() throws Exception {
        long a = (long)this.readInt() & 0xFFFFFFFFL;
        long b = (long)this.readInt() & 0xFFFFFFFFL;
        return a << 32 | b;
    }

    public int readInt() throws Exception {
        int v = this.m_bis.read();
        if (v == -1) {
            throw new EOFException();
        }
        int r = v << 24;
        v = this.m_bis.read();
        if (v == -1) {
            throw new EOFException();
        }
        r |= v << 16;
        v = this.m_bis.read();
        if (v == -1) {
            throw new EOFException();
        }
        r |= v << 8;
        v = this.m_bis.read();
        if (v == -1) {
            throw new EOFException();
        }
        this.m_fileOffset += 4L;
        return r |= v;
    }

    public int readByte() throws Exception {
        int b = this.m_bis.read();
        if (-1 == b) {
            throw new EOFException();
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startExecutors() {
        System.out.println("init: starting " + this.m_executors + " executor threads");
        for (int i = 0; i < this.m_executors; ++i) {
            ReplayExecutor rx = new ReplayExecutor(this, i, this.m_idleExecutorList);
            DbReplay dbReplay = this;
            synchronized (dbReplay) {
                this.m_executorList.add(rx);
                this.m_freeExecutors.add(rx);
            }
            rx.setDaemon(true);
            rx.setName("x#" + i);
            rx.start();
        }
    }

    private synchronized List<ReplayExecutor> getExecutorList() {
        return new ArrayList<ReplayExecutor>(this.m_executorList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executorReady(ReplayExecutor replayExecutor) {
        DbReplay dbReplay = this;
        synchronized (dbReplay) {
            ++this.m_runningExecutors;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executorStopped(ReplayExecutor rx) {
        DbReplay dbReplay = this;
        synchronized (dbReplay) {
            --this.m_runningExecutors;
            this.notifyAll();
        }
    }

    public synchronized ReplayExecutor allocateExecutor() {
        if (this.m_freeExecutors.size() == 0) {
            ++this.m_missingConnections;
            return null;
        }
        return this.m_freeExecutors.remove(0);
    }

    public synchronized void releaseExecutor(ReplayExecutor rx) {
        if (null != rx) {
            this.m_freeExecutors.add(rx);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIdle(ReplayExecutor replayExecutor) {
        Set<ReplayExecutor> set = this.m_idleExecutorList;
        synchronized (set) {
            this.m_idleExecutorList.remove(replayExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIdle(ReplayExecutor rx) {
        Set<ReplayExecutor> set = this.m_idleExecutorList;
        synchronized (set) {
            if (!this.m_idleExecutorList.add(rx)) {
                throw new IllegalStateException("Executor already in idle set");
            }
            this.m_idleExecutorList.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueIdle(ReplayRecord rr) throws Exception {
        ReplayExecutor r = null;
        int tries = 20;
        while (true) {
            Set<ReplayExecutor> set = this.m_idleExecutorList;
            synchronized (set) {
                if (this.m_idleExecutorList.size() > 0) {
                    r = this.m_idleExecutorList.iterator().next();
                    break;
                }
                if (--tries <= 0) {
                    throw new IllegalStateException("No idle executors in 10 tries.");
                }
                this.m_idleExecutorList.wait(5000L);
            }
        }
        r.queue(rr);
    }

    Object getIdleLock() {
        return this.m_idleExecutorList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateAll() throws Exception {
        DbReplay dbReplay = this;
        synchronized (dbReplay) {
            if (this.m_executorList.size() == 0) {
                return;
            }
            this.m_freeExecutors.clear();
        }
        for (ReplayExecutor rx : this.getExecutorList()) {
            rx.terminate();
        }
        long ets = System.currentTimeMillis() + 30000L;
        while (true) {
            DbReplay dbReplay2;
            long ts;
            if ((ts = System.currentTimeMillis()) >= ets) {
                dbReplay2 = this;
                synchronized (dbReplay2) {
                    System.out.println("term: Timeout waiting for executors to terminate - " + this.m_runningExecutors + " of " + this.m_executors + " keep running");
                }
                return;
            }
            dbReplay2 = this;
            synchronized (dbReplay2) {
                if (this.m_runningExecutors <= 0) {
                    break;
                }
                System.out.println("term: waiting for " + this.m_runningExecutors + " of " + this.m_executors + " executors to terminate.");
                this.wait(5000L);
            }
        }
        this.m_executorList.clear();
        System.out.println("term: all executors stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForIdle(long timeout) throws Exception {
        System.out.println("exec: waiting for all executors to idle");
        long ets = System.currentTimeMillis() + timeout;
        long lmt = 0L;
        int lastrunning = -1;
        while (true) {
            long ts;
            if ((ts = System.currentTimeMillis()) >= ets) {
                throw new RuntimeException("Timeout: " + lastrunning + " executors do not become idle...");
            }
            lastrunning = 0;
            for (ReplayExecutor rx : this.getExecutorList()) {
                if (rx.isIdle()) continue;
                ++lastrunning;
            }
            if (lastrunning <= 0) break;
            DbReplay dbReplay = this;
            synchronized (dbReplay) {
                this.wait(1000L);
            }
        }
        System.out.println("exec: all executors have become idle.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForReady() throws Exception {
        long ets = System.currentTimeMillis() + 30000L;
        long lmt = 0L;
        while (true) {
            long ts;
            if ((ts = System.currentTimeMillis()) >= ets) {
                throw new RuntimeException("Timeout waiting for executors to start - aborting");
            }
            DbReplay dbReplay = this;
            synchronized (dbReplay) {
                int ntodo = this.m_executors - this.m_runningExecutors;
                if (ntodo <= 0) {
                    break;
                }
                if (ts >= lmt) {
                    System.out.println("init: waiting for " + ntodo + " of " + this.m_executors + " executors to become ready.");
                    lmt = ts + 5000L;
                }
                this.wait(5000L);
            }
        }
        System.out.println("init: ready for execution");
    }

    public synchronized void incIgnored() {
        ++this.m_ignoredStatements;
    }

    public synchronized void startExecution() {
        ++this.m_inExecution;
    }

    public synchronized void endExecution(int q, int u, int error, int rows) {
        --this.m_inExecution;
        this.m_executedQueries += (long)q;
        this.m_execErrors += (long)error;
        this.m_resultRows += (long)rows;
    }

    public synchronized int getInExecution() {
        return this.m_inExecution;
    }

    public synchronized void incConnSkips() {
        ++this.m_connSkips;
    }

    private void handleRecord(ReplayRecord rr) throws Exception {
        this.m_replayer.handleRecord(this, rr);
    }

    private void startStatusReporter() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                DbReplay.this.statusThreadRun();
            }
        });
        t.setName("status");
        t.setPriority(6);
        t.setDaemon(true);
        t.start();
    }

    private void statusThreadRun() {
        try {
            while (!this.isStopped()) {
                long ts = System.currentTimeMillis();
                long nts = ts + 5000L;
                this.displayStatus(ts);
                ts = System.currentTimeMillis();
                long delay = nts - ts;
                Thread.sleep(delay);
            }
        }
        catch (Exception x) {
            System.out.println("abnormal termination of status display thread: " + x);
        }
    }

    public static final String format(Date dt) {
        DateFormat df = m_dateFormat.get();
        if (null == df) {
            df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            m_dateFormat.set(df);
        }
        return df.format(dt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayStatus(long ts) {
        long sdt;
        double rps;
        double qps;
        long laststatustime;
        long lastrecordtime;
        long skips;
        long rr;
        long xq;
        long errs;
        long recnr;
        DbReplay dbReplay = this;
        synchronized (dbReplay) {
            recnr = this.m_recordNumber;
            errs = this.m_execErrors;
            xq = this.m_executedQueries;
            rr = this.m_resultRows;
            skips = this.m_ignoredStatements;
            lastrecordtime = this.m_lastRecordTime;
            laststatustime = this.m_ts_laststatus;
            this.m_ts_laststatus = ts;
            if (xq == 0L) {
                return;
            }
        }
        if (laststatustime == 0L) {
            qps = 0.0;
            rps = 0.0;
            sdt = 0L;
        } else {
            sdt = ts - laststatustime;
            qps = (double)(xq - this.m_previousQueryCount) / ((double)sdt / 1000.0);
            rps = (double)(rr - this.m_previousRowCount) / ((double)sdt / 1000.0);
        }
        if (this.m_statusLines++ % 20 == 0) {
            System.out.println("#act -#requests --#skipped ---#errors --#queries -----------#rows -queries/s ---#rows/s dT      realtime ");
            if (this.m_log != null) {
                this.m_log.println("#act -#requests --#skipped ---#errors --#queries -----------#rows -queries/s ---#rows/s dT      realtime");
            }
        }
        this.m_status_sb.setLength(0);
        this.m_status_sb.append(DbReplay.v(this.getInExecution(), 4));
        this.m_status_sb.append(DbReplay.v(recnr, 10));
        this.m_status_sb.append(DbReplay.v(skips, 10));
        this.m_status_sb.append(DbReplay.v(errs, 10));
        this.m_status_sb.append(DbReplay.v(xq, 10));
        this.m_status_sb.append(DbReplay.v(rr, 16));
        this.m_status_sb.append(DbReplay.dbl(qps, 10));
        this.m_status_sb.append(DbReplay.dbl(rps, 10));
        this.m_status_sb.append(DbReplay.dbl((double)sdt / 1000.0, 5));
        this.m_status_sb.append(DATEFORMAT.format(new Date(lastrecordtime)));
        String s = this.m_status_sb.toString();
        System.out.println(s);
        if (this.m_log != null) {
            this.m_log.println(s);
        }
        this.m_ts_laststatus = ts;
        this.m_previousQueryCount = xq;
        this.m_previousRowCount = rr;
    }

    private static String v(long value, int npos) {
        String val = DbPoolUtil.strCommad(value);
        int nfill = npos - val.length();
        if (nfill <= 0) {
            return val + " ";
        }
        return SPACES.substring(0, nfill) + val + " ";
    }

    private static String dbl(double v, int npos) {
        String val = String.format("%g", v);
        int nfill = npos - val.length();
        if (nfill <= 0) {
            return val + " ";
        }
        return SPACES.substring(0, nfill) + val + " ";
    }

    private static enum XType {
        DUMP,
        RUN;

    }
}

