/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbreplay;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import to.etc.dbreplay.DbReplay;
import to.etc.dbreplay.ReplayRecord;

class ReplayExecutor
extends Thread {
    private DbReplay m_r;
    private int m_index;
    private boolean m_terminate;
    private boolean m_terminated;
    private Connection m_dbc;
    private List<ReplayRecord> m_queueList = new ArrayList<ReplayRecord>();
    private boolean m_idle;
    private Object m_idleLock;

    public ReplayExecutor(DbReplay r, int index, Object idleLock) {
        this.m_r = r;
        this.m_index = index;
        this.m_idleLock = idleLock;
    }

    public synchronized void terminate() {
        this.m_terminate = true;
        this.notify();
        this.interrupt();
    }

    private synchronized boolean isTerminating() {
        return this.m_terminate;
    }

    public synchronized void queue(ReplayRecord q) {
        this.m_queueList.add(q);
        this.notify();
    }

    @Override
    public void run() {
        try {
            this.m_dbc = this.m_r.getPool().getUnpooledDataSource().getConnection();
            this.m_dbc.setAutoCommit(false);
            String rs = this.m_r.getRunSchema();
            if (rs != null) {
                this.sql("alter session set current_schema=" + rs);
            }
            this.m_r.executorReady(this);
            this.executeLoop();
        }
        catch (InterruptedException rs) {
        }
        catch (Exception x) {
            System.out.println(this.m_index + ": terminated due to " + x);
            x.printStackTrace();
        }
        finally {
            try {
                if (this.m_dbc != null) {
                    this.m_dbc.rollback();
                }
            }
            catch (Exception exception) {}
            try {
                if (this.m_dbc != null) {
                    this.m_dbc.close();
                }
            }
            catch (Exception exception) {}
            this.m_r.executorStopped(this);
            if (!this.isTerminating()) {
                System.out.println(this.m_index + ": terminated");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sql(String sql) throws Exception {
        PreparedStatement ps = null;
        try {
            ps = this.m_dbc.prepareStatement(sql);
            ps.executeUpdate();
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeLoop() throws Exception {
        while (true) {
            ReplayRecord rr = null;
            ReplayExecutor replayExecutor = this;
            synchronized (replayExecutor) {
                DbReplay dbReplay;
                if (this.m_terminate) {
                    boolean idle = this.isIdle();
                    this.setIdle(true);
                    if (idle) {
                        this.m_r.removeIdle(this);
                    }
                    DbReplay dbReplay2 = this.m_r;
                    synchronized (dbReplay2) {
                        this.m_r.notifyAll();
                    }
                    return;
                }
                if (this.m_queueList.size() > 0) {
                    rr = this.m_queueList.remove(0);
                    dbReplay = this.m_r;
                    synchronized (dbReplay) {
                        if (this.m_idle) {
                            this.m_r.removeIdle(this);
                            this.m_idle = false;
                        }
                    }
                }
                dbReplay = this.m_r;
                synchronized (dbReplay) {
                    if (!this.m_idle) {
                        this.m_r.addIdle(this);
                        this.m_idle = true;
                    }
                }
                this.wait(5000L);
            }
            if (null == rr) continue;
            this.execute(rr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        DbReplay dbReplay = this.m_r;
        synchronized (dbReplay) {
            return this.m_terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isIdle() {
        Object object = this.m_idleLock;
        synchronized (object) {
            return this.m_idle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIdle(boolean idle) {
        Object object = this.m_idleLock;
        synchronized (object) {
            this.m_idle = idle;
        }
    }

    private void execute(ReplayRecord rr) {
        if (rr.isUnexecutable()) {
            return;
        }
        switch (rr.getType()) {
            default: {
                this.m_r.incIgnored();
                return;
            }
            case 1: 
        }
        this.executeQueryStatement(rr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQueryStatement(ReplayRecord rr) {
        this.m_r.startExecution();
        int errs = 0;
        int rows = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.m_dbc.prepareStatement(rr.getSql());
            for (int i = 0; i < rr.getParamCount(); ++i) {
                rr.assignParameter(ps, i);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                ++rows;
            }
        }
        catch (Exception x) {
            if (this.m_r.isLogging()) {
                this.m_r.log(x.toString());
            }
            ++errs;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            this.m_r.endExecution(1, 0, errs, rows);
        }
    }
}

