/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbreplay;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import javax.annotation.Nonnull;
import to.etc.dbreplay.DbReplay;

class ReplayRecord {
    private int m_type;
    private long m_statementTime;
    private int m_connectionId;
    private String m_sql;
    private int m_paramCount;
    private Object[] m_parameterAr;
    private int[] m_parameterType;
    private boolean m_unexecutable;

    ReplayRecord() {
    }

    public static ReplayRecord readRecord(@Nonnull DbReplay r) throws Exception {
        try {
            long magic = r.readLong();
            if (magic != -6072317952152117587L) {
                throw new IOException("Invalid/missing record start marker");
            }
        }
        catch (EOFException x) {
            return null;
        }
        ReplayRecord rr = new ReplayRecord();
        rr.load(r);
        return rr;
    }

    private void load(@Nonnull DbReplay r) throws Exception {
        int type;
        this.m_type = type = r.readByte();
        this.m_statementTime = r.readLong();
        this.m_connectionId = r.readInt();
        switch (this.m_type) {
            case 4: 
            case 5: 
            case 6: {
                return;
            }
        }
        this.m_sql = r.readString();
        this.m_paramCount = r.readInt();
        if (this.m_paramCount < 0) {
            this.m_paramCount = 0;
        }
        this.m_parameterAr = new Object[this.m_paramCount];
        this.m_parameterType = new int[this.m_paramCount];
        for (int i = 0; i < this.m_parameterAr.length; ++i) {
            int ptype = r.readByte();
            this.m_parameterAr[i] = this.readParameter(r, ptype);
            this.m_parameterType[i] = ptype;
        }
        if (this.m_sql.toLowerCase().contains(" for update")) {
            this.m_unexecutable = true;
        }
    }

    private Object readParameter(DbReplay r, int type) throws Exception {
        switch (type) {
            default: {
                throw new IOException("Input: unexpected parameter type: " + type + " (" + (char)type + ")");
            }
            case 48: {
                return null;
            }
            case 105: {
                return r.readInt();
            }
            case 108: {
                return r.readLong();
            }
            case 66: {
                return new BigDecimal(r.readString());
            }
            case 100: {
                return Double.valueOf(r.readString());
            }
            case 102: {
                return Float.valueOf(r.readString());
            }
            case 36: {
                return r.readString();
            }
            case 84: {
                long ts = r.readLong();
                return new Timestamp(ts);
            }
            case 63: 
        }
        String name = r.readString();
        System.out.println("Unknown parameter type " + name + " in statement - marked as unexecutable");
        this.m_unexecutable = true;
        return null;
    }

    public void assignParameter(PreparedStatement ps, int index) throws Exception {
        Object v = this.m_parameterAr[index];
        switch (this.m_parameterType[index]) {
            default: {
                throw new IOException("assign: unexpected parameter type: " + this.m_parameterType[index]);
            }
            case 48: {
                ps.setString(index + 1, null);
                break;
            }
            case 105: {
                ps.setInt(index + 1, (Integer)v);
                break;
            }
            case 108: {
                ps.setLong(index + 1, (Long)v);
                break;
            }
            case 66: {
                ps.setBigDecimal(index + 1, (BigDecimal)v);
                break;
            }
            case 100: {
                ps.setDouble(index + 1, (Double)v);
                break;
            }
            case 102: {
                ps.setFloat(index + 1, ((Float)v).floatValue());
                break;
            }
            case 36: {
                ps.setString(index + 1, (String)v);
                break;
            }
            case 84: {
                ps.setTimestamp(index + 1, (Timestamp)v);
            }
        }
    }

    public int getType() {
        return this.m_type;
    }

    public long getStatementTime() {
        return this.m_statementTime;
    }

    public int getConnectionId() {
        return this.m_connectionId;
    }

    public String getSql() {
        return this.m_sql;
    }

    public int getParamCount() {
        return this.m_paramCount;
    }

    public Object[] getParameterAr() {
        return this.m_parameterAr;
    }

    public boolean isUnexecutable() {
        return this.m_unexecutable;
    }

    public int[] getParameterType() {
        return this.m_parameterType;
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(DbReplay.format(new Date(this.getStatementTime())));
        sb.append(" @").append(this.getConnectionId());
        sb.append(" ").append(this.m_sql);
        return sb.toString();
    }
}

