/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbreplay;

import to.etc.dbreplay.DbReplay;
import to.etc.dbreplay.IReplayer;
import to.etc.dbreplay.ReplayRecord;

public class SpeedyReplayer
implements IReplayer {
    private int m_perWait = 1;
    private int m_left;
    private long m_lastTs;

    @Override
    public int decodeArgs(String option, String[] args, int argc) {
        if ("-perwait".equals(option)) {
            if (argc >= args.length) {
                throw new IllegalArgumentException("Missing [count] for -perwait option (SpeedyReplayer)");
            }
            this.m_perWait = Integer.parseInt(args[argc++]);
            if (this.m_perWait <= 0) {
                throw new IllegalArgumentException("count for -perwait option must be > 0 (SpeedyReplayer)");
            }
            return argc;
        }
        return -1;
    }

    @Override
    public void handleRecord(DbReplay r, ReplayRecord rr) throws Exception {
        switch (rr.getType()) {
            default: {
                return;
            }
            case 1: 
        }
        long cts = System.currentTimeMillis();
        long maxwait = r.getMaxStatementDelay();
        if (this.m_lastTs == 0L) {
            this.m_lastTs = cts;
            this.m_left = this.m_perWait;
        } else if (this.m_left <= 0) {
            long dt = this.m_lastTs + maxwait - cts;
            if (dt > 0L) {
                Thread.sleep(dt);
            }
            this.m_left = this.m_perWait;
            this.m_lastTs = cts = System.currentTimeMillis();
        }
        --this.m_left;
        r.queueIdle(rr);
    }
}

