/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbreplay;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import to.etc.dbpool.DbPoolUtil;
import to.etc.dbreplay.DbReplay;
import to.etc.dbreplay.IReplayer;
import to.etc.dbreplay.ReplayExecutor;
import to.etc.dbreplay.ReplayRecord;

public class TimeBasedReplayer
implements IReplayer {
    private Map<Integer, ReplayExecutor> m_executorMap = new HashMap<Integer, ReplayExecutor>();
    private Set<Integer> m_ignoreSet = new HashSet<Integer>();
    private long m_lastReplayTime;
    private long m_lastRealTime;

    @Override
    public int decodeArgs(String option, String[] args, int argc) {
        return -1;
    }

    @Override
    public void handleRecord(DbReplay r, ReplayRecord rr) throws Exception {
        long ct = System.currentTimeMillis();
        Integer cid = rr.getConnectionId();
        if (rr.getType() == 6) {
            this.m_ignoreSet.remove(cid);
            ReplayExecutor rx = this.m_executorMap.remove(cid);
            if (null != rx) {
                r.releaseExecutor(rx);
            }
            return;
        }
        if (rr.getType() == 4 || rr.getType() == 5) {
            return;
        }
        if (this.m_ignoreSet.contains(cid)) {
            r.incConnSkips();
            return;
        }
        if (this.m_lastReplayTime == 0L) {
            this.m_lastReplayTime = rr.getStatementTime();
            this.m_lastRealTime = ct;
        } else {
            long deltat = rr.getStatementTime() - this.m_lastReplayTime;
            if (deltat < 0L) {
                deltat = 0L;
            }
            this.m_lastReplayTime = rr.getStatementTime();
            if (deltat > r.getMaxStatementDelay()) {
                deltat = r.getMaxStatementDelay();
            }
            if (deltat > 0L) {
                if (deltat > 5000L) {
                    System.out.println("       - long sleep of " + DbPoolUtil.strMillis(deltat));
                }
                Thread.sleep(deltat);
            }
            this.m_lastRealTime = ct;
        }
        ReplayExecutor rx = this.m_executorMap.get(cid);
        if (rx == null) {
            rx = r.allocateExecutor();
            if (null == rx) {
                this.m_ignoreSet.add(cid);
                r.log("no free executor: " + cid);
                return;
            }
            this.m_executorMap.put(cid, rx);
        }
        if (r.isLogging()) {
            r.log("x: " + rr.getSummary());
        }
        rx.queue(rr);
    }
}

