/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbutil;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class BaseDB {
    private final String m_name;

    protected BaseDB(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    protected abstract int getSequenceID(Connection var1, String var2) throws SQLException;

    protected abstract int getFullSequenceID(Connection var1, String var2) throws SQLException;

    protected abstract void setBlob(Connection var1, String var2, String var3, String var4, InputStream var5, int var6) throws SQLException;

    protected abstract void setBlob(Connection var1, String var2, String var3, String[] var4, Object[] var5, InputStream var6, int var7) throws SQLException;

    protected abstract String getCheckString();

    PreparedStatement mkKeyedSQL(Connection dbc, StringBuilder sb, String[] pkfields, Object[] keys, int baseix, String trailer) throws SQLException {
        if (pkfields.length != keys.length) {
            throw new IllegalStateException("PK fields array differs in size from key value array");
        }
        sb.append(" (");
        for (int i = 0; i < pkfields.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(pkfields[i]);
            sb.append("=?");
        }
        sb.append(')');
        if (trailer != null) {
            sb.append(' ');
            sb.append(trailer);
        }
        PreparedStatement ps = dbc.prepareStatement(sb.toString());
        for (int i = 0; i < keys.length; ++i) {
            int ix = baseix + i;
            Object k = keys[i];
            if (k == null) {
                throw new IllegalStateException("The key field " + pkfields[i] + " has a null value");
            }
            if (k instanceof String) {
                ps.setString(ix, (String)k);
                continue;
            }
            if (k instanceof Integer) {
                ps.setInt(ix, (Integer)k);
                continue;
            }
            if (k instanceof Long) {
                ps.setLong(ix, (Long)k);
                continue;
            }
            throw new IllegalStateException("Unsupported key object type: " + k.getClass().getName());
        }
        return ps;
    }

    public static int streamCopy(OutputStream os, InputStream is) throws IOException {
        byte[] buf = new byte[32768];
        int tsz = 0;
        while (true) {
            int nr;
            if ((nr = is.read(buf)) == 32768) {
                os.write(buf);
            } else {
                if (nr <= 0) break;
                os.write(buf, 0, nr);
            }
            tsz += nr;
        }
        return tsz;
    }

    protected abstract Reader getLobReader(Connection var1, ResultSet var2, int var3) throws Exception;

    protected abstract Reader getLobReader(Connection var1, ResultSet var2, String var3) throws Exception;

    protected abstract InputStream getLobStream(Connection var1, ResultSet var2, int var3) throws Exception;

    protected abstract InputStream getLobStream(Connection var1, ResultSet var2, String var3) throws Exception;

    public boolean oracleOuterJoin() {
        return false;
    }

    protected void setBlob(Connection dbc, String table, String column, String where, byte[][] data) throws SQLException {
        ByteBufferInputStream is = null;
        int len = 0;
        if (data != null) {
            for (byte[] b : data) {
                len += b.length;
            }
            is = new ByteBufferInputStream(data);
        }
        this.setBlob(dbc, table, column, where, is, len);
    }

    protected abstract void setClob(Connection var1, String var2, String var3, String var4, Reader var5) throws Exception;

    private static class ByteBufferInputStream
    extends InputStream {
        private byte[][] m_data;
        private int m_sz;
        private int m_off;
        private int m_bufix;
        private int m_bufoff;

        public ByteBufferInputStream(byte[][] data) {
            this.m_data = data;
            this.m_sz = this.calcDataSize();
        }

        private void setReadPos(int pos) {
            this.m_bufix = 0;
            this.m_off = 0;
            while (this.m_bufix < this.m_data.length) {
                int epos = this.m_off + this.m_data[this.m_bufix].length;
                if (epos > pos) {
                    this.m_bufoff = pos - this.m_off;
                    this.m_off = pos;
                    return;
                }
                this.m_off = epos;
                ++this.m_bufix;
            }
            this.m_off = this.m_sz;
        }

        private final int calcDataSize() {
            int sz = 0;
            int i = this.m_data.length;
            while (--i >= 0) {
                byte[] d = this.m_data[i];
                if (d == null) continue;
                sz += d.length;
            }
            return sz;
        }

        @Override
        public long skip(long n) throws IOException {
            this.m_off += (int)n;
            this.setReadPos(this.m_off);
            return this.m_off;
        }

        @Override
        public int read(byte[] parm1) throws IOException {
            return this.read(parm1, 0, parm1.length);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.setReadPos(0);
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int available() throws IOException {
            int sz = this.m_sz - this.m_off;
            if (sz < 0) {
                return 0;
            }
            return sz;
        }

        @Override
        public int read() throws IOException {
            if (this.m_off >= this.m_sz) {
                return -1;
            }
            byte[] buf = this.m_data[this.m_bufix];
            if (this.m_bufoff < buf.length) {
                ++this.m_off;
                return buf[this.m_bufoff++] & 0xFF;
            }
            ++this.m_bufix;
            buf = this.m_data[this.m_bufix];
            this.m_bufoff = 1;
            ++this.m_off;
            return buf[0] & 0xFF;
        }

        @Override
        public int read(byte[] odata, int ooff, int osz) throws IOException {
            int rsz;
            if (this.m_off >= this.m_sz) {
                return -1;
            }
            int szread = 0;
            while (osz > 0 && (rsz = this.m_sz - this.m_off) > 0) {
                int bsz;
                byte[] buf = this.m_data[this.m_bufix];
                if (this.m_bufoff >= buf.length) {
                    ++this.m_bufix;
                    buf = this.m_data[this.m_bufix];
                    this.m_bufoff = 0;
                }
                if (rsz > (bsz = buf.length - this.m_bufoff)) {
                    rsz = bsz;
                }
                if (rsz > osz) {
                    rsz = osz;
                }
                System.arraycopy(buf, this.m_bufoff, odata, ooff, rsz);
                this.m_bufoff += rsz;
                osz -= rsz;
                ooff += rsz;
                this.m_off += rsz;
                szread += rsz;
            }
            return szread;
        }
    }
}

