/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbutil;

import javax.annotation.Nonnull;

public class DbConnectionInfo {
    private final String m_hostname;
    private final String m_sid;
    private final String m_userid;
    private final String m_password;
    private final int m_port;

    private DbConnectionInfo(String hostname, String sid, String userid, String password, int port) {
        this.m_hostname = hostname;
        this.m_sid = sid;
        this.m_userid = userid;
        this.m_password = password;
        this.m_port = port;
    }

    @Nonnull
    public static DbConnectionInfo decode(@Nonnull String db) {
        int pos = db.indexOf(64);
        if (pos != -1) {
            String a = db.substring(0, pos);
            String b = db.substring(pos + 1);
            pos = a.indexOf(58);
            if (pos != -1) {
                String userid = a.substring(0, pos).trim();
                String password = a.substring(pos + 1).trim();
                pos = b.indexOf(47);
                if (pos != -1) {
                    String hostname;
                    int port;
                    String sid = b.substring(pos + 1).trim();
                    if ((pos = (b = b.substring(0, pos)).indexOf(58)) == -1) {
                        port = 1521;
                        hostname = b;
                    } else {
                        port = Integer.parseInt(b.substring(pos + 1).trim());
                        hostname = b.substring(0, pos);
                    }
                    return new DbConnectionInfo(hostname, sid, userid, password, port);
                }
            }
        }
        throw new IllegalArgumentException("Invalid database connect string: must be 'user:password@host:port/SID', not " + db);
    }

    public String getHostname() {
        return this.m_hostname;
    }

    public String getSid() {
        return this.m_sid;
    }

    public String getUserid() {
        return this.m_userid;
    }

    public String getPassword() {
        return this.m_password;
    }

    public int getPort() {
        return this.m_port;
    }
}

