/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbutil;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.sql.DataSource;
import to.etc.dbpool.PoolManager;

@ThreadSafe
public final class DbLockKeeper {
    private DataSource m_dataSource;
    private static final DbLockKeeper M_INSTANCE = new DbLockKeeper();
    private static final String TABLENAME = "SYS_SERVER_LOCKS";
    @GuardedBy(value="this")
    private static final Map<LockThreadKey, Lock> M_MAINTAINED_LOCKS = new HashMap<LockThreadKey, Lock>();

    public static synchronized DbLockKeeper getInstance() {
        if (DbLockKeeper.M_INSTANCE.m_dataSource == null) {
            throw new RuntimeException("DbLockKeeper not yet initialized");
        }
        return M_INSTANCE;
    }

    private DbLockKeeper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init(DataSource ds) {
        if (DbLockKeeper.M_INSTANCE.m_dataSource != null) {
            throw new RuntimeException("DbLockKeeper is already initialized.");
        }
        DbLockKeeper.M_INSTANCE.m_dataSource = ds;
        Statement ps = null;
        Connection dbc = null;
        try {
            dbc = ds.getConnection();
            dbc.setAutoCommit(false);
            ps = dbc.prepareStatement("create table SYS_SERVER_LOCKS ( LOCK_NAME varchar(60) not null primary key)");
            ps.executeUpdate();
            dbc.commit();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (dbc != null) {
                    dbc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockHandle lock(String lockName) throws Exception {
        Lock lock;
        LockThreadKey key = new LockThreadKey(lockName, Thread.currentThread());
        DbLockKeeper dbLockKeeper = this;
        synchronized (dbLockKeeper) {
            lock = M_MAINTAINED_LOCKS.get(key);
            if (lock != null) {
                return new LockHandle(lock);
            }
        }
        Connection dbc = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            dbc = this.m_dataSource.getConnection();
            PoolManager.setLongLiving(dbc);
            dbc.setAutoCommit(false);
            this.insertLock(lockName, dbc);
            ps = dbc.prepareStatement("select lock_name from SYS_SERVER_LOCKS where lock_name = '" + lockName + "' for update");
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new Exception("Lock with name: " + lockName + " not acquired");
            }
            lock = new Lock(this, lockName, dbc);
            LockHandle lh = new LockHandle(lock);
            Object object = this;
            synchronized (object) {
                M_MAINTAINED_LOCKS.put(key, lock);
            }
            dbc = null;
            object = lh;
            return object;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (dbc != null) {
                    dbc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LockHandle lockNowait(String lockName) throws Exception {
        Object object;
        Lock lock;
        LockThreadKey key = new LockThreadKey(lockName, Thread.currentThread());
        DbLockKeeper dbLockKeeper = this;
        synchronized (dbLockKeeper) {
            lock = M_MAINTAINED_LOCKS.get(key);
        }
        if (lock != null) {
            return new LockHandle(lock);
        }
        Connection dbc = this.m_dataSource.getConnection();
        Statement ps = null;
        ResultSet rs = null;
        try {
            dbc.setAutoCommit(false);
            PoolManager.setLongLiving(dbc);
            this.insertLock(lockName, dbc);
            ps = dbc.prepareStatement("select lock_name from SYS_SERVER_LOCKS where lock_name = '" + lockName + "' for update nowait");
            rs = ps.executeQuery();
            if (!rs.next()) {
                LockHandle lockHandle = null;
                return lockHandle;
            }
            lock = new Lock(this, lockName, dbc);
            LockHandle lh = new LockHandle(lock);
            object = this;
            synchronized (object) {
                M_MAINTAINED_LOCKS.put(key, lock);
            }
            dbc = null;
            object = lh;
        }
        catch (SQLException sx) {
            String msg = sx.getMessage().toLowerCase();
            if (msg.contains("NOWAIT") || msg.contains("ora-00054") || msg.contains("lock")) {
                LockHandle lockHandle = null;
                return lockHandle;
            }
            throw sx;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (dbc != null) {
                    dbc.close();
                }
            }
            catch (Exception exception) {}
        }
        return object;
    }

    private synchronized void releaseLock(String lockName) {
        LockThreadKey key = new LockThreadKey(lockName, Thread.currentThread());
        Lock lock = M_MAINTAINED_LOCKS.remove(key);
        if (lock == null || !lock.isClosed()) {
            throw new IllegalStateException("Lock with name:" + lockName + " has already been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertLock(String lockName, Connection dbc) {
        Statement ps = null;
        try {
            ps = dbc.prepareStatement("insert into SYS_SERVER_LOCKS (lock_name) values('" + lockName + "')");
            ps.executeUpdate();
            dbc.commit();
        }
        catch (Exception exception) {
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            try {
                dbc.rollback();
            }
            catch (Exception exception) {}
        }
    }

    public static final class LockHandle {
        private Lock m_lock;
        private boolean m_released;

        public LockHandle(Lock lock) {
            this.m_lock = lock;
            lock.increaseCounter();
        }

        public void release() {
            if (this.m_released) {
                return;
            }
            this.m_lock.release();
            this.m_released = true;
        }
    }

    private static final class Lock {
        private Connection m_lockedConnection;
        @GuardedBy(value="m_keeper")
        private int m_lockCounter;
        private String m_lockName;
        private DbLockKeeper m_keeper;

        public Lock(DbLockKeeper keeper, String lockName, Connection lockedConnection) {
            this.m_lockedConnection = lockedConnection;
            this.m_lockName = lockName;
            this.m_keeper = keeper;
        }

        public boolean isClosed() {
            return this.m_lockedConnection == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            DbLockKeeper dbLockKeeper = this.m_keeper;
            synchronized (dbLockKeeper) {
                --this.m_lockCounter;
                if (this.m_lockCounter == 0) {
                    try {
                        this.m_lockedConnection.rollback();
                    }
                    catch (SQLException x) {
                        x.printStackTrace();
                    }
                    finally {
                        try {
                            this.m_lockedConnection.close();
                        }
                        catch (Exception exception) {}
                        this.m_lockedConnection = null;
                    }
                    this.m_keeper.releaseLock(this.m_lockName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void increaseCounter() {
            DbLockKeeper dbLockKeeper = this.m_keeper;
            synchronized (dbLockKeeper) {
                ++this.m_lockCounter;
            }
        }
    }

    private static final class LockThreadKey {
        private String m_lockName;
        private Thread m_thread;

        public LockThreadKey(String lockName, Thread thread) {
            this.m_lockName = lockName;
            this.m_thread = thread;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_lockName == null ? 0 : this.m_lockName.hashCode());
            result = 31 * result + (this.m_thread == null ? 0 : this.m_thread.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LockThreadKey other = (LockThreadKey)obj;
            if (this.m_lockName == null ? other.m_lockName != null : !this.m_lockName.equals(other.m_lockName)) {
                return false;
            }
            return !(this.m_thread == null ? other.m_thread != null : !this.m_thread.equals(other.m_thread));
        }
    }
}

