/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbutil;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import to.etc.dbpool.DbPoolUtil;
import to.etc.dbutil.BaseDB;
import to.etc.dbutil.MysqlDB;
import to.etc.dbutil.OracleDB;
import to.etc.dbutil.PostgresDB;
import to.etc.dbutil.UnknownDB;

public class GenericDB {
    public static final BaseDB dbtypeUNKNOWN = new UnknownDB();
    public static final BaseDB dbtypeORACLE = new OracleDB();
    public static final BaseDB dbtypeMYSQL = new MysqlDB();
    public static final BaseDB dbtypePOSTGRESQL = new PostgresDB();

    private GenericDB() {
    }

    public static BaseDB getDbType(Connection dbc) {
        try {
            return GenericDB.getDbTypeByDriverName(dbc.getMetaData().getDriverName());
        }
        catch (Exception x) {
            return dbtypeUNKNOWN;
        }
    }

    public static BaseDB getDbTypeByDriverName(String dn) {
        if ((dn = dn.toLowerCase()).indexOf("oracle") != -1) {
            return dbtypeORACLE;
        }
        if (dn.indexOf("mysql") != -1) {
            return dbtypeMYSQL;
        }
        if (dn.indexOf("postgresql") != -1) {
            return dbtypePOSTGRESQL;
        }
        if (dn.indexOf("orac") != -1) {
            return dbtypeORACLE;
        }
        return dbtypeUNKNOWN;
    }

    private static BaseDB getBase(BaseDB db) {
        return db;
    }

    private static BaseDB getBase(Connection dbc) {
        return GenericDB.getBase(GenericDB.getDbType(dbc));
    }

    public static int getSequenceID(Connection dbc, String tablename) throws SQLException {
        return GenericDB.getBase(dbc).getSequenceID(dbc, tablename);
    }

    public static int getFullSequenceID(Connection dbc, String tablename) throws SQLException {
        return GenericDB.getBase(dbc).getFullSequenceID(dbc, tablename);
    }

    public static String getCheckString(BaseDB dbtype) {
        return GenericDB.getBase(dbtype).getCheckString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBlob(Connection dbc, String table, String column, String where, File f) throws Exception {
        BufferedInputStream bis = null;
        int len = 0;
        if (f != null) {
            len = (int)f.length();
            try {
                bis = new BufferedInputStream(new FileInputStream(f), 8192);
            }
            catch (FileNotFoundException x) {
                throw new SQLException("File " + f + " not found.");
            }
        }
        try {
            GenericDB.setBlob(dbc, table, column, where, bis, len);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void setBlob(Connection dbc, String table, String column, String where, String str) throws Exception {
        ByteArrayInputStream bais = null;
        int len = 0;
        if (str != null) {
            byte[] data = str.getBytes("utf8");
            bais = new ByteArrayInputStream(data);
            len = data.length;
        }
        GenericDB.setBlob(dbc, table, column, where, bais, len);
    }

    public static void setBlob(Connection dbc, String table, String column, String where, InputStream is, int len) throws Exception {
        GenericDB.getBase(dbc).setBlob(dbc, table, column, where, is, len);
    }

    public static void setBlob(Connection dbc, String table, String column, String where, byte[][] data) throws Exception {
        GenericDB.getBase(dbc).setBlob(dbc, table, column, where, data);
    }

    public static void setBlob(Connection dbc, String table, String column, String[] pkfields, Object[] key, InputStream is, int len) throws SQLException {
        GenericDB.getBase(dbc).setBlob(dbc, table, column, pkfields, key, is, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBlob(Connection dbc, String table, String column, String[] pkfields, Object[] key, File f) throws SQLException {
        BufferedInputStream bis = null;
        int len = 0;
        if (f != null) {
            len = (int)f.length();
            try {
                bis = new BufferedInputStream(new FileInputStream(f), 8192);
            }
            catch (FileNotFoundException x) {
                throw new SQLException("File " + f + " not found.");
            }
        }
        try {
            GenericDB.setBlob(dbc, table, column, pkfields, key, bis, len);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Reader getLobReader(Connection dbc, ResultSet rs, int col) throws Exception {
        return GenericDB.getBase(dbc).getLobReader(dbc, rs, col);
    }

    public static Reader getLobReader(Connection dbc, ResultSet rs, String col) throws Exception {
        return GenericDB.getBase(dbc).getLobReader(dbc, rs, col);
    }

    public static InputStream getLobStream(Connection dbc, ResultSet rs, int col) throws Exception {
        return GenericDB.getBase(dbc).getLobStream(dbc, rs, col);
    }

    public static InputStream getLobStream(Connection dbc, ResultSet rs, String col) throws Exception {
        return GenericDB.getBase(dbc).getLobStream(dbc, rs, col);
    }

    public static void setClob(Connection dbc, String table, String column, String where, Reader r) throws Exception {
        GenericDB.getBase(dbc).setClob(dbc, table, column, where, r);
    }

    public static void setClob(Connection dbc, String table, String column, String where, String content) throws Exception {
        StringReader r = new StringReader(content);
        GenericDB.setClob(dbc, table, column, where, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveBlob(ResultSet rs, int col, File f) throws Exception {
        OutputStream os = null;
        InputStream is = null;
        is = GenericDB.getLobStream(rs.getStatement().getConnection(), rs, col);
        if (is == null) {
            boolean bl = false;
            return bl;
        }
        os = new FileOutputStream(f);
        DbPoolUtil.copyFile(os, is);
        boolean bl = true;
        return bl;
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveBlob(ResultSet rs, String col, File f) throws Exception {
        OutputStream os = null;
        InputStream is = null;
        is = GenericDB.getLobStream(rs.getStatement().getConnection(), rs, col);
        if (is == null) {
            boolean bl = false;
            return bl;
        }
        os = new FileOutputStream(f);
        DbPoolUtil.copyFile(os, is);
        boolean bl = true;
        return bl;
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveBlob(ResultSet rs, int col, OutputStream os) throws Exception {
        InputStream is = null;
        is = GenericDB.getLobStream(rs.getStatement().getConnection(), rs, col);
        if (is == null) {
            boolean bl = false;
            return bl;
        }
        DbPoolUtil.copyFile(os, is);
        boolean bl = true;
        return bl;
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static String getScriptResource(@Nonnull Connection dbc, @Nonnull Class<?> clz, @Nonnull String baseName) throws Exception {
        BaseDB type = GenericDB.getDbType(dbc);
        String name = type.getName();
        InputStream is = null;
        try {
            String r;
            String suff = ".sql";
            String root = baseName;
            int pos = baseName.lastIndexOf(46);
            if (pos != -1) {
                suff = baseName.substring(pos);
                root = baseName.substring(0, pos);
            }
            if (null == (is = clz.getResourceAsStream(r = root + "-" + name + suff)) && (is = clz.getResourceAsStream(root + suff)) == null) {
                throw new SQLException("The SQL resource file " + baseName + " (relative to " + clz.getName() + ") cannot be found.");
            }
            String string = GenericDB.readStreamAsString(is, "utf-8");
            return string;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStreamAsString(InputStream is, String enc) throws Exception {
        StringBuilder sb = new StringBuilder(128);
        try (InputStreamReader r = new InputStreamReader(is, enc);){
            int ct;
            char[] buf = new char[4096];
            while ((ct = r.read(buf)) >= 0) {
                sb.append(new String(buf, 0, ct));
            }
        }
        return sb.toString();
    }

    public static void runScriptResource(Connection dbc, Class<?> clz, String name, StringBuilder errors) throws Exception {
        String[] ar;
        String script = GenericDB.getScriptResource(dbc, clz, name);
        for (String s : ar = script.split("//")) {
            GenericDB.runSQL(dbc, s, errors);
        }
    }

    private static boolean isWhiteSpaceOrNbsp(char c) {
        return c == '\u00a0' || Character.isWhitespace(c);
    }

    private static boolean isAllSpaces(String s) {
        int i = s.length();
        while (--i >= 0) {
            if (GenericDB.isWhiteSpaceOrNbsp(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runSQL(Connection dbc, String s, StringBuilder errors) {
        if (GenericDB.isAllSpaces(s = s.trim())) {
            return;
        }
        PreparedStatement ps = null;
        try {
            ps = dbc.prepareStatement(s);
            ps.executeUpdate();
            dbc.commit();
        }
        catch (Exception x) {
            errors.append(s).append("\n").append("ERROR: ").append(x.toString()).append("\n");
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                dbc.rollback();
            }
            catch (Exception exception) {}
        }
    }
}

