/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbutil;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import to.etc.dbutil.BaseDB;

public class MysqlDB
extends BaseDB {
    public MysqlDB() {
        super("mysql");
    }

    @Override
    protected String getCheckString() {
        return "select 1";
    }

    @Override
    protected int getSequenceID(Connection dbc, String tablename) throws SQLException {
        try {
            return MysqlDB.getMysqlSequenceTry(dbc);
        }
        catch (Exception exception) {
            MysqlDB.createMysqlSequence(dbc);
            return MysqlDB.getMysqlSequenceTry(dbc);
        }
    }

    @Override
    protected int getFullSequenceID(Connection dbc, String tablename) throws SQLException {
        return this.getSequenceID(dbc, tablename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getMysqlSequenceTry(Connection dbc) throws SQLException {
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            ps = dbc.prepareStatement("update sequence set id=LAST_INSERT_ID(id+1)");
            ps.executeUpdate();
            ps.close();
            ps = null;
            ps = dbc.prepareStatement("select last_insert_id()");
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("genid Query no results!?");
            }
            int n = rs.getInt(1);
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void createMysqlSequence(Connection dbc) {
        PreparedStatement ps = null;
        try {
            ps = dbc.prepareStatement("create table sequence (id integer not null)");
            ps.executeUpdate();
            ps.close();
            ps = dbc.prepareStatement("insert into sequence values(1)");
            ps.executeUpdate();
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setBlob(Connection dbc, String table, String column, String[] pkfields, Object[] key, InputStream is, int len) throws SQLException {
        Statement ps = null;
        try {
            int rc;
            StringBuilder sb = new StringBuilder();
            sb.append("update ");
            sb.append(table);
            sb.append(" set ");
            sb.append(column);
            sb.append('=');
            if (is == null) {
                sb.append("null");
            } else {
                sb.append('?');
            }
            sb.append(" where ");
            ps = this.mkKeyedSQL(dbc, sb, pkfields, key, is == null ? 1 : 2, null);
            if (is != null) {
                ps.setBinaryStream(1, is, len);
            }
            if ((rc = ps.executeUpdate()) != 1) {
                throw new SQLException("Record in table " + table + " not found for BLOB update.");
            }
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setBlob(Connection dbc, String table, String column, String where, InputStream is, int len) throws SQLException {
        Statement ps = null;
        try {
            if (is == null) {
                ps = dbc.prepareStatement("update " + table + " set " + column + " = null where " + where);
            } else {
                ps = dbc.prepareStatement("update " + table + " set " + column + " = ? where " + where);
                ps.setBinaryStream(1, is, len);
            }
            int rc = ps.executeUpdate();
            if (rc != 1) {
                throw new SQLException("Record in table " + table + " with key " + where + " not found for BLOB update.");
            }
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setClob(Connection dbc, String table, String column, String where, Reader r) throws Exception {
        Statement ps = null;
        try {
            if (r == null) {
                ps = dbc.prepareStatement("update " + table + " set " + column + " = null where " + where);
            } else {
                ps = dbc.prepareStatement("update " + table + " set " + column + " = ? where " + where);
                ps.setCharacterStream(1, r, Integer.MAX_VALUE);
            }
            int rc = ps.executeUpdate();
            if (rc != 1) {
                throw new SQLException("Record in table " + table + " with key " + where + " not found for BLOB update.");
            }
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected Reader getLobReader(Connection dbc, ResultSet rs, int col) throws Exception {
        Blob b = rs.getBlob(col);
        if (b == null) {
            return null;
        }
        return new InputStreamReader(b.getBinaryStream());
    }

    @Override
    protected Reader getLobReader(Connection dbc, ResultSet rs, String col) throws Exception {
        Blob b = rs.getBlob(col);
        if (b == null) {
            return null;
        }
        return new InputStreamReader(b.getBinaryStream());
    }

    @Override
    protected InputStream getLobStream(Connection dbc, ResultSet rs, int col) throws Exception {
        Blob b = rs.getBlob(col);
        if (b == null) {
            return null;
        }
        return b.getBinaryStream();
    }

    @Override
    protected InputStream getLobStream(Connection dbc, ResultSet rs, String col) throws Exception {
        Blob b = rs.getBlob(col);
        if (b == null) {
            return null;
        }
        return b.getBinaryStream();
    }
}

