/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbutil;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.dbpool.DbPoolUtil;
import to.etc.dbutil.BaseDB;

public class OracleDB
extends BaseDB {
    public static Logger LOG = LoggerFactory.getLogger(OracleDB.class);

    public OracleDB() {
        super("oracle");
    }

    @Override
    protected String getCheckString() {
        return "select 1 from dual";
    }

    @Override
    protected int getSequenceID(Connection dbc, String tablename) throws SQLException {
        return this.getFullSequenceID(dbc, tablename + "_sq");
    }

    @Override
    protected int getFullSequenceID(Connection dbc, String seqname) throws SQLException {
        try {
            return this.trySequenceID(dbc, seqname);
        }
        catch (Exception exception) {
            this.createSequence(dbc, seqname);
            return this.trySequenceID(dbc, seqname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSequence(Connection dbc, String table) {
        Statement ps = null;
        try {
            ps = dbc.prepareStatement("create sequence " + table + " start with 1 increment by 1");
            ps.executeUpdate();
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int trySequenceID(Connection dbc, String tablename) throws SQLException {
        ResultSet rs = null;
        Statement ps = null;
        try {
            ps = dbc.prepareStatement("select " + tablename + ".nextval from dual");
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("genid Query no results!?");
            }
            int n = rs.getInt(1);
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected void setBlob(Connection dbc, String table, String column, String where, InputStream is, int len) throws SQLException {
        this._setBlob(dbc, table, column, where, is, len);
    }

    @Override
    protected void setBlob(Connection dbc, String table, String column, String where, byte[][] data) throws SQLException {
        int len = 0;
        if (data != null) {
            for (byte[] d : data) {
                len += d.length;
            }
        }
        this._setBlob(dbc, table, column, where, data, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setBlob(Connection dbc, String table, String column, String where, Object data, int len) throws SQLException {
        ResultSet rs = null;
        Statement ps = null;
        OutputStream os = null;
        boolean isac = dbc.getAutoCommit();
        boolean okay = false;
        try {
            if (isac) {
                dbc.setAutoCommit(false);
            }
            StringBuilder sb = new StringBuilder(64);
            sb.append("update ");
            sb.append(table);
            sb.append(" set ");
            sb.append(column);
            sb.append(" = ");
            sb.append(data == null ? "null" : "empty_blob()");
            sb.append(" where ");
            sb.append(where);
            ps = dbc.prepareStatement(sb.toString());
            ps.executeUpdate();
            ps.close();
            ps = null;
            if (data == null) {
                okay = true;
                return;
            }
            String s1 = "select " + column + " from " + table + " where " + where + " for update of " + column;
            ps = dbc.prepareStatement(s1);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("Record in table " + table + " with key " + where + " not found for BLOB update.");
            }
            Blob tb = rs.getBlob(1);
            os = (OutputStream)OracleDB.callObjectMethod(tb, "getBinaryOutputStream");
            try {
                if (data instanceof InputStream) {
                    OracleDB.streamCopy(os, (InputStream)data);
                } else {
                    byte[][] in = (byte[][])data;
                    for (int i = 0; i < in.length; ++i) {
                        os.write(in[i]);
                    }
                }
            }
            catch (IOException x) {
                x.printStackTrace();
                throw new SQLException("IO error in BLOB copy (wrapped): " + x);
            }
            finally {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
            os = null;
            ps.close();
            ps = null;
            if (isac) {
                dbc.commit();
            }
            okay = true;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (!okay && isac) {
                    dbc.rollback();
                }
            }
            catch (Exception exception) {}
            try {
                if (dbc.getAutoCommit() != isac) {
                    dbc.setAutoCommit(isac);
                }
            }
            catch (Exception exception) {}
        }
    }

    private static Object callObjectMethod(Object src, String name) throws SQLException {
        try {
            Method m = src.getClass().getMethod(name, new Class[0]);
            return m.invoke(src, new Object[0]);
        }
        catch (InvocationTargetException itx) {
            if (itx.getCause() instanceof SQLException) {
                throw (SQLException)itx.getCause();
            }
            throw new RuntimeException(itx.getCause().toString(), itx.getCause());
        }
        catch (Exception x) {
            throw new RuntimeException("Exception calling " + name + " on " + src + ": " + x, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setBlob(Connection dbc, String table, String column, String[] pkfields, Object[] key, InputStream is, int len) throws SQLException {
        ResultSet rs = null;
        Statement ps = null;
        OutputStream os = null;
        boolean isac = dbc.getAutoCommit();
        boolean okay = false;
        try {
            if (isac) {
                dbc.setAutoCommit(false);
            }
            StringBuilder sb = new StringBuilder(64);
            sb.append("update ");
            sb.append(table);
            sb.append(" set ");
            sb.append(column);
            sb.append(" = ");
            sb.append(is == null ? "null" : "empty_blob()");
            sb.append(" where ");
            ps = this.mkKeyedSQL(dbc, sb, pkfields, key, 1, null);
            ps.executeUpdate();
            ps.close();
            ps = null;
            if (is == null) {
                okay = true;
                return;
            }
            sb.setLength(0);
            sb.append("select ");
            sb.append(column);
            sb.append(" from ");
            sb.append(table);
            sb.append(" where ");
            ps = this.mkKeyedSQL(dbc, sb, pkfields, key, 1, "for update of " + column);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("Record in table " + table + " not found for BLOB update.");
            }
            Blob tb = rs.getBlob(1);
            os = (OutputStream)OracleDB.callObjectMethod(tb, "getBinaryOutputStream");
            try {
                OracleDB.streamCopy(os, is);
            }
            catch (IOException x) {
                x.printStackTrace();
                throw new SQLException("IO error in BLOB copy (wrapped): " + x);
            }
            finally {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
            os = null;
            ps.close();
            ps = null;
            if (isac) {
                dbc.commit();
            }
            okay = true;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (!okay && isac) {
                    dbc.rollback();
                }
            }
            catch (Exception exception) {}
            try {
                if (dbc.getAutoCommit() != isac) {
                    dbc.setAutoCommit(isac);
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setBlob_old(Connection dbc, String table, String column, String where, InputStream is, int len) throws Exception {
        ResultSet rs = null;
        Statement ps = null;
        OutputStream os = null;
        boolean isac = dbc.getAutoCommit();
        boolean okay = false;
        try {
            String s1;
            if (isac) {
                dbc.setAutoCommit(false);
            }
            if (!(rs = (ps = dbc.prepareStatement(s1 = "select " + column + " from " + table + " where " + where + " for update of " + column)).executeQuery()).next()) {
                throw new SQLException("Record in table " + table + " with key " + where + " not found for BLOB update.");
            }
            Blob tb = rs.getBlob(1);
            if (tb == null || rs.wasNull()) {
                if (is == null) {
                    okay = true;
                    return;
                }
                rs.close();
                PreparedStatement ps2 = dbc.prepareStatement("update " + table + " set " + column + " = empty_blob() where " + where);
                int rc = ps2.executeUpdate();
                if (rc != 1) {
                    throw new SQLException("Record in table " + table + " with key " + where + " not found 2nd time!?");
                }
                ps2.close();
                rs = ps.executeQuery();
                if (!rs.next()) {
                    throw new SQLException("Record in table " + table + " with key " + where + " not found for BLOB update after I just inserted an empty blob!?.");
                }
                tb = rs.getBlob(1);
            } else if (is == null) {
                rs.close();
                ps.close();
                PreparedStatement ps2 = dbc.prepareStatement("update " + table + " set " + column + " = null where " + where);
                int rc = ps2.executeUpdate();
                if (rc != 1) {
                    throw new SQLException("Record in table " + table + " with key " + where + " not found 2nd time!?");
                }
                ps2.close();
                dbc.commit();
                okay = true;
                return;
            }
            os = (OutputStream)OracleDB.callObjectMethod(tb, "getBinaryOutputStream");
            OracleDB.streamCopy(os, is);
            os.close();
            os = null;
            ps.close();
            ps = null;
            if (isac) {
                dbc.commit();
            }
            okay = true;
            return;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (!okay) {
                    dbc.rollback();
                }
            }
            catch (Exception exception) {}
            try {
                if (dbc.getAutoCommit() != isac) {
                    dbc.setAutoCommit(isac);
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected Reader getLobReader(Connection dbc, ResultSet rs, int col) throws Exception {
        Blob b = rs.getBlob(col);
        if (b == null) {
            return null;
        }
        return new InputStreamReader(b.getBinaryStream());
    }

    @Override
    protected Reader getLobReader(Connection dbc, ResultSet rs, String col) throws Exception {
        Blob b = rs.getBlob(col);
        if (b == null) {
            return null;
        }
        return new InputStreamReader(b.getBinaryStream());
    }

    @Override
    protected InputStream getLobStream(Connection dbc, ResultSet rs, int col) throws Exception {
        Blob b = rs.getBlob(col);
        if (b == null) {
            return null;
        }
        return b.getBinaryStream();
    }

    @Override
    protected InputStream getLobStream(Connection dbc, ResultSet rs, String col) throws Exception {
        Blob b = rs.getBlob(col);
        if (b == null) {
            return null;
        }
        return b.getBinaryStream();
    }

    @Override
    public boolean oracleOuterJoin() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setClob(Connection dbc, String table, String column, String where, Reader r) throws Exception {
        Statement ps = null;
        boolean auc = false;
        try {
            auc = dbc.getAutoCommit();
            if (auc) {
                dbc.setAutoCommit(false);
            }
            if (r == null) {
                ps = dbc.prepareStatement("update " + table + " set " + column + " = null where " + where);
                if (ps.executeUpdate() != 1) {
                    throw new SQLException("The record cannot be found (update to empty)");
                }
                return;
            }
            ps = dbc.prepareStatement("update " + table + " set " + column + " = empty_clob() where " + where);
            if (ps.executeUpdate() != 1) {
                throw new SQLException("The record cannot be found (update to empty)");
            }
            ps.close();
            ps = null;
            String st = "select " + column + " from " + table + " where " + where + " for update";
            ps = dbc.prepareStatement(st, 1004, 1008);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("The record cannot be found (select)");
            }
            Clob clob = rs.getClob(1);
            Writer w = (Writer)OracleDB.callObjectMethod(clob, "getCharacterOutputStream");
            char[] buf = new char[4096];
            try {
                int szrd;
                while (0 < (szrd = r.read(buf))) {
                    w.write(buf, 0, szrd);
                }
                w.close();
            }
            catch (IOException x) {
                throw new SQLException("IOException on CLOB write: " + x.toString());
            }
            rs.updateRow();
            if (auc) {
                dbc.commit();
                dbc.setAutoCommit(true);
            }
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (auc) {
                    dbc.setAutoCommit(true);
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSynonyms(@Nonnull DataSource ds, @Nonnull String owner, String ... objectNames) {
        PreparedStatement ps = null;
        Statement ps2 = null;
        ResultSet rs = null;
        Connection dbc = null;
        try {
            dbc = ds.getConnection();
            ps = dbc.prepareStatement("select owner,object_name from dba_objects where object_type = 'SYNONYM' and status = 'INVALID'");
            rs = ps.executeQuery();
            while (rs.next()) {
                String sowner = rs.getString(1);
                String name = rs.getString(2);
                Statement st = null;
                try {
                    st = dbc.createStatement();
                    if ("PUBLIC".equals(sowner)) {
                        st.executeUpdate("drop public synonym \"" + name + "\"");
                        continue;
                    }
                    st.executeUpdate("drop synonym \"" + sowner + "\".\"" + name + "\"");
                }
                catch (Exception x) {
                    System.out.println("Failed to drop synonym " + sowner + "." + name + ": " + x);
                }
                finally {
                    try {
                        if (null == st) continue;
                        st.close();
                    }
                    catch (Exception x) {}
                }
            }
            rs.close();
            ps.close();
            int ct = 0;
            long ts = System.currentTimeMillis();
            String objectNamesFilter = null;
            if (objectNames != null && objectNames.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (String object : objectNames) {
                    sb.append("'").append(object).append("',");
                }
                sb.setLength(sb.length() - 1);
                objectNamesFilter = " and o.object_name in (" + sb.toString() + ")";
            }
            ps = dbc.prepareStatement("select o.object_name from dba_objects o where o.owner = '" + owner + "' and not (o.object_type in ('TYPE', 'SYNONYM'))" + (objectNamesFilter != null ? objectNamesFilter : "") + " and not (object_name like 'SYS@_PLSQL@_%' escape '@') and not exists  ( select 1 from dba_synonyms s where s.owner = 'PUBLIC' and s.synonym_name = o.object_name )");
            HashSet<String> todoSet = new HashSet<String>();
            rs = ps.executeQuery();
            while (rs.next()) {
                String res = rs.getString(1);
                if (null == res) continue;
                todoSet.add(res);
            }
            rs.close();
            ps.close();
            for (String on : todoSet) {
                LOG.info(owner + ": create missing synonym '" + on + "'");
                try {
                    ps2 = dbc.prepareStatement("create public synonym \"" + on + "\" for " + owner + ".\"" + on + "\"");
                    ps2.executeUpdate();
                }
                catch (Exception x) {
                    String msg = x.toString();
                    if (!msg.contains("xxORA-00955")) {
                        System.out.println(owner + ": error creating synonym " + on + ": " + x);
                        LOG.error(owner + ": error creating synonym " + on + ": " + x);
                    }
                }
                finally {
                    ps2.close();
                }
                ++ct;
            }
            ts = System.currentTimeMillis() - ts;
            LOG.info(owner + ": created " + ct + " public synonyms in " + DbPoolUtil.strMillis(ts));
        }
        catch (Exception x) {
            System.out.println(owner + ": exception while trying to create missing synonyms: " + x);
            LOG.error(owner + ": exception while trying to create missing synonyms: " + x);
            x.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps2 != null) {
                    ps2.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != dbc) {
                    dbc.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object runAsOtherSchemaUser(@Nonnull DataSource otherSchemaDs, @Nonnull String otherUserName, @Nonnull DataSource defaultDs, @Nonnull IPrivilegedAction paction) throws Exception {
        Connection otherSchemaConn = null;
        Connection defaultConn = defaultDs.getConnection();
        try {
            otherSchemaConn = OracleDB.allocateConnectionAs(otherSchemaDs, otherUserName, defaultConn);
            Object object = paction.execute(otherSchemaConn);
            return object;
        }
        finally {
            try {
                if (otherSchemaConn != null) {
                    otherSchemaConn.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (defaultConn != null) {
                    defaultConn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Connection allocateConnectionAs(@Nonnull DataSource otherSchemaDs, @Nonnull String otherUserName, @Nonnull Connection sourceConn) throws Exception {
        Connection connection;
        boolean phase = false;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String realhashpass = null;
        String tmppass = "h3rr4lbr4k";
        Connection otherSchemaConn = null;
        try {
            ps = sourceConn.prepareStatement("select user from dual");
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("Cannot get own user id");
            }
            String myuid = rs.getString(1);
            if (myuid == null) {
                throw new SQLException("Cannot get own user id");
            }
            if (myuid.equalsIgnoreCase(otherUserName)) {
                throw new IllegalArgumentException("Trying to get a connection for user=" + otherUserName + " - but you are that user");
            }
            rs.close();
            ps.close();
            ps = sourceConn.prepareStatement("select password from dba_users where username='" + otherUserName + "'");
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("The privileged " + otherUserName + " user cannot be found in the data dictionary");
            }
            realhashpass = rs.getString(1);
            if (null == realhashpass) {
                rs.close();
                ps.close();
                ps = sourceConn.prepareStatement("select password from sys.user$ where name='" + otherUserName + "'");
                rs = ps.executeQuery();
                if (!rs.next()) {
                    throw new SQLException("The privileged " + otherUserName + " user cannot be found in the sys.user$ table");
                }
                realhashpass = rs.getString(1);
                if (null == realhashpass) {
                    throw new SQLException("Null hash for privileged " + otherUserName + " user?");
                }
            }
            rs.close();
            rs = null;
            ps.close();
            ps = null;
            ps = sourceConn.prepareStatement("alter user " + otherUserName + " identified by " + tmppass);
            ps.executeUpdate();
            phase = true;
            ps.close();
            ps = null;
            otherSchemaConn = otherSchemaDs.getConnection(otherUserName, tmppass);
            otherSchemaConn.setAutoCommit(false);
            ps = sourceConn.prepareStatement("alter user " + otherUserName + " identified by values '" + realhashpass + "'");
            ps.executeUpdate();
            ps.close();
            ps = null;
            phase = false;
            Connection newc = otherSchemaConn;
            otherSchemaConn = null;
            connection = newc;
        }
        catch (Throwable throwable) {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (phase) {
                OracleDB.restorePassword(sourceConn, otherUserName, realhashpass);
            }
            try {
                if (otherSchemaConn != null) {
                    otherSchemaConn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (phase) {
            OracleDB.restorePassword(sourceConn, otherUserName, realhashpass);
        }
        try {
            if (otherSchemaConn != null) {
                otherSchemaConn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restorePassword(@Nonnull Connection dbc, @Nonnull String userName, @Nonnull String hash) {
        Statement ps = null;
        try {
            ps = dbc.prepareStatement("alter user " + userName + " identified by values '" + hash + "'");
            ps.executeUpdate();
        }
        catch (Exception x) {
            System.out.println("FATAL: Cannot restore the password for the " + userName + " user!!!!");
            x.printStackTrace();
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCharSemantics(@Nonnull Connection dbc, boolean ischar) throws Exception {
        Statement ps = null;
        try {
            ps = dbc.prepareStatement("alter session set nls_length_semantics=" + (ischar ? "CHAR" : "BYTE"));
            ps.executeUpdate();
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recompileAll(@Nonnull Connection dbc, @Nonnull String schema, boolean invalidsonly, boolean charsemantics) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            OracleDB.setCharSemantics(dbc, charsemantics);
            ps = dbc.prepareStatement("select owner,object_name from dba_objects where object_type = 'SYNONYM' and (object_name like 'SYS_PLSQL_%' or status = 'INVALID')");
            rs = ps.executeQuery();
            ArrayList<Pair> all = new ArrayList<Pair>();
            while (rs.next()) {
                all.add(new Pair(rs.getString(1), rs.getString(2)));
            }
            rs.close();
            ps.close();
            for (Pair p : all) {
                OracleDB.dropSynonym(dbc, p);
            }
            ps = dbc.prepareStatement("begin dbms_utility.compile_schema(schema=>?, compile_all=>" + (invalidsonly ? "FALSE" : "TRUE") + "); end;");
            ps.setString(1, schema.toUpperCase());
            ps.executeUpdate();
            ps.close();
            ps = dbc.prepareStatement("begin dbms_session.reset_package; end;");
            ps.executeUpdate();
            ps.close();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dropSynonym(@Nonnull Connection dbc, @Nonnull Pair p) {
        Statement ps = null;
        try {
            String sql = "PUBLIC".equalsIgnoreCase(p.getOwner()) ? "drop public synonym \"" + p.getName() + "\"" : "drop synonym " + p.getOwner() + ".\"" + p.getName() + "\"";
            ps = dbc.prepareStatement(sql);
            ps.executeUpdate();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static class Pair {
        private final String m_owner;
        private final String m_name;

        public Pair(String owner, String name) {
            this.m_owner = owner;
            this.m_name = name;
        }

        public String getOwner() {
            return this.m_owner;
        }

        public String getName() {
            return this.m_name;
        }
    }

    public static interface IPrivilegedAction {
        public Object execute(@Nonnull Connection var1) throws Exception;
    }
}

