/*
 * Decompiled with CFR 0.152.
 */
package to.etc.dbutil;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import to.etc.dbutil.BaseDB;

public class UnknownDB
extends BaseDB {
    public UnknownDB() {
        super("unknown");
    }

    @Override
    protected String getCheckString() {
        return "select 1";
    }

    @Override
    protected int getFullSequenceID(Connection dbc, String seqname) throws SQLException {
        try {
            return this.trySequenceID(dbc, seqname);
        }
        catch (Exception exception) {
            this.createSequence(dbc, seqname);
            return this.trySequenceID(dbc, seqname);
        }
    }

    @Override
    protected int getSequenceID(Connection dbc, String tablename) throws SQLException {
        return this.getFullSequenceID(dbc, tablename + "_sq");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSequence(Connection dbc, String table) {
        Statement ps = null;
        try {
            ps = dbc.createStatement();
            ps.execute("create sequence " + table + " increment 1 minvalue 1 start 1");
            dbc.commit();
        }
        catch (SQLException x) {
            x.printStackTrace();
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int trySequenceID(Connection dbc, String tablename) throws SQLException {
        ResultSet rs = null;
        Statement ps = null;
        try {
            ps = dbc.prepareStatement("select nextval('" + tablename + "')");
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("genid Query no results!?");
            }
            int n = rs.getInt(1);
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setBlob(Connection dbc, String table, String column, String[] pkfields, Object[] key, InputStream is, int len) throws SQLException {
        Statement ps = null;
        try {
            int rc;
            StringBuilder sb = new StringBuilder();
            sb.append("update ");
            sb.append(table);
            sb.append(" set ");
            sb.append(column);
            sb.append('=');
            if (is == null) {
                sb.append("null");
            } else {
                sb.append('?');
            }
            sb.append(" where ");
            ps = this.mkKeyedSQL(dbc, sb, pkfields, key, is == null ? 1 : 2, null);
            if (is != null) {
                ps.setBinaryStream(1, is, len);
            }
            if ((rc = ps.executeUpdate()) != 1) {
                throw new SQLException("Record in table " + table + " not found for BLOB update.");
            }
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setBlob(Connection dbc, String table, String column, String where, InputStream is, int len) throws SQLException {
        Statement ps = null;
        try {
            if (is == null) {
                ps = dbc.prepareStatement("update " + table + " set " + column + " = null where " + where);
            } else {
                ps = dbc.prepareStatement("update " + table + " set " + column + " = ? where " + where);
                ps.setBinaryStream(1, is, len);
            }
            int rc = ps.executeUpdate();
            if (rc != 1) {
                throw new SQLException("Record in table " + table + " with key " + where + " not found for BLOB update.");
            }
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setClob(Connection dbc, String table, String column, String where, Reader r) throws Exception {
        Statement ps = null;
        try {
            if (r == null) {
                ps = dbc.prepareStatement("update " + table + " set " + column + " = null where " + where);
            } else {
                ps = dbc.prepareStatement("update " + table + " set " + column + " = ? where " + where);
                ps.setCharacterStream(1, r, Integer.MAX_VALUE);
            }
            int rc = ps.executeUpdate();
            if (rc != 1) {
                throw new SQLException("Record in table " + table + " with key " + where + " not found for BLOB update.");
            }
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected Reader getLobReader(Connection dbc, ResultSet rs, int col) throws Exception {
        InputStream is = rs.getBinaryStream(col);
        if (is == null) {
            return null;
        }
        return new InputStreamReader(is);
    }

    @Override
    protected Reader getLobReader(Connection dbc, ResultSet rs, String col) throws Exception {
        InputStream is = rs.getBinaryStream(col);
        if (is == null) {
            return null;
        }
        return new InputStreamReader(is);
    }

    @Override
    protected InputStream getLobStream(Connection dbc, ResultSet rs, int col) throws Exception {
        return rs.getBinaryStream(col);
    }

    @Override
    protected InputStream getLobStream(Connection dbc, ResultSet rs, String col) throws Exception {
        return rs.getBinaryStream(col);
    }
}

