/*
 * Decompiled with CFR 0.152.
 */
package to.etc.formbuilder.pages;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.YesNoType;
import to.etc.domui.dom.html.Button;
import to.etc.domui.dom.html.IHtmlInput;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.util.DomUtil;
import to.etc.formbuilder.pages.ColorPropertyEditorFactory;
import to.etc.formbuilder.pages.ComboPropertyEditorFactory;
import to.etc.formbuilder.pages.DefaultPropertyEditorFactory;
import to.etc.formbuilder.pages.IFbComponent;
import to.etc.formbuilder.pages.IPropertyEditorFactory;
import to.etc.formbuilder.pages.PropertyDefinition;
import to.etc.util.ClassUtil;
import to.etc.util.FileTool;
import to.etc.util.StringTool;

public class AutoComponent
implements IFbComponent {
    private final Class<? extends NodeBase> m_componentClass;
    @Nonnull
    private final String m_shortName;
    @Nullable
    private String m_selectorImage;
    @Nonnull
    private final String m_categoryName;
    @Nonnull
    private final Set<PropertyDefinition> m_propertySet;
    @Nonnull
    private static final Class<?>[] PARAMCLZ = new Class[]{String.class, Integer.class, Boolean.class};

    public AutoComponent(Class<? extends NodeBase> componentClass) {
        this.m_componentClass = componentClass;
        String fullname = componentClass.getName();
        int ldot = fullname.lastIndexOf(46);
        String name = fullname.substring(ldot + 1);
        Constructor cons = ClassUtil.findConstructor(componentClass, (Class[])new Class[]{Class.class});
        if (null != cons) {
            name = name + "<T>";
        }
        this.m_shortName = name;
        int pdot = fullname.lastIndexOf(46, ldot - 1);
        this.m_categoryName = name = StringTool.strCapitalized((String)fullname.substring(pdot + 1, ldot));
        this.m_propertySet = this.calculatePropertySet(componentClass);
    }

    @Override
    public String getTypeID() {
        return this.getLongName();
    }

    public void setSelectorImage(@Nonnull String image) {
        this.m_selectorImage = image;
    }

    @Nonnull
    public String getSelectorImage() {
        String si = this.m_selectorImage;
        if (null == si) {
            String name = "/" + this.m_componentClass.getName().replace(".", "/") + ".png";
            si = this.hasClassResource(name) ? (this.m_selectorImage = DomUtil.getJavaResourceRURL(this.m_componentClass, (String)(this.getShortName() + ".png"))) : (this.m_selectorImage = DomUtil.getJavaResourceRURL(this.getClass(), (String)"autoComponent.png"));
        }
        return si;
    }

    private boolean hasClassResource(@Nonnull String ref) {
        InputStream is = this.m_componentClass.getResourceAsStream(ref);
        FileTool.closeAll((Object[])new Object[]{is});
        return is != null;
    }

    @Override
    public void drawSelector(@Nonnull NodeContainer container) throws Exception {
        Img img = new Img(this.getSelectorImage());
        container.add((NodeBase)img);
    }

    @Override
    @Nonnull
    public String getShortName() {
        return this.m_shortName;
    }

    @Override
    @Nonnull
    public String getLongName() {
        return this.m_componentClass.getName();
    }

    @Override
    @Nonnull
    public String getCategoryName() {
        return this.m_categoryName;
    }

    public void checkInstantiation() throws Exception {
        NodeBase instance = this.createNodeInstance();
        instance.build();
    }

    @Override
    @Nonnull
    public NodeBase createNodeInstance() throws Exception {
        Constructor cons = ClassUtil.findConstructor(this.m_componentClass, (Class[])new Class[0]);
        if (null != cons) {
            NodeBase base = (NodeBase)cons.newInstance(new Object[0]);
            return this.convertToPainter(base);
        }
        cons = ClassUtil.findConstructor(this.m_componentClass, (Class[])new Class[]{Class.class});
        if (null == cons) {
            throw new IllegalStateException(this.m_componentClass + ": no idea how to make'un.");
        }
        for (Class<?> pc : PARAMCLZ) {
            try {
                NodeBase base = (NodeBase)cons.newInstance(pc);
                return this.convertToPainter(base);
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalStateException(this.m_componentClass + ": no idea how to make'un.");
    }

    public NodeBase convertToPainter(@Nonnull NodeBase node) {
        this.forcePainterView(node);
        return node;
    }

    public void forcePainterView(@Nonnull NodeBase node) {
        if (node instanceof IHtmlInput) {
            node.addCssClass("fb-ui-paint");
        }
        if (node instanceof Button) {
            Button b = (Button)node;
            b.addCssClass("fb-ui-button");
        }
        if (node instanceof NodeContainer) {
            for (NodeBase nc : (NodeContainer)node) {
                this.forcePainterView(nc);
            }
        }
    }

    @Override
    public Set<PropertyDefinition> getProperties() {
        return this.m_propertySet;
    }

    @Nonnull
    private Set<PropertyDefinition> calculatePropertySet(@Nonnull Class<? extends NodeBase> componentClass) {
        List prl = MetaManager.findClassMeta(componentClass).getProperties();
        HashSet<PropertyDefinition> res = new HashSet<PropertyDefinition>();
        for (PropertyMetaModel pmm : prl) {
            PropertyDefinition pd = this.createDefinition(pmm);
            if (null == pd) continue;
            res.add(pd);
        }
        return res;
    }

    @Nullable
    private PropertyDefinition createDefinition(@Nonnull PropertyMetaModel<?> pmm) {
        if (pmm.getReadOnly() == YesNoType.YES) {
            return null;
        }
        if (PropertyDefinition.isIgnored(pmm.getName())) {
            return null;
        }
        IPropertyEditorFactory fact = DefaultPropertyEditorFactory.INSTANCE;
        if (pmm.getDomainValues() != null) {
            fact = ComboPropertyEditorFactory.createFactory(pmm);
        } else if (pmm.getName().toLowerCase().contains("color")) {
            fact = ColorPropertyEditorFactory.INSTANCE;
        }
        PropertyDefinition pd = PropertyDefinition.getDefinition(pmm.getActualType(), pmm.getName(), this.calculateCategory(pmm), fact);
        return pd;
    }

    @Nonnull
    private String calculateCategory(@Nonnull PropertyMetaModel<?> pmm) {
        return PropertyDefinition.getCategory(pmm.getName());
    }

    public String toString() {
        return "AutoComponent:" + this.getLongName();
    }
}

