/*
 * Decompiled with CFR 0.152.
 */
package to.etc.formbuilder.pages;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.formbuilder.pages.ComboPropertyEditor;
import to.etc.formbuilder.pages.IPropertyEditor;
import to.etc.formbuilder.pages.IPropertyEditorFactory;
import to.etc.formbuilder.pages.PropertyDefinition;

public class ComboPropertyEditorFactory
implements IPropertyEditorFactory {
    @Nonnull
    private Class<?> m_actualClass;
    @Nonnull
    private Object[] m_values;
    private boolean m_required;
    @Nonnull
    private static final Map<Class<?>, ComboPropertyEditorFactory> m_identMap = new HashMap();

    private ComboPropertyEditorFactory(@Nonnull Class<?> actualClass, @Nonnull Object[] values, boolean required) {
        this.m_actualClass = actualClass;
        this.m_values = values;
        this.m_required = required;
    }

    @Nonnull
    public static ComboPropertyEditorFactory createFactory(@Nonnull PropertyMetaModel<?> pmm) {
        Class clz = pmm.getActualType();
        ComboPropertyEditorFactory ef = m_identMap.get(clz);
        if (ef == null) {
            ef = new ComboPropertyEditorFactory(clz, pmm.getDomainValues(), pmm.isRequired() || clz.isPrimitive());
            m_identMap.put(clz, ef);
        }
        return ef;
    }

    @Override
    public IPropertyEditor createEditor(@Nonnull PropertyDefinition pd) {
        return new ComboPropertyEditor(pd, this);
    }

    @Nonnull
    public Class<?> getActualClass() {
        return this.m_actualClass;
    }

    @Nonnull
    public Object[] getValues() {
        return this.m_values;
    }

    public boolean isRequired() {
        return this.m_required;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_actualClass == null ? 0 : this.m_actualClass.hashCode());
        result = 31 * result + (this.m_required ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.m_values);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComboPropertyEditorFactory other = (ComboPropertyEditorFactory)obj;
        if (this.m_actualClass == null ? other.m_actualClass != null : !this.m_actualClass.equals(other.m_actualClass)) {
            return false;
        }
        if (this.m_required != other.m_required) {
            return false;
        }
        return Arrays.equals(this.m_values, other.m_values);
    }
}

