/*
 * Decompiled with CFR 0.152.
 */
package to.etc.formbuilder.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.domui.component.layout.CaptionedHeader;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.NodeBase;
import to.etc.formbuilder.pages.IFbComponent;
import to.etc.formbuilder.pages.PnlComponent;

public class ComponentPanel
extends Div {
    private final List<IFbComponent> m_componentList;

    public ComponentPanel(@Nonnull List<IFbComponent> componentList) {
        this.m_componentList = componentList;
    }

    public void createContent() throws Exception {
        this.setCssClass("fb-cp");
        HashMap cmap = new HashMap();
        for (IFbComponent comp : this.m_componentList) {
            String cat = comp.getCategoryName();
            if (cat.toLowerCase().contains("misc")) {
                cat = "Miscellaneous";
            } else if (cat.equals("layout")) {
                cat = "Panel Stuff";
            } else if (cat.equals("panellayout")) {
                cat = "Layout Panels";
            }
            ArrayList<IFbComponent> l = (ArrayList<IFbComponent>)cmap.get(cat);
            if (l == null) {
                l = new ArrayList<IFbComponent>();
                cmap.put(cat, l);
            }
            l.add(comp);
        }
        ArrayList miscl = new ArrayList();
        Iterator me = cmap.entrySet().iterator();
        while (me.hasNext()) {
            Map.Entry entry = me.next();
            if (((List)entry.getValue()).size() >= 2) continue;
            miscl.addAll((Collection)entry.getValue());
            me.remove();
        }
        if (miscl.size() > 0) {
            cmap.put("Miscellaneous", miscl);
        }
        ArrayList catlist = new ArrayList(cmap.keySet());
        Collections.sort(catlist);
        for (String cat : catlist) {
            if ("Html".equals(cat)) continue;
            List list = (List)cmap.get(cat);
            Collections.sort(list, new Comparator<IFbComponent>(){

                @Override
                public int compare(IFbComponent a, IFbComponent b) {
                    return a.getShortName().compareTo(b.getShortName());
                }
            });
            this.add((NodeBase)new CaptionedHeader(cat));
            for (IFbComponent comp : list) {
                PnlComponent pc = new PnlComponent(comp);
                this.add((NodeBase)pc);
            }
        }
    }
}

