/*
 * Decompiled with CFR 0.152.
 */
package to.etc.formbuilder.pages;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.buttons.SmallImgButton;
import to.etc.domui.component.graph.ColorPickerButton;
import to.etc.domui.component.input.Text;
import to.etc.domui.component.panellayout.ILayoutPanel;
import to.etc.domui.component.panellayout.LayoutPanelBase;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TextArea;
import to.etc.domui.dom.html.UrlPage;
import to.etc.formbuilder.pages.AutoComponent;
import to.etc.formbuilder.pages.AutoLayout;
import to.etc.formbuilder.pages.IFbComponent;
import to.etc.util.ClassPathScanner;

public final class FormComponentRegistry {
    private static final FormComponentRegistry m_instance = new FormComponentRegistry();
    @Nonnull
    private Set<Class<?>> m_ignoreSet = new HashSet();
    @Nonnull
    private List<IFbComponent> m_componentList = new ArrayList<IFbComponent>();
    @Nonnull
    private Map<String, IFbComponent> m_byNameMap = new HashMap<String, IFbComponent>();

    public FormComponentRegistry() {
        this.registerComponent(Text.class);
        this.registerComponent(TextArea.class);
        this.registerComponent(DefaultButton.class);
        this.registerComponent(SmallImgButton.class);
        this.registerComponent(ColorPickerButton.class);
        this.registerComponent(LayoutPanelBase.class);
    }

    @Nonnull
    public static FormComponentRegistry getInstance() {
        return m_instance;
    }

    public synchronized void register(@Nonnull IFbComponent component, @Nullable Class<?> rootClass) {
        ArrayList<IFbComponent> compl = new ArrayList<IFbComponent>(this.m_componentList);
        compl.add(component);
        this.m_componentList = Collections.unmodifiableList(compl);
        this.m_byNameMap.put(component.getTypeID(), component);
        if (null != rootClass) {
            this.m_byNameMap.put(rootClass.getName(), component);
        }
    }

    @Nonnull
    public synchronized List<IFbComponent> getComponentList() {
        return this.m_componentList;
    }

    @Nullable
    public synchronized IFbComponent findComponent(@Nonnull String name) {
        return this.m_byNameMap.get(name);
    }

    @Nullable
    public IFbComponent findComponent(@Nonnull Class<?> clz) {
        return this.m_byNameMap.get(clz.getName());
    }

    public void registerComponent(@Nonnull Class<?> componentClass) {
        if (!this.m_ignoreSet.add(componentClass)) {
            return;
        }
        if (Modifier.isAbstract(componentClass.getModifiers())) {
            return;
        }
        if (!Modifier.isPublic(componentClass.getModifiers())) {
            return;
        }
        if (IFbComponent.class.isAssignableFrom(componentClass)) {
            this.registerComponentHelper(componentClass);
            return;
        }
        String name = componentClass.getName();
        int lastindex = name.lastIndexOf(46);
        name = name.substring(0, lastindex + 1) + "Fb" + name.substring(lastindex + 2);
        Class<?> altc = null;
        try {
            altc = componentClass.getClassLoader().loadClass(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (altc != null) {
            if (IFbComponent.class.isAssignableFrom(altc)) {
                this.registerComponentHelper(altc);
                return;
            }
            throw new IllegalStateException(componentClass + "'s companion class " + altc.getName() + " does not implement " + IFbComponent.class.getName());
        }
        Constructor<?> cons = null;
        try {
            cons = componentClass.getConstructor(new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == cons) {
            try {
                cons = componentClass.getConstructor(Class.class);
            }
            catch (Exception x) {
                throw new IllegalStateException(componentClass + " has no parameterless/Class<T> constructor");
            }
        }
        if (!NodeBase.class.isAssignableFrom(componentClass)) {
            throw new IllegalStateException(componentClass + " does not extend " + NodeBase.class.getName());
        }
        AutoComponent component = this.autoRegister(componentClass);
        try {
            component.checkInstantiation();
        }
        catch (Exception x) {
            System.out.println(componentClass.getName() + ": ignored because it cannot instantiate: " + x);
            return;
        }
        this.register(component, componentClass);
    }

    private AutoComponent autoRegister(@Nonnull Class<? extends NodeBase> componentClass) {
        if (ILayoutPanel.class.isAssignableFrom(componentClass)) {
            return new AutoLayout(componentClass);
        }
        return new AutoComponent(componentClass);
    }

    private void registerComponentHelper(@Nonnull Class<? extends IFbComponent> componentClass) {
    }

    public void scanComponents() throws Exception {
        ClassPathScanner csc = new ClassPathScanner();
        csc.addListener(new ClassPathScanner.IClassEntry(){

            public void foundClass(@Nonnull File source, @Nonnull Class<?> theClass) throws Exception {
                if (NodeBase.class.isAssignableFrom(theClass) && !UrlPage.class.isAssignableFrom(theClass)) {
                    try {
                        FormComponentRegistry.this.registerComponent(theClass);
                    }
                    catch (Exception x) {
                        System.err.println(x.getMessage());
                    }
                }
            }
        });
        csc.addClassloader(this.getClass().getClassLoader());
        csc.addClassloader(NodeBase.class.getClassLoader());
        csc.scan();
    }
}

