/*
 * Decompiled with CFR 0.152.
 */
package to.etc.formbuilder.pages;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.formbuilder.pages.ComponentInstance;
import to.etc.formbuilder.pages.IFbComponent;
import to.etc.formbuilder.pages.IFbLayout;
import to.etc.formbuilder.pages.LayoutInstance;

public class PageContainer {
    private int m_idcounter;
    @Nonnull
    private final Map<String, ComponentInstance> m_instanceMap = new HashMap<String, ComponentInstance>();

    @Nonnull
    public ComponentInstance createComponent(@Nonnull IFbComponent type) {
        if (type instanceof IFbLayout) {
            return this.createLayout((IFbLayout)type);
        }
        String nextid = "C" + this.m_idcounter++;
        ComponentInstance ci = new ComponentInstance(this, nextid, type);
        this.m_instanceMap.put(nextid, ci);
        return ci;
    }

    @Nonnull
    public LayoutInstance createLayout(@Nonnull IFbLayout type) {
        String nextid = "L" + this.m_idcounter++;
        LayoutInstance ci = new LayoutInstance(this, nextid, type);
        this.m_instanceMap.put(nextid, ci);
        return ci;
    }

    @Nullable
    public ComponentInstance findComponent(@Nonnull String id) {
        return this.m_instanceMap.get(id);
    }

    @Nonnull
    public ComponentInstance getComponent(@Nonnull String id) {
        ComponentInstance ci = this.findComponent(id);
        if (null == ci) {
            throw new IllegalStateException("Form Component[" + id + "] not found");
        }
        return ci;
    }
}

