/*
 * Decompiled with CFR 0.152.
 */
package to.etc.formbuilder.pages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.misc.MsgBox;
import to.etc.domui.component.panellayout.LayoutPanelBase;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.util.IntPoint;
import to.etc.domui.util.javascript.JavascriptStmt;
import to.etc.formbuilder.pages.ComponentInstance;
import to.etc.formbuilder.pages.FormComponentRegistry;
import to.etc.formbuilder.pages.IFbComponent;
import to.etc.formbuilder.pages.IFbLayout;
import to.etc.formbuilder.pages.JsonComponentInfo;
import to.etc.formbuilder.pages.LayoutInstance;
import to.etc.formbuilder.pages.PageContainer;

public class PaintPanel
extends Div {
    @Nullable
    private LayoutInstance m_rootLayout;
    @Nonnull
    private final FormComponentRegistry m_registry;
    @Nonnull
    private final PageContainer m_pageContainer = new PageContainer();
    @Nonnull
    private Set<ComponentInstance> m_selectSet = new HashSet<ComponentInstance>();
    @Nonnull
    private List<ISelectionChanged> m_selectionChangedListeners = new ArrayList<ISelectionChanged>();

    public PaintPanel(@Nonnull FormComponentRegistry registry) {
        this.m_registry = registry;
    }

    public void addSelectionChanged(@Nonnull ISelectionChanged sel) {
        this.m_selectionChangedListeners.add(sel);
    }

    private void createRootLayout() {
        LayoutInstance li;
        if (null != this.m_rootLayout) {
            return;
        }
        IFbComponent root = this.r().findComponent(LayoutPanelBase.class);
        if (null == root) {
            throw new IllegalStateException("Cannot find default root layout container");
        }
        this.m_rootLayout = li = this.pc().createLayout((IFbLayout)root);
    }

    @Nonnull
    private FormComponentRegistry r() {
        return this.m_registry;
    }

    @Nonnull
    private PageContainer pc() {
        return this.m_pageContainer;
    }

    @Nonnull
    private LayoutInstance root() {
        if (null != this.m_rootLayout) {
            return this.m_rootLayout;
        }
        throw new IllegalStateException("Root layout not set");
    }

    public void createContent() throws Exception {
        this.createRootLayout();
        this.setCssClass("fd-pp");
        this.renderLayout();
    }

    private void renderLayout() throws Exception {
        this.renderLayout((NodeContainer)this, this.m_rootLayout);
    }

    private void renderLayout(@Nonnull NodeContainer target, LayoutInstance layout) throws Exception {
        NodeContainer layoutc = layout.getRendered();
        target.add((NodeBase)layoutc);
        for (ComponentInstance ci : layout.getComponentList()) {
            if (ci instanceof LayoutInstance) {
                this.renderLayout(layoutc, (LayoutInstance)ci);
                continue;
            }
            this.renderComponent(layoutc, ci);
        }
    }

    protected void renderJavascriptState(@Nonnull JavascriptStmt b) throws Exception {
        this.setFocus();
        this.renderJsState(b, this.m_rootLayout);
    }

    private void renderJsState(@Nonnull JavascriptStmt b, @Nonnull ComponentInstance ci) throws Exception {
        b.method("window._fb.registerInstance").arg((Object)ci.getComponentType().getTypeID()).arg((Object)ci.getId()).arg((Object)ci.getRendered().getActualID()).end().next();
        if (!(ci instanceof LayoutInstance)) {
            return;
        }
        for (ComponentInstance c : ((LayoutInstance)ci).getComponentList()) {
            this.renderJsState(b, c);
        }
    }

    private void renderComponent(@Nonnull NodeContainer layoutc, @Nonnull ComponentInstance ci) throws Exception {
        NodeBase inst = ci.getRendered();
        layoutc.add(inst);
    }

    private void updateComponent(@Nonnull ComponentInstance ci) throws Exception {
        this.renderJsState(this.appendStatement(), ci);
    }

    public void webActionDropComponent(@Nonnull JsonComponentInfo info) throws Exception {
        IFbComponent componentType = this.r().findComponent(info.getTypeId());
        if (null == componentType) {
            MsgBox.error((NodeBase)this, (String)("Internal: no type '" + info.getTypeId() + "'"));
            return;
        }
        System.out.println("Drop event: " + componentType + " @(" + info.getX() + "," + info.getY() + ")");
        ComponentInstance ci = this.pc().createComponent(componentType);
        LayoutInstance li = this.m_rootLayout;
        LayoutPanelBase lpb = (LayoutPanelBase)li.getRendered();
        li.addComponent(ci);
        lpb.add(ci.getRendered(), (Object)new IntPoint(info.getX(), info.getY()));
        this.updateComponent(ci);
    }

    public void webActionMoveComponent(@Nonnull JsonComponentInfo info) throws Exception {
        System.out.println("Move event: " + info.getId() + " @(" + info.getX() + "," + info.getY() + ")");
        ComponentInstance ci = this.pc().getComponent(info.getId());
        LayoutInstance layout = ci.getParent();
        if (null == layout) {
            throw new IllegalStateException("Moving a thingy that is not part of a layout?");
        }
        layout.positionComponent(ci, new IntPoint(info.getX(), info.getY()));
    }

    public void webActionSelection(@Nonnull Set<String> idlist) throws Exception {
        HashSet<ComponentInstance> selectSet = new HashSet<ComponentInstance>();
        for (String id : idlist) {
            ComponentInstance component = this.pc().getComponent(id);
            selectSet.add(component);
        }
        Set<ComponentInstance> oldSet = this.m_selectSet;
        this.m_selectSet = selectSet;
        for (ISelectionChanged ss : this.m_selectionChangedListeners) {
            ss.selectionChanged(selectSet, oldSet);
        }
    }

    public static interface ISelectionChanged {
        public void selectionChanged(@Nonnull Set<ComponentInstance> var1, Set<ComponentInstance> var2) throws Exception;
    }
}

