/*
 * Decompiled with CFR 0.152.
 */
package to.etc.formbuilder.pages;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.YesNoType;
import to.etc.domui.dom.css.CssBase;
import to.etc.domui.dom.html.IControl;
import to.etc.formbuilder.pages.IPropertyEditorFactory;

public class PropertyDefinition {
    @Nonnull
    private final Class<?> m_actualType;
    @Nonnull
    private final String m_name;
    @Nonnull
    private final String m_category;
    @Nonnull
    private final IPropertyEditorFactory m_editor;
    @Nonnull
    private static final Map<PropertyDefinition, PropertyDefinition> m_map = new HashMap<PropertyDefinition, PropertyDefinition>();
    private static Map<String, String> m_categoryMap = new HashMap<String, String>();
    private static final Set<String> m_ignoreSet = new HashSet<String>();

    private PropertyDefinition(@Nonnull Class<?> actualType, @Nonnull String name, @Nonnull String category, @Nonnull IPropertyEditorFactory editor) {
        this.m_actualType = actualType;
        this.m_name = name;
        this.m_category = category;
        this.m_editor = editor;
    }

    @Nonnull
    public Class<?> getActualType() {
        return this.m_actualType;
    }

    @Nonnull
    public String getName() {
        return this.m_name;
    }

    @Nonnull
    public String getCategory() {
        return this.m_category;
    }

    @Nonnull
    public IPropertyEditorFactory getEditor() {
        return this.m_editor;
    }

    @Nonnull
    public static PropertyDefinition getDefinition(@Nonnull Class<?> actualType, @Nonnull String name, @Nonnull String category, @Nonnull IPropertyEditorFactory editor) {
        PropertyDefinition pd = new PropertyDefinition(actualType, name, category, editor);
        PropertyDefinition rpd = m_map.get(pd);
        if (rpd != null) {
            return rpd;
        }
        m_map.put(pd, pd);
        return pd;
    }

    public static synchronized void registerCategory(@Nonnull String category, String ... properties) {
        for (String name : properties) {
            m_categoryMap.put(name, category);
        }
    }

    public static synchronized void registerCategories(@Nonnull String category, @Nonnull Class<?> ifclss) {
        for (PropertyMetaModel pmm : MetaManager.findClassMeta(ifclss).getProperties()) {
            if (pmm.getReadOnly() == YesNoType.YES || m_categoryMap.containsKey(pmm.getName())) continue;
            m_categoryMap.put(pmm.getName(), category);
        }
    }

    @Nonnull
    public static synchronized String getCategory(@Nonnull String propertyName) {
        String cat = m_categoryMap.get(propertyName);
        return cat == null ? "Miscellaneous" : cat;
    }

    public static synchronized void ignore(@Nonnull String property) {
        m_ignoreSet.add(property);
    }

    public static synchronized boolean isIgnored(@Nonnull String property) {
        return m_ignoreSet.contains(property);
    }

    static {
        PropertyDefinition.registerCategories("CSS", CssBase.class);
        PropertyDefinition.registerCategories("Control", IControl.class);
        PropertyDefinition.ignore("componentBundle");
    }
}

