/*
 * Decompiled with CFR 0.152.
 */
package to.etc.formbuilder.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.layout.CaptionedHeader;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.util.DomUtil;
import to.etc.formbuilder.pages.ComponentInstance;
import to.etc.formbuilder.pages.IPropertyEditor;
import to.etc.formbuilder.pages.PropertyDefinition;

public class PropertyPanel
extends Div {
    @Nonnull
    private Set<ComponentInstance> m_selected = new HashSet<ComponentInstance>();
    @Nonnull
    private Map<PropertyDefinition, IPropertyEditor> m_editorMap = new HashMap<PropertyDefinition, IPropertyEditor>();
    private static final Object VALUE_NOT_SAME = "($notsame$)";

    public void createContent() throws Exception {
        this.setCssClass("fb-prp");
        Set<PropertyDefinition> all = this.getSharedProperties();
        HashMap<String, ArrayList<PropertyDefinition>> map = new HashMap<String, ArrayList<PropertyDefinition>>();
        for (PropertyDefinition pd : all) {
            String cat = pd.getCategory();
            ArrayList<PropertyDefinition> list = (ArrayList<PropertyDefinition>)map.get(cat);
            if (null == list) {
                list = new ArrayList<PropertyDefinition>();
                map.put(cat, list);
            }
            list.add(pd);
        }
        TBody b = this.addTable(new String[0]);
        for (Map.Entry me : map.entrySet()) {
            List pdlist = (List)me.getValue();
            this.renderCategory(b, (String)me.getKey(), (List)me.getValue());
        }
    }

    private void renderCategory(@Nonnull TBody b, @Nonnull String cat, @Nonnull List<PropertyDefinition> props) throws Exception {
        Collections.sort(props, new Comparator<PropertyDefinition>(){

            @Override
            public int compare(PropertyDefinition a, PropertyDefinition b) {
                return a.getName().compareTo(b.getName());
            }
        });
        TD td = b.addRowAndCell();
        td.setColspan(2);
        td.add((NodeBase)new CaptionedHeader(cat));
        for (PropertyDefinition pd : props) {
            this.renderPropertyDef(b, pd);
        }
    }

    private void renderPropertyDef(@Nonnull TBody b, @Nonnull PropertyDefinition pd) throws Exception {
        IPropertyEditor pe = pd.getEditor().createEditor(pd);
        this.m_editorMap.put(pd, pe);
        TD namecell = b.addRowAndCell();
        namecell.add(pd.getName());
        TD editcell = b.addCell();
        Object value = this.getPropertyValue(pd);
        if (value != VALUE_NOT_SAME) {
            pe.setValue(value);
        }
        pe.renderValue((NodeContainer)editcell);
    }

    @Nullable
    private Object getPropertyValue(@Nonnull PropertyDefinition pd) throws Exception {
        Object theValue = null;
        int count = 0;
        for (ComponentInstance ci : this.m_selected) {
            try {
                Object pv = ci.getPropertyValue(pd);
                if (count++ == 0) {
                    theValue = pv;
                    continue;
                }
                if (DomUtil.isEqual((Object)theValue, (Object)pv)) continue;
                return VALUE_NOT_SAME;
            }
            catch (Exception x) {
                x.printStackTrace();
                return VALUE_NOT_SAME;
            }
        }
        return theValue;
    }

    public void selectionChanged(Set<ComponentInstance> newSelection) {
        if (newSelection.size() == 0) {
            this.m_selected.clear();
            this.m_editorMap.clear();
        } else if (newSelection.size() == 1) {
            this.m_selected = newSelection;
        }
        this.forceRebuild();
    }

    private Set<PropertyDefinition> getSharedProperties() {
        HashSet<PropertyDefinition> res = new HashSet<PropertyDefinition>();
        int count = 0;
        for (ComponentInstance pd : this.m_selected) {
            Set<PropertyDefinition> pdset = pd.getComponentType().getProperties();
            if (count++ == 0) {
                res.addAll(pdset);
                continue;
            }
            res.retainAll(pdset);
        }
        return res;
    }
}

