/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.hibernate.beforeimages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Hibernate;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.proxy.HibernateProxy;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.YesNoType;
import to.etc.domui.hibernate.beforeimages.BeforeImageListProxy;
import to.etc.domui.hibernate.beforeimages.BeforeImageSetProxy;
import to.etc.domui.hibernate.beforeimages.IBeforeImageCollectionProxy;
import to.etc.util.WrappedException;
import to.etc.webapp.query.IBeforeImageCache;

public class BeforeImageInterceptor
extends EmptyInterceptor {
    @Nonnull
    private final IBeforeImageCache m_cache;
    private static final boolean DEBUG = false;
    @Nonnull
    private final Map<CollectionKey, IBeforeImageCollectionProxy<?>> m_mirrorMap = new HashMap();

    public BeforeImageInterceptor(@Nonnull IBeforeImageCache cache) {
        this.m_cache = cache;
    }

    @Nonnull
    public IBeforeImageCache getCache() {
        return this.m_cache;
    }

    public void onAfterLoad(@Nonnull PostLoadEvent loadevent) {
        Object instance = loadevent.getEntity();
        if (null == instance) {
            throw new IllegalStateException("entity instance null in interceptor!?");
        }
        try {
            Class real = Hibernate.getClass((Object)instance);
            Object copy = this.m_cache.createImage(real, instance, true);
            this.copyProperties(copy, instance);
        }
        catch (Exception x) {
            throw WrappedException.wrap((Exception)x);
        }
    }

    private <T> void copyProperties(@Nonnull T dst, @Nonnull T src) throws Exception {
        for (PropertyMetaModel pmm : MetaManager.findClassMeta(src.getClass()).getProperties()) {
            this.copyProperty(dst, src, pmm);
        }
    }

    private <T, V> void copyProperty(@Nonnull T dst, @Nonnull T src, @Nonnull PropertyMetaModel<V> pmm) throws Exception {
        if (pmm.getReadOnly() == YesNoType.YES) {
            return;
        }
        if (pmm.isTransient()) {
            return;
        }
        Object value = pmm.getValue(src);
        switch (pmm.getRelationType()) {
            case NONE: {
                pmm.setValue(dst, value);
                break;
            }
            case DOWN: {
                if (null == value) break;
                if (!(value instanceof Collection)) {
                    throw new IllegalStateException("Before-image is supported only for OneToMany of type Collection<T>.");
                }
                value = this.convertChildCollection((Collection)value);
                pmm.setValue(dst, value);
                break;
            }
            case UP: {
                if (value != null) {
                    value = this.convertParentRelation(value);
                }
                pmm.setValue(dst, value);
            }
        }
    }

    private <V> V convertParentRelation(@Nonnull V src) throws Exception {
        Object before;
        if (Hibernate.isInitialized(src) && null != (before = this.m_cache.findBeforeImage(src))) {
            return (V)before;
        }
        Class<V> realclass = BeforeImageInterceptor.getProxyClass(src);
        Object copy = this.m_cache.createImage(realclass, src, false);
        if (this.m_cache.wasNew()) {
            ClassMetaModel cmm = MetaManager.findClassMeta(src.getClass());
            PropertyMetaModel pkmm = cmm.getPrimaryKey();
            if (null == pkmm) {
                throw new IllegalStateException("Cannot locate the private key property for class " + cmm);
            }
            this.copyProperty(copy, src, pkmm);
        }
        return (V)copy;
    }

    private <E, C extends Collection<E>> C convertChildCollection(@Nonnull C src) throws Exception {
        if (Hibernate.isInitialized(src)) {
            return BeforeImageInterceptor.createMirrorCollection(src);
        }
        Object proxy = BeforeImageInterceptor.createMirrorCollectionProxy(src);
        PersistentCollection pc = (PersistentCollection)src;
        CollectionKey kk = new CollectionKey(pc.getRole(), pc.getKey());
        this.m_mirrorMap.put(kk, (IBeforeImageCollectionProxy<?>)proxy);
        return (C)((Collection)proxy);
    }

    @Nonnull
    private static <T, V extends Collection<T>, R extends IBeforeImageCollectionProxy<V>> R createMirrorCollectionProxy(@Nonnull V source) {
        Class<?> clz = source.getClass();
        if (List.class.isAssignableFrom(clz)) {
            return (R)new BeforeImageListProxy();
        }
        if (Set.class.isAssignableFrom(clz)) {
            return (R)new BeforeImageSetProxy();
        }
        throw new IllegalStateException("Before Images Interceptor: cannot create before images for collection of type " + source.getClass());
    }

    @Nonnull
    private static <T, V extends Collection<T>> V createMirrorCollection(@Nonnull V source) {
        Class<?> clz = source.getClass();
        if (List.class.isAssignableFrom(clz)) {
            return (V)Collections.unmodifiableList(new ArrayList(source));
        }
        if (Set.class.isAssignableFrom(clz)) {
            return (V)Collections.unmodifiableSet(new HashSet(source));
        }
        throw new IllegalStateException("Before Images Interceptor: cannot create before images for collection of type " + source.getClass());
    }

    @Nonnull
    private static <T> Class<T> getProxyClass(@Nonnull T proxy) {
        if (proxy instanceof HibernateProxy) {
            return ((HibernateProxy)proxy).getHibernateLazyInitializer().getPersistentClass();
        }
        return proxy.getClass();
    }

    public void collectionLoaded(@Nonnull PersistentCollection collection) {
        CollectionKey kk = new CollectionKey(collection.getRole(), collection.getKey());
        IBeforeImageCollectionProxy<?> mirror = this.m_mirrorMap.remove(kk);
        if (null == mirror) {
            return;
        }
        this.copyCollection(mirror, (Collection)collection);
    }

    private <E, C extends Collection<E>> void copyCollection(IBeforeImageCollectionProxy<C> mirror, C collection) {
        mirror.initializeFromOriginal(collection);
    }

    @Immutable
    private static class CollectionKey {
        @Nonnull
        private final String m_role;
        @Nonnull
        private final Serializable m_key;

        public CollectionKey(@Nonnull String role, @Nonnull Serializable key) {
            this.m_role = role;
            this.m_key = key;
        }

        @Nonnull
        public String getRole() {
            return this.m_role;
        }

        @Nonnull
        public Serializable getKey() {
            return this.m_key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_key == null ? 0 : this.m_key.hashCode());
            result = 31 * result + (this.m_role == null ? 0 : this.m_role.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CollectionKey other = (CollectionKey)obj;
            if (this.m_key == null ? other.m_key != null : !this.m_key.equals(other.m_key)) {
                return false;
            }
            return !(this.m_role == null ? other.m_role != null : !this.m_role.equals(other.m_role));
        }
    }
}

