/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.hibernate.beforeimages;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import to.etc.domui.hibernate.beforeimages.IBeforeImageCollectionProxy;
import to.etc.domui.hibernate.beforeimages.QBeforeCollectionNotLoadedException;

class BeforeImageSetProxy<T>
implements Set<T>,
IBeforeImageCollectionProxy<Set<T>> {
    private Set<T> m_set;

    BeforeImageSetProxy() {
    }

    private void present() {
        if (null == this.m_set) {
            throw new QBeforeCollectionNotLoadedException("The before image for this collection is not loaded because the original was not.");
        }
    }

    @Nonnull
    private RuntimeException immutable() {
        throw new IllegalStateException("Attempt to change an immutable collection");
    }

    @Override
    public void initializeFromOriginal(@Nonnull Set<T> source) {
        this.m_set = new HashSet<T>(source);
    }

    @Override
    public int size() {
        this.present();
        return this.m_set.size();
    }

    @Override
    public boolean isEmpty() {
        this.present();
        return this.m_set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.present();
        return this.m_set.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        this.present();
        return this.m_set.iterator();
    }

    @Override
    public Object[] toArray() {
        this.present();
        return this.m_set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.present();
        return this.m_set.toArray(a);
    }

    @Override
    public boolean add(T e) {
        throw this.immutable();
    }

    @Override
    public boolean remove(Object o) {
        throw this.immutable();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.present();
        return this.m_set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw this.immutable();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw this.immutable();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw this.immutable();
    }

    @Override
    public void clear() {
        throw this.immutable();
    }

    @Override
    public boolean equals(Object o) {
        this.present();
        return this.m_set.equals(o);
    }

    @Override
    public int hashCode() {
        this.present();
        return this.m_set.hashCode();
    }
}

