/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.hibernate.config;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.Type;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.hibernate.types.MappedEnumType;
import to.etc.util.ClassUtil;
import to.etc.util.PropertyInfo;

public final class HibernateChecker {
    private Configuration m_config;
    private int m_dupTables;
    private int m_badOneToMany;
    private int m_badChildType;
    private boolean m_reportProblems;
    private int m_badJoinColumn;
    private int m_enumErrors;
    private int m_dateErrors;
    private int m_missingEntity;
    private int m_badBooleans;
    private int m_missingColumn;
    private int m_badOneToOne;
    private int m_notLazyLoadedFormula;
    private Class<?> m_currentClass;
    private PropertyInfo m_currentProperty;
    private int m_domuiMetaFatals;
    private final boolean m_observableCollections;

    public HibernateChecker(Configuration config, boolean reportProblems, boolean enableObservableCollections) {
        this.m_config = config;
        this.m_reportProblems = reportProblems;
        this.m_observableCollections = enableObservableCollections;
    }

    private void problem(Severity sev, String s) {
        if (this.m_reportProblems) {
            StringBuilder sb = new StringBuilder();
            sb.append(sev.name());
            sb.append(": ").append(s);
            if (this.m_currentClass != null) {
                sb.append(" class ").append(this.m_currentClass.getName());
                if (this.m_currentProperty != null) {
                    sb.append(" property ").append(this.m_currentProperty.getName());
                }
            }
            System.out.println("MAPPING " + sb.toString());
        }
    }

    public void enhanceMappings() throws Exception {
        this.m_config.buildMappings();
        HashMap<String, Class> exmaps = new HashMap<String, Class>();
        this.m_dupTables = 0;
        this.m_badOneToMany = 0;
        this.m_badChildType = 0;
        Iterator iter = this.m_config.getClassMappings();
        while (iter.hasNext()) {
            Method g;
            PersistentClass pc = (PersistentClass)iter.next();
            this.m_currentClass = pc.getMappedClass();
            this.m_currentProperty = null;
            String tn = pc.getTable().getName();
            Class xcl = (Class)exmaps.get(tn.toLowerCase());
            if (xcl != null) {
                ++this.m_dupTables;
                this.problem(Severity.ERROR, "DUPLICATE TABLE IN HIBERNATE MAPPING: " + tn + " in " + xcl + " and " + pc.getMappedClass());
            }
            exmaps.put(tn.toLowerCase(), pc.getMappedClass());
            Entity ent = pc.getMappedClass().getAnnotation(Entity.class);
            if (null == ent) {
                this.problem(Severity.ERROR, "Class " + pc.getClassName() + " added without @Entity annotation - is this a real table class??");
                ++this.m_missingEntity;
            }
            List pilist = ClassUtil.calculateProperties((Class)pc.getMappedClass());
            Iterator iterator = pilist.iterator();
            while (iterator.hasNext()) {
                PropertyInfo pi;
                this.m_currentProperty = pi = (PropertyInfo)iterator.next();
                g = pi.getGetter();
                if (g == null) continue;
                this.checkOneToMany(g);
                this.checkEnumMapping(g);
                this.checkDateMapping(g);
                this.checkBooleanMapping(g);
                this.checkOneToOne(g);
                this.checkFormula(g);
            }
            this.checkDomuiMetadata();
            Iterator iter2 = pc.getPropertyIterator();
            while (iter2.hasNext()) {
                Class<?> actual;
                Property property = (Property)iter2.next();
                g = property.getGetter(pc.getMappedClass());
                Method method = g.getMethod();
                Class<?> clazz = actual = null == method ? null : method.getReturnType();
                if (property.getType().getName().equals(MappedEnumType.class.getName()) || "nl.itris.viewpoint.db.hibernate.ViewPointMappedEnumType".equals(property.getType().getName())) {
                    SimpleValue v = (SimpleValue)property.getValue();
                    if (v.getTypeParameters() == null) {
                        v.setTypeParameters(new Properties());
                    }
                    v.getTypeParameters().setProperty("propertyType", actual.getName());
                }
                if (!this.m_observableCollections || actual == null || !List.class.isAssignableFrom(actual)) continue;
                Bag many = (Bag)property.getValue();
                many.setTypeName("to.etc.domui.hibernate.types.ObservableListType");
            }
        }
        if (this.m_reportProblems) {
            this.report();
        }
    }

    private void checkOneToOne(Method g) {
        OneToOne annotation = g.getAnnotation(OneToOne.class);
        if (null == annotation) {
            return;
        }
        if (annotation.optional() && annotation.fetch() == FetchType.LAZY) {
            this.problem(Severity.ERROR, "@OneOnOne that is optional with fetch=LAZY does eager fetching, causing big performance trouble");
            ++this.m_badOneToOne;
        }
    }

    private void checkFormula(Method g) {
        Formula annotation = g.getAnnotation(Formula.class);
        if (null == annotation) {
            return;
        }
        Basic lazyLoadingOnFormula = g.getAnnotation(Basic.class);
        if (null == lazyLoadingOnFormula || lazyLoadingOnFormula.fetch() != FetchType.LAZY) {
            this.problem(Severity.ERROR, "@Formula that is not lazy loaded using @Basic(fetch=FetchType.LAZY), causing big performance trouble");
            ++this.m_notLazyLoadedFormula;
        }
    }

    private void checkBooleanMapping(Method g) {
        Transient tr;
        if (Boolean.class.isAssignableFrom(g.getReturnType())) {
            tr = g.getAnnotation(Transient.class);
            if (null == tr) {
                this.problem(Severity.WARNING, "Do not use Boolean wrappers. Use boolean as God intended.");
                ++this.m_badBooleans;
            } else {
                ++this.m_badBooleans;
                this.problem(Severity.ERROR, "boolean column mapped to Boolean wrapper is invalid- map to boolean using BooleanPrimitiveYNType");
                if (!g.getName().startsWith("is")) {
                    this.problem(Severity.WARNING, "boolean property's getter must be called isXxxx(), not getXxxx()");
                }
            }
        }
        if (Boolean.TYPE.isAssignableFrom(g.getReturnType())) {
            tr = g.getAnnotation(Transient.class);
            if (tr == null) {
                Column col = g.getAnnotation(Column.class);
                if (null == col) {
                    ++this.m_missingColumn;
                    this.problem(Severity.ERROR, "Missing @Column annotation");
                } else {
                    boolean nullable = col.nullable();
                    if (nullable) {
                        Type ty = g.getAnnotation(Type.class);
                        if (ty == null) {
                            ++this.m_badBooleans;
                            this.problem(Severity.ERROR, "Missing @Type on nullable primitive boolean!");
                        } else {
                            String ttn = ty.type();
                            if (ttn.equals("yes_no")) {
                                this.problem(Severity.ERROR, "@Type(yes_no) on nullable primitive boolean!");
                                ++this.m_badBooleans;
                            }
                        }
                    }
                }
            }
            if (!g.getName().startsWith("is")) {
                this.problem(Severity.WARNING, "boolean property's getter must be called isXxxx(), not getXxxx()");
            }
        }
    }

    private void checkOneToMany(Method g) {
        ManyToOne m21;
        OneToMany o2m = g.getAnnotation(OneToMany.class);
        if (o2m != null) {
            JoinColumn jc;
            if (o2m.mappedBy().length() == 0) {
                ++this.m_badOneToMany;
                this.problem(Severity.ERROR, "Missing 'mappedBy' in @OneToMany annotation- REPLACE WITH mappedBy and parent property in child class");
            }
            if (!List.class.isAssignableFrom(g.getReturnType())) {
                this.problem(Severity.ERROR, "Only java.collections.List<T> allowed as @OneToMany type");
                ++this.m_badChildType;
            }
            if (null != (jc = g.getAnnotation(JoinColumn.class))) {
                this.problem(Severity.ERROR, "@JoinColumn found on @OneToMany - not allowed. Use mappedBy");
                ++this.m_badJoinColumn;
            }
        }
        if (null != (m21 = g.getAnnotation(ManyToOne.class))) {
            if (m21.fetch() == FetchType.EAGER) {
                this.problem(Severity.ERROR, "@ManyToOne has fetch eager");
            }
            ++this.m_badOneToMany;
        }
    }

    private void checkDateMapping(Method g) {
        if (Date.class.isAssignableFrom(g.getReturnType())) {
            Temporal tt;
            if (g.getReturnType() != Date.class) {
                ++this.m_dateErrors;
                this.problem(Severity.ERROR, "Type for a date property MUST be java.util.Date");
            }
            if (null == (tt = g.getAnnotation(Temporal.class))) {
                ++this.m_dateErrors;
                this.problem(Severity.WARNING, "Missing @Temporal annotation on Date column");
            } else if (tt.value() == TemporalType.TIME) {
                ++this.m_dateErrors;
                this.problem(Severity.WARNING, "@TemporalType of type TIME is stupid on date field.");
            }
        }
    }

    private void checkEnumMapping(Method g) {
        if (Enum.class.isAssignableFrom(g.getReturnType())) {
            if (g.getAnnotation(Transient.class) != null) {
                return;
            }
            Type ht = g.getAnnotation(Type.class);
            if (null == ht) {
                Enumerated e = g.getAnnotation(Enumerated.class);
                if (null == e) {
                    this.problem(Severity.ERROR, "Missing @Enumerated annotation on enum property - this will cause ORDINAL mapping of an enum which is undesirable");
                    ++this.m_enumErrors;
                } else if (e.value() != EnumType.STRING) {
                    this.problem(Severity.ERROR, "@Enumerated(ORDINAL) annotation on enum property - this will cause ORDINAL mapping of an enum which is undesirable");
                    ++this.m_enumErrors;
                }
            }
        }
    }

    public void checkDomuiMetadata() {
        try {
            this.m_currentProperty = null;
            ClassMetaModel classMetaModel = MetaManager.findClassMeta(this.m_currentClass);
        }
        catch (Exception x) {
            this.problem(Severity.MUSTFIXNOW, "DomUI Metamodel error: " + x.toString());
            x.printStackTrace();
            ++this.m_domuiMetaFatals;
        }
    }

    public void report() {
        if (this.getBadOneToMany() > 0) {
            System.out.println("MAPPING: " + this.getBadOneToMany() + " bad @OneToMany mappings with missing mappedBy");
        }
        if (this.getBadChildType() > 0) {
            System.out.println("MAPPING: " + this.getBadChildType() + " bad @OneToMany mappings with non-List<T> type");
        }
        if (this.getBadJoinColumn() > 0) {
            System.out.println("MAPPING: " + this.getBadJoinColumn() + " bad @OneToMany mappings with @JoinColumn");
        }
        if (this.getDupTables() > 0) {
            System.out.println("MAPPING: " + this.getDupTables() + " duplicate tables");
        }
        if (this.getEnumErrors() > 0) {
            System.out.println("MAPPING: " + this.getEnumErrors() + " enum's mapped as ORDINAL or missing @Enumerated annotation");
        }
        if (this.getDateErrors() > 0) {
            System.out.println("MAPPING: " + this.getDateErrors() + " date field without proper @Temporal annotation or of the wrong date type");
        }
        if (this.getMissingEntity() > 0) {
            System.out.println("MAPPING: " + this.getMissingEntity() + " classes missing an @Entity annotation");
        }
        if (this.getBadBooleans() > 0) {
            System.out.println("MAPPING: " + this.getBadBooleans() + " bad Boolean/boolean mappings");
        }
        if (this.getMissingColumn() > 0) {
            System.out.println("MAPPING: " + this.getMissingColumn() + " properties with a missing @Column annotation");
        }
        if (this.getDomuiMetaFatals() > 0) {
            System.out.println("MAPPING: " + this.getDomuiMetaFatals() + " fatal DomUI metamodel errors - must be fixed now.");
        }
        if (this.getBadOneToOne() > 0) {
            System.out.println("MAPPING: " + this.getBadOneToOne() + " bad @OneToOne mapping errors - must be fixed now");
        }
        if (this.getNotLazyLoadedFormula() > 0) {
            System.out.println("MAPPING: " + this.getNotLazyLoadedFormula() + " bad @Formula lazy loading, missing @Basic(fetch=FetchType.LAZY) - must be fixed now");
        }
    }

    public int getDomuiMetaFatals() {
        return this.m_domuiMetaFatals;
    }

    public int getMissingColumn() {
        return this.m_missingColumn;
    }

    public int getBadBooleans() {
        return this.m_badBooleans;
    }

    public int getMissingEntity() {
        return this.m_missingEntity;
    }

    public int getDateErrors() {
        return this.m_dateErrors;
    }

    public int getEnumErrors() {
        return this.m_enumErrors;
    }

    public int getBadOneToMany() {
        return this.m_badOneToMany;
    }

    public int getBadChildType() {
        return this.m_badChildType;
    }

    public int getDupTables() {
        return this.m_dupTables;
    }

    public int getBadJoinColumn() {
        return this.m_badJoinColumn;
    }

    public int getBadOneToOne() {
        return this.m_badOneToOne;
    }

    public int getNotLazyLoadedFormula() {
        return this.m_notLazyLoadedFormula;
    }

    private static enum Severity {
        INFO,
        WARNING,
        ERROR,
        MUSTFIXNOW;

    }
}

