/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.hibernate.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.event.PostLoadEventListener;
import to.etc.dbpool.ConnectionPool;
import to.etc.dbpool.PoolManager;
import to.etc.domui.hibernate.beforeimages.BeforeImageInterceptor;
import to.etc.domui.hibernate.beforeimages.CopyCollectionEventListener;
import to.etc.domui.hibernate.beforeimages.CreateBeforeImagePostLoadListener;
import to.etc.domui.hibernate.config.HibernateChecker;
import to.etc.domui.hibernate.config.SillyHibernateConnectionProvider;
import to.etc.domui.hibernate.generic.BuggyHibernateBaseContext;
import to.etc.domui.hibernate.generic.HibernateLongSessionContextFactory;
import to.etc.domui.hibernate.generic.HibernateQueryExecutor;
import to.etc.domui.hibernate.generic.HibernateSessionMaker;
import to.etc.util.DeveloperOptions;
import to.etc.util.StringTool;
import to.etc.webapp.qsql.JdbcQueryExecutor;
import to.etc.webapp.query.IBeforeImageCache;
import to.etc.webapp.query.IQueryExecutorFactory;
import to.etc.webapp.query.IQueryListener;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QDataContextFactory;
import to.etc.webapp.query.QEventListenerSet;
import to.etc.webapp.query.QQueryExecutorRegistry;

public final class HibernateConfigurator {
    private static DataSource m_dataSource;
    static SessionFactory m_sessionFactory;
    private static QDataContextFactory m_contextSource;
    private static List<Class<?>> m_annotatedClassList;
    private static Boolean m_showSQL;
    private static QEventListenerSet m_listeners;
    private static QQueryExecutorRegistry m_handlers;
    private static Mode m_mode;
    private static boolean m_observableEnabled;
    private static boolean m_beforeImagesEnabled;

    @Nonnull
    public static synchronized DataSource getDataSource() {
        if (null == m_dataSource) {
            throw new IllegalStateException("The initialize() method has not yet been called with a valid datasource");
        }
        return m_dataSource;
    }

    public static synchronized SessionFactory getSessionFactory() {
        HibernateConfigurator.unconfigured();
        return m_sessionFactory;
    }

    public static Session internalGetSession(QDataContext dc) throws Exception {
        return ((BuggyHibernateBaseContext)dc).getSession();
    }

    public static synchronized QDataContextFactory getDataContextFactory() {
        HibernateConfigurator.unconfigured();
        return m_contextSource;
    }

    private static synchronized void configured() {
        if (null != m_sessionFactory) {
            throw new IllegalStateException("This method must be called BEFORE one of the 'initialize' methods gets called.");
        }
    }

    private static synchronized void unconfigured() {
        if (null == m_sessionFactory) {
            throw new IllegalStateException("This method must be called AFTER one of the 'initialize' methods gets called.");
        }
    }

    public static void addClasses(Class<?> ... classes) {
        HibernateConfigurator.configured();
        for (Class<?> clz : classes) {
            m_annotatedClassList.add(clz);
        }
    }

    public static void showSQL(boolean on) {
        HibernateConfigurator.configured();
        m_showSQL = on;
    }

    public static void schemaUpdate(@Nonnull Mode m) {
        HibernateConfigurator.configured();
        m_mode = m;
    }

    public static void registerQueryListener(IQueryListener ql) {
        HibernateConfigurator.configured();
        m_listeners.addQueryListener(ql);
    }

    public static void registerQueryExecutor(IQueryExecutorFactory qexecutor) {
        HibernateConfigurator.configured();
        m_handlers.register(qexecutor);
    }

    public static void enableBeforeImages(boolean yes) {
        HibernateConfigurator.configured();
        m_beforeImagesEnabled = yes;
    }

    public static void enableObservableCollections(boolean yes) {
        HibernateConfigurator.configured();
        m_observableEnabled = yes;
    }

    private static void enhanceMappings(@Nonnull Configuration config) throws Exception {
        HibernateChecker hc = new HibernateChecker(config, DeveloperOptions.isDeveloperWorkstation(), m_observableEnabled);
        hc.enhanceMappings();
    }

    public static synchronized void initialize(DataSource ds) throws Exception {
        if (m_sessionFactory != null) {
            throw new IllegalStateException("HibernateConfigurator has already been initialized!");
        }
        if (m_annotatedClassList.size() == 0) {
            throw new IllegalStateException("Please call addClasses(Class<?>...) and register your Hibernate data classes before calling me.");
        }
        long ts = System.nanoTime();
        m_dataSource = ds;
        AnnotationConfiguration config = new AnnotationConfiguration();
        for (Class<?> clz : m_annotatedClassList) {
            config.addAnnotatedClass(clz);
        }
        m_annotatedClassList = null;
        String resname = "/" + HibernateConfigurator.class.getPackage().getName().replace('.', '/') + "/hibernate.cfg.xml";
        config.configure(resname);
        HibernateConfigurator.enhanceMappings((Configuration)config);
        config.getProperties().remove("hibernate.connection.datasource");
        config.setProperty("hibernate.connection.provider_class", SillyHibernateConnectionProvider.class.getName());
        boolean logsql = m_showSQL == null ? DeveloperOptions.getBool((String)"hibernate.sql", (boolean)false) : m_showSQL;
        if (logsql) {
            config.setProperty("show_sql", "true");
            config.setProperty("hibernate.show_sql", "true");
        }
        if (DeveloperOptions.getBool((String)"hibernate.format_sql", (boolean)true)) {
            config.setProperty("hibernate.format_sql", "true");
        }
        switch (m_mode) {
            default: {
                throw new IllegalStateException("Mode: " + (Object)((Object)m_mode));
            }
            case CREATE: {
                config.setProperty("hbm2ddl.auto", "create");
                config.setProperty("hibernate.hbm2ddl.auto", "create");
                break;
            }
            case NONE: {
                config.setProperty("hbm2ddl.auto", "none");
                config.setProperty("hibernate.hbm2ddl.auto", "none");
                break;
            }
            case UPDATE: {
                config.setProperty("hbm2ddl.auto", "update");
                config.setProperty("hibernate.hbm2ddl.auto", "update");
            }
        }
        if (m_beforeImagesEnabled) {
            config.getEventListeners().setPostLoadEventListeners(new PostLoadEventListener[]{new CreateBeforeImagePostLoadListener()});
            InitializeCollectionEventListener[] iel = config.getEventListeners().getInitializeCollectionEventListeners();
            InitializeCollectionEventListener[] iel2 = new InitializeCollectionEventListener[iel.length + 1];
            System.arraycopy(iel, 0, iel2, 0, iel.length);
            iel2[iel.length] = new CopyCollectionEventListener();
            config.getEventListeners().setInitializeCollectionEventListeners(iel2);
        }
        m_sessionFactory = config.buildSessionFactory();
        HibernateSessionMaker hsm = m_beforeImagesEnabled ? new HibernateSessionMaker(){

            @Override
            public Session makeSession(@Nonnull BuggyHibernateBaseContext dc) throws Exception {
                return m_sessionFactory.openSession((Interceptor)new BeforeImageInterceptor((IBeforeImageCache)dc.getBeforeCache()));
            }
        } : new HibernateSessionMaker(){

            @Override
            public Session makeSession(@Nonnull BuggyHibernateBaseContext dc) throws Exception {
                return m_sessionFactory.openSession();
            }
        };
        if (m_handlers.size() == 0) {
            m_handlers.register((IQueryExecutorFactory)JdbcQueryExecutor.FACTORY);
            m_handlers.register(HibernateQueryExecutor.FACTORY);
        }
        m_contextSource = new HibernateLongSessionContextFactory(m_listeners, hsm, m_handlers);
        System.out.println("domui: Hibernate initialization took a whopping " + StringTool.strNanoTime((long)(System.nanoTime() - ts)));
    }

    public static void initialize(String poolname) throws Exception {
        ConnectionPool p = PoolManager.getInstance().definePool(poolname);
        HibernateConfigurator.initialize(p.getPooledDataSource());
    }

    public static void initialize(File poolfile, String poolname) throws Exception {
        ConnectionPool p = PoolManager.getInstance().definePool(poolfile, poolname);
        HibernateConfigurator.initialize(p.getPooledDataSource());
    }

    static {
        m_annotatedClassList = new ArrayList();
        m_listeners = new QEventListenerSet();
        m_handlers = new QQueryExecutorRegistry();
        m_mode = Mode.NONE;
    }

    public static enum Mode {
        NONE,
        UPDATE,
        CREATE;

    }
}

