/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.hibernate.generic;

import to.etc.domui.hibernate.generic.HibernateQueryExecutor;
import to.etc.domui.hibernate.generic.HibernateSessionMaker;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QDataContextFactory;
import to.etc.webapp.query.QEventListenerSet;
import to.etc.webapp.query.QQueryExecutorRegistry;

public abstract class AbstractHibernateContextFactory
implements QDataContextFactory {
    private HibernateSessionMaker m_sessionMaker;
    private QEventListenerSet m_eventSet;
    private QQueryExecutorRegistry m_handlers;
    private static QQueryExecutorRegistry m_default = new QQueryExecutorRegistry();

    public AbstractHibernateContextFactory(QEventListenerSet eventSet, HibernateSessionMaker sessionMaker, QQueryExecutorRegistry handlers) {
        this.m_eventSet = eventSet;
        this.m_sessionMaker = sessionMaker;
        this.m_handlers = handlers;
    }

    public AbstractHibernateContextFactory(QEventListenerSet eventSet, HibernateSessionMaker sessionMaker) {
        this.m_eventSet = eventSet;
        this.m_sessionMaker = sessionMaker;
        this.m_handlers = m_default;
    }

    public AbstractHibernateContextFactory(HibernateSessionMaker sessionMaker) {
        this.m_eventSet = new QEventListenerSet();
        this.m_sessionMaker = sessionMaker;
        this.m_handlers = m_default;
    }

    protected HibernateSessionMaker getSessionMaker() {
        return this.m_sessionMaker;
    }

    public abstract QDataContext getDataContext() throws Exception;

    public QEventListenerSet getEventListeners() {
        return this.m_eventSet;
    }

    public QQueryExecutorRegistry getQueryHandlerList() {
        return this.m_handlers;
    }

    static {
        m_default.register(HibernateQueryExecutor.FACTORY);
    }
}

