/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.hibernate.generic;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.hibernate.generic.HibernateSessionMaker;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.IConversationStateListener;
import to.etc.util.DeveloperOptions;
import to.etc.util.StringTool;
import to.etc.webapp.core.IRunnable;
import to.etc.webapp.query.DefaultBeforeImageCache;
import to.etc.webapp.query.QAbstractDataContext;
import to.etc.webapp.query.QDataContext;
import to.etc.webapp.query.QDataContextFactory;

public class BuggyHibernateBaseContext
extends QAbstractDataContext
implements QDataContext,
IConversationStateListener {
    protected static final Logger LOG = LoggerFactory.getLogger(BuggyHibernateBaseContext.class);
    private String m_conversationInvalid;
    protected HibernateSessionMaker m_sessionMaker;
    private boolean m_ignoreClose;
    protected Session m_session;
    @Nonnull
    private List<IRunnable> m_commitHandlerList = Collections.EMPTY_LIST;
    @Nullable
    private DefaultBeforeImageCache m_beforeCache;
    private boolean m_dataLoaded;
    private boolean m_keepOriginals;
    private static final boolean m_logCloses = System.getProperty("domui.trace.close") != null;
    private static final String[] PRESET = new String[]{"to.etc.dbpool.", "oracle.", "nl.itris.viewpoint.db.hibernate."};
    private static final String[] ENDSET = new String[]{"to.etc.dbpool.", "to.etc.domui.server.", "org.apache.tomcat"};

    BuggyHibernateBaseContext(HibernateSessionMaker sessionMaker, QDataContextFactory src) {
        super(src);
        this.m_sessionMaker = sessionMaker;
    }

    protected void setSessionMaker(HibernateSessionMaker sm) {
        this.m_sessionMaker = sm;
    }

    public Session getSession() throws Exception {
        this.checkValid();
        if (this.m_session == null) {
            this.m_session = this.m_sessionMaker.makeSession(this);
            this.m_session.beginTransaction();
        }
        return this.m_session;
    }

    protected final void checkValid() {
        if (this.m_conversationInvalid != null) {
            throw new IllegalStateException("You cannot use this QDataContext: " + this.m_conversationInvalid);
        }
    }

    protected void setConversationInvalid(String conversationInvalid) {
        this.m_conversationInvalid = conversationInvalid;
    }

    public void setIgnoreClose(boolean on) {
        this.m_ignoreClose = on;
    }

    public boolean isIgnoreClose() {
        return this.m_ignoreClose;
    }

    public void close() {
        boolean logCloses;
        if (this.m_session == null || this.m_ignoreClose) {
            return;
        }
        boolean bl = logCloses = m_logCloses || DeveloperOptions.isDeveloperWorkstation();
        if (!logCloses) {
            this.setConversationInvalid("DataContext has been CLOSED");
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("DataContext has been CLOSED");
            Exception mxx = null;
            try {
                throw new Exception();
            }
            catch (Exception x) {
                mxx = x;
                if (mxx != null) {
                    sb.append("\nClose location:\n");
                    StringTool.strStacktraceFiltered((Appendable)sb, (Throwable)mxx, (String[])PRESET, (String[])ENDSET, (int)40);
                }
                this.setConversationInvalid(sb.toString());
            }
        }
        try {
            if (this.m_session.getTransaction().isActive()) {
                this.m_session.getTransaction().rollback();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        try {
            this.m_session.close();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        this.m_session = null;
    }

    public void startTransaction() throws Exception {
        if (!this.inTransaction()) {
            this.getSession().beginTransaction();
        }
    }

    public void commit() throws Exception {
        if (!this.inTransaction()) {
            throw new IllegalStateException("Commit called without startTransaction.");
        }
        this.getSession().getTransaction().commit();
        this.runCommitHandlers();
        this.startTransaction();
    }

    protected void runCommitHandlers() throws Exception {
        Exception firstx = null;
        for (IRunnable r : this.m_commitHandlerList) {
            try {
                r.run();
            }
            catch (Exception x) {
                if (null == firstx) {
                    firstx = x;
                    continue;
                }
                x.printStackTrace();
            }
        }
        this.m_commitHandlerList.clear();
        if (null != firstx) {
            throw firstx;
        }
    }

    public boolean inTransaction() throws Exception {
        return this.getSession().getTransaction().isActive();
    }

    public void rollback() throws Exception {
        if (this.getSession().getTransaction().isActive()) {
            this.getSession().getTransaction().rollback();
        }
    }

    public <T> T original(T copy) {
        DefaultBeforeImageCache bc = this.m_beforeCache;
        if (null == bc) {
            throw new IllegalStateException("Before caching is not enabled on this data context, call setKeepOriginals() before using it.");
        }
        return (T)bc.findBeforeImage(copy);
    }

    public void setKeepOriginals() {
        if (this.m_keepOriginals) {
            return;
        }
        if (this.m_dataLoaded) {
            throw new IllegalStateException("This data context has already been used to load data, you can only set the before images flag on an unused context");
        }
        this.m_keepOriginals = true;
    }

    public boolean isKeepOriginals() {
        return this.m_keepOriginals;
    }

    @Nonnull
    public DefaultBeforeImageCache getBeforeCache() {
        DefaultBeforeImageCache beforeCache = this.m_beforeCache;
        if (null == beforeCache) {
            beforeCache = this.m_beforeCache = new DefaultBeforeImageCache();
        }
        return beforeCache;
    }

    public Connection getConnection() throws Exception {
        this.startTransaction();
        return this.getSession().connection();
    }

    public void addCommitAction(IRunnable cx) {
        if (this.m_commitHandlerList == Collections.EMPTY_LIST) {
            this.m_commitHandlerList = new ArrayList<IRunnable>();
        }
        this.m_commitHandlerList.add(cx);
    }

    public <T> T find(Class<T> clz, Object pk) throws Exception {
        this.m_dataLoaded = true;
        return (T)super.find(clz, pk);
    }

    public <T> T getInstance(Class<T> clz, Object pk) throws Exception {
        this.m_dataLoaded = true;
        return (T)super.getInstance(clz, pk);
    }

    public void conversationAttached(ConversationContext cc) throws Exception {
        this.setConversationInvalid(null);
    }

    public void conversationDestroyed(ConversationContext cc) throws Exception {
        this.setIgnoreClose(false);
        this.close();
        this.setConversationInvalid("Conversation was destroyed");
    }

    public void conversationDetached(ConversationContext cc) throws Exception {
        this.setIgnoreClose(false);
        this.close();
        this.setConversationInvalid("Conversation is detached");
    }

    public void conversationNew(ConversationContext cc) throws Exception {
    }
}

