/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.hibernate.generic;

import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.engine.StatefulPersistenceContext;
import org.hibernate.impl.SessionImpl;
import to.etc.domui.hibernate.generic.BuggyHibernateBaseContext;
import to.etc.domui.hibernate.generic.HibernateSessionMaker;
import to.etc.domui.state.ConversationContext;
import to.etc.webapp.query.QDataContextFactory;

public class HibernateLongSessionContext
extends BuggyHibernateBaseContext {
    public HibernateLongSessionContext(QDataContextFactory src, HibernateSessionMaker sessionMaker) {
        super(sessionMaker, src);
    }

    @Override
    public Session getSession() throws Exception {
        this.checkValid();
        if (this.m_session == null) {
            super.getSession();
            this.m_session.setFlushMode(FlushMode.MANUAL);
        }
        if (!this.m_session.isConnected()) {
            LOG.debug("Hibernate: reconnecting session.");
        }
        return this.m_session;
    }

    @Override
    public void conversationDestroyed(ConversationContext cc) throws Exception {
        if (this.m_session == null || !this.m_session.isConnected()) {
            return;
        }
        try {
            this.setConversationInvalid("Conversation was destroyed");
            this.setIgnoreClose(false);
            SessionImpl sim = (SessionImpl)this.m_session;
            StatefulPersistenceContext spc = (StatefulPersistenceContext)sim.getPersistenceContext();
            Map flups = spc.getEntitiesByKey();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Hibernate: closing (destroying) session " + System.identityHashCode(this.m_session) + " containing " + flups.size() + " persisted instances");
            }
            if (this.m_session.getTransaction().isActive()) {
                this.m_session.getTransaction().rollback();
            }
            this.close();
        }
        catch (Exception x) {
            LOG.info("Exception during conversation destroy: " + x, (Throwable)x);
        }
    }

    @Override
    public void conversationDetached(ConversationContext cc) throws Exception {
        if (this.m_session == null || !this.m_session.isConnected()) {
            return;
        }
        this.setConversationInvalid("Conversation is detached");
        SessionImpl sim = (SessionImpl)this.m_session;
        StatefulPersistenceContext spc = (StatefulPersistenceContext)sim.getPersistenceContext();
        Map flups = spc.getEntitiesByKey();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Hibernate: disconnecting session " + System.identityHashCode(this.m_session) + " containing " + flups.size() + " persisted instances");
        }
        if (this.m_session.getTransaction().isActive()) {
            this.m_session.getTransaction().rollback();
        }
        this.m_session.disconnect();
    }

    @Override
    public void conversationAttached(ConversationContext cc) throws Exception {
        this.setConversationInvalid(null);
    }

    @Override
    public void conversationNew(ConversationContext cc) throws Exception {
        this.setConversationInvalid(null);
    }

    @Override
    public void commit() throws Exception {
        this.startTransaction();
        this.m_session.flush();
        super.commit();
        this.startTransaction();
    }

    public void attach(Object o) throws Exception {
    }
}

