/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.hibernate.generic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.engine.StatefulPersistenceContext;
import org.hibernate.impl.SessionImpl;
import to.etc.domui.hibernate.generic.BuggyHibernateBaseContext;
import to.etc.domui.hibernate.generic.HibernateSessionMaker;
import to.etc.domui.state.ConversationContext;
import to.etc.util.StringTool;
import to.etc.webapp.query.QDataContextFactory;

public class HibernateReattachingDataContext
extends BuggyHibernateBaseContext {
    private final List<Object> m_hibernatePersistedObjects = new ArrayList<Object>();

    public HibernateReattachingDataContext(QDataContextFactory src, HibernateSessionMaker sessionMaker) {
        super(sessionMaker, src);
    }

    @Override
    public Session getSession() throws Exception {
        if (this.m_session == null) {
            this.m_session = this.m_sessionMaker.makeSession(this);
            long ts = System.nanoTime();
            for (Object el : this.m_hibernatePersistedObjects) {
                this.m_session.update(el);
            }
            ts = System.nanoTime() - ts;
            if (LOG.isDebugEnabled()) {
                LOG.debug("hib: re-attached " + this.m_hibernatePersistedObjects.size() + " objects in " + StringTool.strNanoTime((long)ts));
            }
            this.m_hibernatePersistedObjects.clear();
        }
        return this.m_session;
    }

    @Override
    public void conversationDestroyed(ConversationContext cc) throws Exception {
        this.setIgnoreClose(false);
        this.conversationDetached(cc);
    }

    @Override
    public void conversationDetached(ConversationContext cc) throws Exception {
        if (this.m_session == null) {
            return;
        }
        long ts = System.nanoTime();
        SessionImpl sim = (SessionImpl)this.m_session;
        StatefulPersistenceContext spc = (StatefulPersistenceContext)sim.getPersistenceContext();
        Map flups = spc.getEntitiesByKey();
        this.m_hibernatePersistedObjects.clear();
        for (Object ent : flups.values()) {
            this.m_hibernatePersistedObjects.add(ent);
        }
        ts = System.nanoTime() - ts;
        if (LOG.isDebugEnabled()) {
            LOG.debug("hib: saved " + flups.size() + " persisted objects in the conversation for reattachment in " + StringTool.strNanoTime((long)ts));
        }
        this.close();
    }
}

