/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.hibernate.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.TypeHelper;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.criterion.Subqueries;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.collection.OneToManyPersister;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.PropertyRelationType;
import to.etc.domui.hibernate.model.HibernateAliasedSqlCriterion;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.qsql.QQuerySyntaxException;
import to.etc.webapp.query.QBetweenNode;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QCriteriaQueryBase;
import to.etc.webapp.query.QExistsSubquery;
import to.etc.webapp.query.QFetchStrategy;
import to.etc.webapp.query.QLiteral;
import to.etc.webapp.query.QMultiNode;
import to.etc.webapp.query.QMultiSelection;
import to.etc.webapp.query.QNodeVisitor;
import to.etc.webapp.query.QOperation;
import to.etc.webapp.query.QOperatorNode;
import to.etc.webapp.query.QOrder;
import to.etc.webapp.query.QPropertyComparison;
import to.etc.webapp.query.QPropertyIn;
import to.etc.webapp.query.QPropertyJoinComparison;
import to.etc.webapp.query.QPropertySelection;
import to.etc.webapp.query.QSelection;
import to.etc.webapp.query.QSelectionColumn;
import to.etc.webapp.query.QSelectionItem;
import to.etc.webapp.query.QSelectionSubquery;
import to.etc.webapp.query.QSortOrderDirection;
import to.etc.webapp.query.QSqlRestriction;
import to.etc.webapp.query.QSubQuery;
import to.etc.webapp.query.QUnaryNode;
import to.etc.webapp.query.QUnaryProperty;

public class CriteriaCreatingVisitor
implements QNodeVisitor {
    private final Session m_session;
    private final Criteria m_rootCriteria;
    private Object m_currentCriteria;
    private Criterion m_last;
    private Object m_lastSubqueryCriteria;
    private int m_aliasIndex;
    private Class<?> m_rootClass;
    private Map<String, String> m_aliasMap = new HashMap<String, String>();
    private PropertyMetaModel<?>[] m_pendingJoinProps = new PropertyMetaModel[20];
    private String[] m_pendingJoinPaths = new String[20];
    private int m_pendingJoinIx;
    private String m_inputPath;
    private StringBuilder m_sb = new StringBuilder();
    private PropertyMetaModel<?> m_targetProperty;
    private ProjectionList m_proli;
    private Projection m_lastProj;
    private String m_parentAlias;

    public CriteriaCreatingVisitor(Session ses, Criteria crit) {
        this.m_session = ses;
        this.m_rootCriteria = crit;
        this.m_currentCriteria = crit;
    }

    public void checkHibernateClass(Class<?> clz) {
        ClassMetadata childmd = this.m_session.getSessionFactory().getClassMetadata(clz);
        if (childmd == null) {
            throw new IllegalArgumentException("The class " + clz + " is not known by Hibernate as a persistent class");
        }
    }

    private String nextAlias() {
        return "a_" + ++this.m_aliasIndex;
    }

    private void addCriterion(Criterion c) {
        if (this.m_currentCriteria instanceof Criteria) {
            ((Criteria)this.m_currentCriteria).add(c);
        } else if (this.m_currentCriteria instanceof DetachedCriteria) {
            ((DetachedCriteria)this.m_currentCriteria).add(c);
        } else {
            throw new IllegalStateException("Unexpected current thing: " + this.m_currentCriteria);
        }
    }

    private void addOrder(Order c) {
        if (this.m_currentCriteria instanceof Criteria) {
            ((Criteria)this.m_currentCriteria).addOrder(c);
        } else if (this.m_currentCriteria instanceof DetachedCriteria) {
            ((DetachedCriteria)this.m_currentCriteria).addOrder(c);
        } else {
            throw new IllegalStateException("Unexpected current thing: " + this.m_currentCriteria);
        }
    }

    public void visitRestrictionsBase(QCriteriaQueryBase<?> n) throws Exception {
        QOperatorNode r = n.getRestrictions();
        if (r == null) {
            return;
        }
        QOperatorNode.prune((QOperatorNode)r);
        if (r.getOperation() == QOperation.AND) {
            QMultiNode mn = (QMultiNode)r;
            for (QOperatorNode qtn : mn.getChildren()) {
                qtn.visit((QNodeVisitor)this);
                if (this.m_last == null) continue;
                this.addCriterion(this.m_last);
                this.m_last = null;
            }
        } else {
            r.visit((QNodeVisitor)this);
            if (null != this.m_last) {
                this.addCriterion(this.m_last);
            }
            this.m_last = null;
        }
        this.checkSubqueriesUsed(n);
    }

    private void checkSubqueriesUsed(QCriteriaQueryBase<?> n) {
        if (n.getUnusedSubquerySet().size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("There are ").append(n.getUnusedSubquerySet().size()).append(" subqueries that are not linked (used) in the main query!\n");
            int i = 1;
            for (QSubQuery subQuery : n.getUnusedSubquerySet()) {
                sb.append(i).append(": ").append(subQuery.toString()).append("\n");
                ++i;
            }
            throw new QQuerySyntaxException(sb.toString());
        }
    }

    public void visitCriteria(QCriteria<?> qc) throws Exception {
        this.checkHibernateClass(qc.getBaseClass());
        this.m_rootClass = qc.getBaseClass();
        this.visitRestrictionsBase((QCriteriaQueryBase<?>)qc);
        this.visitOrderList(qc.getOrder());
        if (qc.getLimit() > 0) {
            this.m_rootCriteria.setMaxResults(qc.getLimit());
        }
        if (qc.getStart() > 0) {
            this.m_rootCriteria.setFirstResult(qc.getStart());
        }
        if (qc.getTimeout() > 0) {
            this.m_rootCriteria.setTimeout(qc.getTimeout());
        }
        this.handleFetch((QCriteriaQueryBase<?>)qc);
    }

    private void handleFetch(QCriteriaQueryBase<?> qc) {
        for (Map.Entry ms : qc.getFetchStrategies().entrySet()) {
            PropertyMetaModel pmm = MetaManager.findPropertyMeta(this.m_rootClass, (String)((String)ms.getKey()));
            if (null == pmm) {
                throw new QQuerySyntaxException("The 'fetch' path '" + (String)ms.getKey() + " does not resolve on class " + this.m_rootClass);
            }
            if (ms.getValue() == QFetchStrategy.LAZY) continue;
            switch (pmm.getRelationType()) {
                case DOWN: {
                    this.m_rootCriteria.setFetchMode((String)ms.getKey(), FetchMode.SELECT);
                    break;
                }
                case UP: {
                    this.m_rootCriteria.setFetchMode((String)ms.getKey(), FetchMode.JOIN);
                    break;
                }
                case NONE: {
                    throw new QQuerySyntaxException("The 'fetch' path '" + (String)ms.getKey() + " is not recognized as a relation property");
                }
            }
        }
    }

    private String parseSubcriteria(String input) {
        return this.parseSubcriteria(input, false);
    }

    private String parseSubcriteria(String input, boolean allowDown) {
        this.m_targetProperty = null;
        this.m_inputPath = input;
        Class currentClass = this.m_rootClass;
        String path = null;
        String subpath = null;
        int ix = 0;
        int len = input.length();
        this.m_pendingJoinIx = 0;
        boolean last = false;
        boolean previspk = false;
        String currentAlias = "";
        while (!last) {
            PropertyMetaModel pmm;
            String name;
            int pos = input.indexOf(46, ix);
            if (pos == -1) {
                if (ix == 0) {
                    this.m_targetProperty = MetaManager.findPropertyMeta(currentClass, (String)input);
                    return input;
                }
                name = input.substring(ix);
                ix = len;
                last = true;
            } else {
                name = input.substring(ix, pos);
                ix = pos + 1;
            }
            path = path == null ? name : path + "." + name;
            subpath = subpath == null ? name : subpath + "." + name;
            this.m_targetProperty = pmm = MetaManager.getPropertyMeta(currentClass, (String)name);
            if (pmm.isPrimaryKey()) {
                if (previspk) {
                    throw new IllegalStateException("The path " + subpath + " is a PK property immediately followed by another Pk property- that cannot happen.");
                }
                previspk = true;
                this.pushPendingJoin(path, pmm);
                if (last) {
                    StringBuilder sb = this.sb();
                    sb.append(currentAlias);
                    this.createPendingJoinPath(sb);
                    return sb.toString();
                }
                currentClass = pmm.getActualType();
                continue;
            }
            if (pmm.getRelationType() == PropertyRelationType.DOWN) {
                if (allowDown && last) {
                    currentAlias = this.flushJoin(currentAlias);
                    StringBuilder sb = this.sb();
                    sb.append(currentAlias).append('.').append(name);
                    return sb.toString();
                }
                throw new IllegalStateException("You cannot query a value on a parent->child relation. Use an exists-subquery instead.");
            }
            if (pmm.getRelationType() != PropertyRelationType.NONE) {
                if (this.m_pendingJoinIx > 0 && !previspk) {
                    currentAlias = this.flushJoin(currentAlias);
                }
                this.pushPendingJoin(path, pmm);
                if (last) {
                    StringBuilder sb = this.sb();
                    sb.append(currentAlias);
                    this.createPendingJoinPath(sb);
                    return sb.toString();
                }
                currentClass = pmm.getActualType();
                previspk = false;
                continue;
            }
            if (!last) {
                throw new QQuerySyntaxException("Property " + subpath + " in path " + input + " must be a parent relation or a compound primary key (property=" + pmm + ")");
            }
            if (previspk) {
                this.pushPendingJoin(path, pmm);
                StringBuilder sb = this.sb();
                sb.append(currentAlias);
                this.createPendingJoinPath(sb);
                return sb.toString();
            }
            currentAlias = this.flushJoin(currentAlias);
            StringBuilder sb = this.sb();
            sb.append(currentAlias).append('.').append(name);
            return sb.toString();
        }
        throw new IllegalStateException("Should be unreachable?");
    }

    private StringBuilder sb() {
        this.m_sb.setLength(0);
        return this.m_sb;
    }

    private void createPendingJoinPath(StringBuilder sb) {
        for (int i = 0; i < this.m_pendingJoinIx; ++i) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(this.m_pendingJoinProps[i].getName());
        }
    }

    private String flushJoin(String rootAlias) {
        if (this.m_pendingJoinIx <= 0) {
            throw new IllegalStateException("No join pending??");
        }
        this.m_sb.setLength(0);
        PropertyMetaModel<?> pmm = null;
        for (int i = 0; i < this.m_pendingJoinIx; ++i) {
            pmm = this.m_pendingJoinProps[i];
            if (this.m_sb.length() != 0) {
                this.m_sb.append('.');
            }
            this.m_sb.append(pmm.getName());
        }
        String subpath = this.m_sb.toString();
        String path = this.m_pendingJoinPaths[this.m_pendingJoinIx - 1];
        String alias = this.getPathAlias(rootAlias, path, subpath, pmm);
        this.m_pendingJoinIx = 0;
        return alias;
    }

    private String getPathAlias(String rootAlias, String fullpath, String relativepath, PropertyMetaModel<?> pmm) {
        int joinType;
        String alias = this.m_aliasMap.get(fullpath);
        if (null != alias) {
            return alias;
        }
        String nextAlias = this.nextAlias();
        String aliasedPath = relativepath;
        if (rootAlias.length() > 0) {
            aliasedPath = rootAlias + "." + relativepath;
        }
        this.m_aliasMap.put(fullpath, nextAlias);
        int n = joinType = pmm.isRequired() ? 0 : 1;
        if (this.m_currentCriteria instanceof Criteria) {
            ((Criteria)this.m_currentCriteria).createAlias(aliasedPath, nextAlias, joinType);
        } else if (this.m_currentCriteria instanceof DetachedCriteria) {
            ((DetachedCriteria)this.m_currentCriteria).createAlias(aliasedPath, nextAlias, joinType);
        } else {
            throw new IllegalStateException("Unexpected current thing: " + this.m_currentCriteria);
        }
        return nextAlias;
    }

    private void pushPendingJoin(String path, PropertyMetaModel<?> pmm) {
        if (this.m_pendingJoinIx >= this.m_pendingJoinPaths.length) {
            throw new QQuerySyntaxException("The property path " + this.m_inputPath + " is too complex");
        }
        this.m_pendingJoinPaths[this.m_pendingJoinIx] = path;
        this.m_pendingJoinProps[this.m_pendingJoinIx++] = pmm;
    }

    public void visitPropertyComparison(QPropertyComparison n) throws Exception {
        QOperatorNode rhs = n.getExpr();
        String name = n.getProperty();
        QLiteral lit = null;
        if (rhs.getOperation() != QOperation.LITERAL) {
            if (rhs.getOperation() == QOperation.SELECTION_SUBQUERY) {
                this.handlePropertySubcriteriaComparison(n);
                return;
            }
            throw new IllegalStateException("Unknown operands to " + n.getOperation() + ": " + name + " and " + rhs.getOperation());
        }
        lit = (QLiteral)rhs;
        name = this.parseSubcriteria(name);
        SimpleExpression last = null;
        switch (n.getOperation()) {
            default: {
                throw new IllegalStateException("Unexpected operation: " + n.getOperation());
            }
            case EQ: {
                if (lit.getValue() == null) {
                    last = Restrictions.isNull((String)name);
                    break;
                }
                last = Restrictions.eq((String)name, (Object)lit.getValue());
                break;
            }
            case NE: {
                if (lit.getValue() == null) {
                    last = Restrictions.isNotNull((String)name);
                    break;
                }
                last = Restrictions.ne((String)name, (Object)lit.getValue());
                break;
            }
            case GT: {
                last = Restrictions.gt((String)name, (Object)lit.getValue());
                break;
            }
            case GE: {
                last = Restrictions.ge((String)name, (Object)lit.getValue());
                break;
            }
            case LT: {
                last = Restrictions.lt((String)name, (Object)lit.getValue());
                break;
            }
            case LE: {
                last = Restrictions.le((String)name, (Object)lit.getValue());
                break;
            }
            case LIKE: {
                this.handleLikeOperation(name, this.m_targetProperty, lit.getValue());
                return;
            }
            case ILIKE: {
                last = Restrictions.ilike((String)name, (Object)lit.getValue());
            }
        }
        this.m_last = last;
    }

    public void visitPropertyIn(@Nonnull QPropertyIn n) throws Exception {
        QOperatorNode rhs = n.getExpr();
        String name = n.getProperty();
        Object lit = null;
        if (rhs.getOperation() == QOperation.LITERAL) {
            Object litval = ((QLiteral)rhs).getValue();
            if (litval instanceof List) {
                name = this.parseSubcriteria(name);
                this.m_last = Restrictions.in((String)name, (Collection)((List)litval));
                return;
            }
            throw new QQuerySyntaxException("Unexpected value for 'in' operation: " + litval + ", should be List or subquery");
        }
        if (rhs.getOperation() == QOperation.SELECTION_SUBQUERY) {
            QSelectionSubquery qsq = (QSelectionSubquery)n.getExpr();
            qsq.visit((QNodeVisitor)this);
            String fullName = this.parseSubcriteria(n.getProperty());
            this.m_last = Subqueries.propertyIn((String)fullName, (DetachedCriteria)((DetachedCriteria)this.m_lastSubqueryCriteria));
            return;
        }
        throw new IllegalStateException("Unknown operands to " + n.getOperation() + ": " + name + " and " + rhs.getOperation());
    }

    private void handleLikeOperation(String name, PropertyMetaModel<?> pmm, Object value) throws Exception {
        if (!(value instanceof String)) {
            throw new QQuerySyntaxException("The argument to 'like' must be a string (and cannot be null), the value passed is: " + value);
        }
        if (pmm == null || pmm.getActualType() == String.class) {
            this.m_last = Restrictions.like((String)name, (Object)value);
            return;
        }
        ClassMetadata hibmd = this.m_session.getSessionFactory().getClassMetadata(pmm.getClassModel().getActualClass());
        if (null == hibmd) {
            throw new QQuerySyntaxException("Cannot obtain Hibernate metadata for property=" + pmm);
        }
        if (!(hibmd instanceof AbstractEntityPersister)) {
            throw new QQuerySyntaxException("Cannot obtain Hibernate metadata for property=" + pmm + ": expecting AbstractEntityPersister, got a " + hibmd.getClass());
        }
        AbstractEntityPersister aep = (AbstractEntityPersister)hibmd;
        String[] colar = this.getPropertyColumnNamesFromLousyMetadata(aep, name);
        if (colar.length != 1) {
            throw new IllegalStateException("Attempt to do a 'like' on a multi-column property: " + pmm);
        }
        String columnName = colar[0];
        int dotix = name.lastIndexOf(46);
        if (dotix == -1) {
            this.m_last = Restrictions.sqlRestriction((String)("{alias}." + columnName + " like ?"), (Object)value, (Type)Hibernate.STRING);
            return;
        }
        String sql = "{" + name + "} like ?";
        this.m_last = new HibernateAliasedSqlCriterion(sql, value, (Type)Hibernate.STRING);
    }

    @Nonnull
    private String[] getPropertyColumnNamesFromLousyMetadata(AbstractEntityPersister aep, String compoundName) {
        String name = compoundName;
        int dotix = compoundName.lastIndexOf(46);
        if (dotix != -1) {
            name = compoundName.substring(dotix + 1);
        }
        if (name.equals(aep.getIdentifierPropertyName())) {
            return aep.getIdentifierColumnNames();
        }
        int ix = aep.getPropertyIndex(name);
        if (ix < 0) {
            throw new QQuerySyntaxException("Cannot obtain Hibernate metadata for property=" + name + ": property index not found");
        }
        String[] colar = aep.getPropertyColumnNames(ix);
        if (colar == null || colar.length != 1) {
            throw new QQuerySyntaxException("'Like' cannot be done on multicolumn/0column property " + name);
        }
        return colar;
    }

    private void handlePropertySubcriteriaComparison(QPropertyComparison n) throws Exception {
        QSelectionSubquery qsq = (QSelectionSubquery)n.getExpr();
        qsq.visit((QNodeVisitor)this);
        String name = this.parseSubcriteria(n.getProperty());
        Criterion last = null;
        switch (n.getOperation()) {
            default: {
                throw new IllegalStateException("Unexpected operation: " + n.getOperation());
            }
            case EQ: {
                last = Subqueries.propertyIn((String)name, (DetachedCriteria)((DetachedCriteria)this.m_lastSubqueryCriteria));
                break;
            }
            case NE: {
                last = Subqueries.propertyNotIn((String)name, (DetachedCriteria)((DetachedCriteria)this.m_lastSubqueryCriteria));
            }
        }
        this.m_last = last;
    }

    public void visitBetween(QBetweenNode n) throws Exception {
        if (n.getA().getOperation() != QOperation.LITERAL || n.getB().getOperation() != QOperation.LITERAL) {
            throw new IllegalStateException("Expecting literals as 2nd and 3rd between parameter");
        }
        QLiteral a = (QLiteral)n.getA();
        QLiteral b = (QLiteral)n.getB();
        String name = n.getProp();
        name = this.parseSubcriteria(name);
        this.m_last = Restrictions.between((String)name, (Object)a.getValue(), (Object)b.getValue());
    }

    public void visitMulti(QMultiNode inn) throws Exception {
        Criterion c1 = null;
        block4: for (QOperatorNode n : inn.getChildren()) {
            n.visit((QNodeVisitor)this);
            if (c1 == null) {
                c1 = this.m_last;
                this.m_last = null;
                continue;
            }
            switch (inn.getOperation()) {
                default: {
                    throw new IllegalStateException("Unexpected operation: " + inn.getOperation());
                }
                case AND: {
                    if (this.m_last == null) continue block4;
                    c1 = Restrictions.and((Criterion)c1, (Criterion)this.m_last);
                    this.m_last = null;
                    continue block4;
                }
                case OR: 
            }
            if (this.m_last == null) continue;
            c1 = Restrictions.or((Criterion)c1, (Criterion)this.m_last);
            this.m_last = null;
        }
        this.m_last = c1;
    }

    public void visitOrder(QOrder o) throws Exception {
        String name = o.getProperty();
        name = this.parseSubcriteria(name);
        Order ho = o.getDirection() == QSortOrderDirection.ASC ? Order.asc((String)name) : Order.desc((String)name);
        this.addOrder(ho);
    }

    public void visitUnaryNode(QUnaryNode n) throws Exception {
        switch (n.getOperation()) {
            default: {
                throw new IllegalStateException("Unsupported UNARY operation: " + n.getOperation());
            }
            case SQL: {
                if (!(n.getNode() instanceof QLiteral)) break;
                QLiteral l = (QLiteral)n.getNode();
                String s = (String)l.getValue();
                this.m_last = Restrictions.sqlRestriction((String)s);
                return;
            }
            case NOT: {
                n.getNode().visit((QNodeVisitor)this);
                this.m_last = Restrictions.not((Criterion)this.m_last);
                return;
            }
        }
        throw new IllegalStateException("Unsupported UNARY operation: " + n.getOperation());
    }

    public void visitSqlRestriction(@Nonnull QSqlRestriction v) throws Exception {
        if (v.getParameters().length == 0) {
            this.m_last = Restrictions.sqlRestriction((String)v.getSql());
            return;
        }
        Type[] htar = new Type[v.getParameters().length];
        for (int i = 0; i < v.getTypes().length; ++i) {
            Class c = v.getTypes()[i];
            if (c == null) {
                throw new QQuerySyntaxException("Type array for SQLRestriction cannot contain null");
            }
            TypeHelper th = this.m_session.getTypeHelper();
            BasicType t = th.basic(c.getName());
            if (null == t) {
                throw new QQuerySyntaxException("Type[" + i + "] in type array (a " + c + ") is not a proper Hibernate type");
            }
            htar[i] = t;
        }
        this.m_last = Restrictions.sqlRestriction((String)v.getSql(), (Object[])v.getParameters(), (Type[])htar);
    }

    public void visitUnaryProperty(QUnaryProperty n) throws Exception {
        Criterion c;
        String name = n.getProperty();
        name = this.parseSubcriteria(name);
        switch (n.getOperation()) {
            default: {
                throw new IllegalStateException("Unsupported UNARY operation: " + n.getOperation());
            }
            case ISNOTNULL: {
                c = Restrictions.isNotNull((String)name);
                break;
            }
            case ISNULL: {
                c = Restrictions.isNull((String)name);
            }
        }
        this.m_last = c;
    }

    public void visitLiteral(QLiteral n) throws Exception {
        throw new IllegalStateException("? Unexpected literal: " + n);
    }

    public void visitExistsSubquery(QExistsSubquery<?> q) throws Exception {
        String parentAlias = this.getCurrentAlias();
        Class parentBaseClass = q.getParentQuery().getBaseClass();
        PropertyMetaModel pmm = MetaManager.getPropertyMeta((Class)parentBaseClass, (String)q.getParentProperty());
        String childListProperty = q.getParentProperty();
        int ldot = childListProperty.lastIndexOf(46);
        if (ldot != -1) {
            String last = this.parseSubcriteria(childListProperty, true);
            String parentpath = childListProperty.substring(0, ldot);
            childListProperty = childListProperty.substring(ldot + 1);
            PropertyMetaModel parentpm = MetaManager.getPropertyMeta((Class)parentBaseClass, (String)parentpath);
            parentBaseClass = parentpm.getActualType();
            ldot = last.indexOf(46);
            if (ldot < 0) {
                throw new IllegalStateException("Invalid result from parseSubcriteria inside exists.");
            }
            parentAlias = last.substring(0, ldot);
        }
        if (!List.class.isAssignableFrom(pmm.getActualType())) {
            throw new ProgrammerErrorException("The property '" + q.getParentQuery().getBaseClass() + "." + q.getParentProperty() + "' should be a list (it is a " + pmm.getActualType() + ")");
        }
        QOperatorNode where = q.getRestrictions();
        Class coltype = MetaManager.findCollectionType((java.lang.reflect.Type)pmm.getGenericActualType());
        if (coltype == null) {
            throw new ProgrammerErrorException("The property '" + q.getParentQuery().getBaseClass() + "." + q.getParentProperty() + "' has an undeterminable child type");
        }
        DetachedCriteria dc = DetachedCriteria.forClass((Class)coltype, (String)this.nextAlias());
        Criterion exists = Subqueries.exists((DetachedCriteria)dc);
        dc.setProjection((Projection)Projections.id());
        ClassMetadata childmd = this.m_session.getSessionFactory().getClassMetadata(coltype);
        ClassMetadata parentmd = this.m_session.getSessionFactory().getClassMetadata(parentBaseClass);
        int index = CriteriaCreatingVisitor.findMoronicPropertyIndexBecauseHibernateIsTooStupidToHaveAPropertyMetaDamnit(parentmd, childListProperty);
        if (index == -1) {
            throw new IllegalStateException("Hibernate does not know property '" + childListProperty + " in " + parentmd.getEntityName());
        }
        Type type = parentmd.getPropertyTypes()[index];
        CollectionType bt = (CollectionType)type;
        OneToManyPersister persister = (OneToManyPersister)((SessionFactoryImpl)this.m_session.getSessionFactory()).getCollectionPersister(bt.getRole());
        Object[] keyCols = persister.getKeyColumnNames();
        String childupprop = this.findCruddyChildProperty(childmd, (String[])keyCols);
        if (childupprop == null) {
            throw new IllegalStateException("Cannot find child's parent property in crufty Hibernate metadata: " + Arrays.toString(keyCols));
        }
        dc.add((Criterion)Restrictions.eqProperty((String)(childupprop + "." + childmd.getIdentifierPropertyName()), (String)(parentAlias + "." + parentmd.getIdentifierPropertyName())));
        Object old = this.m_currentCriteria;
        Class<?> oldroot = this.m_rootClass;
        Map<String, String> oldAliases = this.m_aliasMap;
        this.m_aliasMap = new HashMap<String, String>();
        this.m_rootClass = q.getBaseClass();
        this.checkHibernateClass(this.m_rootClass);
        this.m_currentCriteria = dc;
        if (where != null) {
            where.visit((QNodeVisitor)this);
        }
        if (this.m_last != null) {
            dc.add(this.m_last);
            this.m_last = null;
        }
        this.m_aliasMap = oldAliases;
        this.m_currentCriteria = old;
        this.m_rootClass = oldroot;
        this.m_last = exists;
    }

    private String getCurrentAlias() {
        if (this.m_currentCriteria instanceof Criteria) {
            return ((Criteria)this.m_currentCriteria).getAlias();
        }
        if (this.m_currentCriteria instanceof DetachedCriteria) {
            return ((DetachedCriteria)this.m_currentCriteria).getAlias();
        }
        throw new IllegalStateException("Unknown type");
    }

    private String findCruddyChildProperty(ClassMetadata cm, String[] keyCols) {
        Object[] cols;
        SingleTableEntityPersister fuckup = (SingleTableEntityPersister)cm;
        int i = fuckup.getPropertyNames().length;
        while (--i >= 0) {
            cols = fuckup.getPropertyColumnNames(i);
            if (!Arrays.equals(keyCols, cols)) continue;
            return cm.getPropertyNames()[i];
        }
        String idname = fuckup.getIdentifierPropertyName();
        cols = fuckup.getIdentifierColumnNames();
        if (Arrays.equals(keyCols, cols)) {
            return idname;
        }
        Type idtype = fuckup.getIdentifierType();
        if (idtype instanceof ComponentType) {
            ComponentType ct = (ComponentType)idtype;
            String[] xx = fuckup.getSubclassPropertyColumnNames(idname);
            String[] cpnar = ct.getPropertyNames();
            for (int i2 = 0; i2 < cpnar.length; ++i2) {
                String pname = cpnar[i2];
                cols = fuckup.getSubclassPropertyColumnNames(idname + "." + pname);
                if (!Arrays.equals(keyCols, cols)) continue;
                return idname + "." + pname;
            }
        }
        return null;
    }

    private static int findMoronicPropertyIndexBecauseHibernateIsTooStupidToHaveAPropertyMetaDamnit(ClassMetadata md, String name) {
        int i = md.getPropertyNames().length;
        while (--i >= 0) {
            if (!md.getPropertyNames()[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public void visitMultiSelection(QMultiSelection n) throws Exception {
        throw new ProgrammerErrorException("multi-operation selections not supported by Hibernate");
    }

    public void visitSelection(QSelection<?> s) throws Exception {
        if (this.m_proli != null) {
            throw new IllegalStateException("? Projection list already initialized??");
        }
        this.checkHibernateClass(s.getBaseClass());
        this.m_rootClass = s.getBaseClass();
        this.m_proli = Projections.projectionList();
        this.visitSelectionColumns(s);
        if (this.m_currentCriteria instanceof Criteria) {
            ((Criteria)this.m_currentCriteria).setProjection((Projection)this.m_proli);
        } else if (this.m_currentCriteria instanceof DetachedCriteria) {
            ((DetachedCriteria)this.m_currentCriteria).setProjection((Projection)this.m_proli);
        } else {
            throw new IllegalStateException("Unsupported current: " + this.m_currentCriteria);
        }
        this.visitRestrictionsBase((QCriteriaQueryBase<?>)s);
        this.visitOrderList(s.getOrder());
        this.handleFetch((QCriteriaQueryBase<?>)s);
    }

    public void visitSelectionColumn(QSelectionColumn n) throws Exception {
        n.getItem().visit((QNodeVisitor)this);
        if (this.m_lastProj != null) {
            this.m_proli.add(this.m_lastProj);
        }
    }

    public void visitSelectionItem(QSelectionItem n) throws Exception {
        throw new ProgrammerErrorException("Unexpected selection item: " + n);
    }

    public void visitPropertySelection(QPropertySelection n) throws Exception {
        String name = this.parseSubcriteria(n.getProperty());
        switch (n.getFunction()) {
            default: {
                throw new IllegalStateException("Unexpected selection item function: " + n.getFunction());
            }
            case AVG: {
                this.m_lastProj = Projections.avg((String)name);
                break;
            }
            case MAX: {
                this.m_lastProj = Projections.max((String)name);
                break;
            }
            case MIN: {
                this.m_lastProj = Projections.min((String)name);
                break;
            }
            case SUM: {
                this.m_lastProj = Projections.sum((String)name);
                break;
            }
            case COUNT: {
                this.m_lastProj = Projections.count((String)name);
                break;
            }
            case COUNT_DISTINCT: {
                this.m_lastProj = Projections.countDistinct((String)name);
                break;
            }
            case ID: {
                this.m_lastProj = Projections.id();
                break;
            }
            case PROPERTY: {
                this.m_lastProj = Projections.groupProperty((String)name);
                break;
            }
            case ROWCOUNT: {
                this.m_lastProj = Projections.rowCount();
                break;
            }
            case DISTINCT: {
                this.m_lastProj = Projections.distinct((Projection)Projections.property((String)name));
            }
        }
    }

    public void visitSubquery(@Nonnull QSubQuery<?, ?> n) throws Exception {
        n.getParent().internalUseQuery(n);
        this.visitSelection((QSelection<?>)n);
    }

    public void visitSelectionSubquery(final @Nonnull QSelectionSubquery n) throws Exception {
        DetachedCriteria dc = DetachedCriteria.forClass((Class)n.getSelectionQuery().getBaseClass(), (String)this.nextAlias());
        this.recurseSubquery(dc, n.getSelectionQuery(), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                n.getSelectionQuery().visit((QNodeVisitor)CriteriaCreatingVisitor.this);
                return null;
            }
        });
    }

    private void recurseSubquery(@Nonnull DetachedCriteria dc, @Nonnull QSelection<?> n, Callable<Void> callable) throws Exception {
        ProjectionList oldpro = this.m_proli;
        this.m_proli = null;
        Projection oldlastproj = this.m_lastProj;
        this.m_lastProj = null;
        Object oldCriteria = this.m_currentCriteria;
        Class<?> oldroot = this.m_rootClass;
        Map<String, String> oldAliases = this.m_aliasMap;
        this.m_aliasMap = new HashMap<String, String>();
        String oldParentAlias = this.m_parentAlias;
        this.m_parentAlias = this.getCurrentAlias();
        this.m_rootClass = n.getBaseClass();
        this.checkHibernateClass(this.m_rootClass);
        this.m_currentCriteria = dc;
        callable.call();
        if (this.m_last != null) {
            dc.add(this.m_last);
            this.m_last = null;
        }
        this.m_currentCriteria = oldCriteria;
        this.m_rootClass = oldroot;
        this.m_proli = oldpro;
        this.m_lastProj = oldlastproj;
        this.m_lastSubqueryCriteria = dc;
        this.m_aliasMap = oldAliases;
        this.m_parentAlias = oldParentAlias;
    }

    public void visitPropertyJoinComparison(@Nonnull QPropertyJoinComparison comparison) throws Exception {
        String alias = this.m_parentAlias + "." + this.parseSubcriteria(comparison.getParentProperty());
        switch (comparison.getOperation()) {
            default: {
                throw new QQuerySyntaxException("Unsupported parent-join operation: " + comparison.getOperation());
            }
            case EQ: {
                this.m_last = Restrictions.eqProperty((String)alias, (String)comparison.getSubProperty());
                break;
            }
            case NE: {
                this.m_last = Restrictions.neProperty((String)alias, (String)comparison.getSubProperty());
                break;
            }
            case LT: {
                this.m_last = Restrictions.ltProperty((String)alias, (String)comparison.getSubProperty());
                break;
            }
            case LE: {
                this.m_last = Restrictions.leProperty((String)alias, (String)comparison.getSubProperty());
                break;
            }
            case GT: {
                this.m_last = Restrictions.gtProperty((String)alias, (String)comparison.getSubProperty());
                break;
            }
            case GE: {
                this.m_last = Restrictions.geProperty((String)alias, (String)comparison.getSubProperty());
            }
        }
    }

    public void visitOrderList(@Nonnull List<QOrder> orderlist) throws Exception {
        for (QOrder o : orderlist) {
            o.visit((QNodeVisitor)this);
        }
    }

    public void visitSelectionColumns(@Nonnull QSelection<?> s) throws Exception {
        for (QSelectionColumn col : s.getColumnList()) {
            col.visit((QNodeVisitor)this);
        }
    }
}

