/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.hibernate.model;

import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.engine.TypedValue;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public final class HibernateAliasedSqlCriterion
implements Criterion {
    private static final long serialVersionUID = -4021078009045122349L;
    private final String m_sql;
    private final TypedValue[] m_typedValues;

    public HibernateAliasedSqlCriterion(String sql, Object[] values, Type[] types) {
        this.m_sql = sql;
        this.m_typedValues = new TypedValue[values.length];
        for (int i = 0; i < this.m_typedValues.length; ++i) {
            this.m_typedValues[i] = new TypedValue(types[i], values[i], EntityMode.POJO);
        }
    }

    public HibernateAliasedSqlCriterion(String sql, Object value, Type type) {
        this(sql, new Object[]{value}, new Type[]{type});
    }

    public HibernateAliasedSqlCriterion(String sql) {
        this(sql, ArrayHelper.EMPTY_OBJECT_ARRAY, ArrayHelper.EMPTY_TYPE_ARRAY);
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return this.applyAliases(criteria, criteriaQuery);
    }

    private String applyAliases(Criteria criteria, CriteriaQuery criteriaQuery) {
        int l;
        StringBuilder res = new StringBuilder();
        int i = 0;
        int length = this.m_sql.length();
        while (i < length && (l = this.m_sql.indexOf(123, i)) != -1) {
            String before = this.m_sql.substring(i, l);
            res.append(before);
            int r = this.m_sql.indexOf(125, ++l);
            if (r == -1) {
                throw new HibernateException("Missing '}' in sql string: " + this.m_sql);
            }
            String alias = this.m_sql.substring(l, r);
            if (alias.isEmpty() || "alias".equals(alias)) {
                res.append(criteriaQuery.getSQLAlias(criteria));
            } else {
                String[] columns = criteriaQuery.getColumnsUsingProjection(criteria, alias);
                if (columns.length != 1) {
                    throw new HibernateException("SQLAliasedCriterion may only be used with single-column properties: " + alias);
                }
                res.append(columns[0]);
            }
            i = r + 1;
        }
        String after = this.m_sql.substring(i, length);
        res.append(after);
        return res.toString();
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return this.m_typedValues;
    }

    public String toString() {
        return this.m_sql;
    }
}

